/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.util.regex.PatternSyntaxException;
import org.andromda.core.common.ExceptionUtils;
import org.apache.commons.lang.StringUtils;

public class PathMatcher {
    private static final String FORWARD_SLASH = "/";
    private static final String DOUBLE_STAR = "**/*";
    private static final String TRIPPLE_STAR = "***";

    public static boolean wildcardMatch(String path, String pattern) {
        boolean matches;
        boolean matchAll;
        ExceptionUtils.checkNull("path", path);
        ExceptionUtils.checkNull("pattern", pattern);
        if (path.startsWith(FORWARD_SLASH)) {
            path = path.substring(1, path.length());
        }
        path = path.trim();
        pattern = pattern.trim();
        boolean bl = matchAll = (pattern = StringUtils.replace((String)pattern, (String)".", (String)"\\.")).contains(DOUBLE_STAR) && !pattern.contains(TRIPPLE_STAR);
        if (matchAll) {
            String replacement = ".*";
            if (!path.contains(FORWARD_SLASH)) {
                replacement = ".*";
            }
            pattern = StringUtils.replaceOnce((String)pattern, (String)DOUBLE_STAR, (String)replacement);
        }
        pattern = StringUtils.replace((String)pattern, (String)"*", (String)".*");
        try {
            matches = path.matches(pattern);
        }
        catch (PatternSyntaxException exception) {
            matches = false;
        }
        if (!matchAll) {
            matches = matches && StringUtils.countMatches((String)pattern, (String)FORWARD_SLASH) == StringUtils.countMatches((String)path, (String)FORWARD_SLASH);
        }
        return matches;
    }
}

