/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class Paragraph {
    private StringBuffer currentLine = new StringBuffer();
    private int maxLineWidth;
    private final Collection<String> lines = new ArrayList<String>();

    public Paragraph(int lineLength) {
        this.maxLineWidth = lineLength;
    }

    public void appendWord(String word) {
        if (this.currentLine.length() + word.length() + 1 > this.maxLineWidth) {
            this.nextLine();
        }
        this.currentLine.append(' ');
        this.currentLine.append(word);
    }

    public void appendText(String text) {
        if (this.currentLine.length() + text.length() + 1 <= this.maxLineWidth) {
            this.currentLine.append(' ');
            this.currentLine.append(text);
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(text);
        while (tokenizer.hasMoreTokens()) {
            this.appendWord(tokenizer.nextToken());
        }
    }

    public Collection<String> getLines() {
        if (this.currentLine.length() > 0) {
            this.nextLine();
        }
        return this.lines;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (String line : this.getLines()) {
            buffer.append(line);
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private void nextLine() {
        this.lines.add(this.currentLine.toString());
        this.currentLine = new StringBuffer();
    }
}

