/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.MergerException;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.configuration.Property;
import org.andromda.core.mapping.Mapping;
import org.andromda.core.mapping.Mappings;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Merger {
    private static final Logger logger = Logger.getLogger(Merger.class);
    private static final Merger instance = new Merger();
    private final Map<String, Mappings> mergeMappingsCache = new LinkedHashMap<String, Mappings>();

    public static Merger instance() {
        return instance;
    }

    public String getMergedString(String string, String namespace) {
        if (namespace != null && string != null) {
            string = string.replaceAll("\\r", "");
            Collection<Mappings> mappingInstances = this.getMergeMappings(namespace);
            for (Mappings mergeMappings : mappingInstances) {
                Collection<Mapping> mappings = mergeMappings.getMappings();
                if (mappings == null || mappings.isEmpty()) continue;
                for (Mapping mapping : mappings) {
                    Collection<String> froms = mapping.getFroms();
                    for (String from : froms) {
                        if (!StringUtils.isNotBlank((String)(from = StringUtils.trimToEmpty((String)from))) || !string.contains(from)) continue;
                        String to = StringUtils.trimToEmpty((String)mapping.getTo());
                        string = StringUtils.replace((String)string, (String)from, (String)to);
                    }
                }
            }
        }
        return string;
    }

    public String getMergedString(InputStream inputStream, String namespace) {
        try {
            String string = IOUtils.toString((InputStream)inputStream);
            String string2 = this.getMergedString(string, namespace);
            return string2;
        }
        catch (Exception exception) {
            throw new MergerException(exception);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public boolean requiresMerge(String namespace) {
        Mappings mappings;
        boolean requiresMerge = false;
        Collection<Mappings> mergeMappings = this.getMergeMappings(namespace);
        Iterator<Mappings> i$ = mergeMappings.iterator();
        while (i$.hasNext() && !(requiresMerge = !(mappings = i$.next()).getMappings().isEmpty())) {
        }
        return requiresMerge;
    }

    private Collection<Mappings> getMergeMappings(String namespace) {
        Collection<Property> mergeMappingsUris;
        ArrayList<Mappings> mappings = new ArrayList<Mappings>();
        if (StringUtils.isNotBlank((String)namespace) && (mergeMappingsUris = Namespaces.instance().getProperties(namespace, "mergeMappingsUri", false)) != null) {
            for (Property mergeMappingsUri : mergeMappingsUris) {
                String mergeMappingsUriValue = mergeMappingsUri != null ? mergeMappingsUri.getValue() : null;
                if (!StringUtils.isNotBlank((String)mergeMappingsUriValue)) continue;
                Mappings mergeMappings = this.mergeMappingsCache.get(mergeMappingsUriValue);
                if (mergeMappings == null) {
                    try {
                        mergeMappings = Mappings.getInstance(mergeMappingsUriValue);
                        this.mergeMappingsCache.put(mergeMappingsUriValue, mergeMappings);
                    }
                    catch (Exception exception) {
                        if (ExceptionUtils.getRootCause(exception) instanceof FileNotFoundException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)exception);
                            }
                        }
                        throw new MergerException(exception);
                    }
                }
                if (mergeMappings == null) continue;
                mappings.add(mergeMappings);
            }
        }
        return mappings;
    }
}

