/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.andromda.core.common.Converter;
import org.andromda.core.common.IntrospectorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public final class Introspector {
    private static Introspector instance = null;
    private static final Logger logger = Logger.getLogger(Introspector.class);
    private static final char NESTED_DELIMITER = '.';
    private final Map<Class, Map<String, Method>> writeMethodsCache = new HashMap<Class, Map<String, Method>>();
    private final Map<Class, Map<String, Method>> readMethodsCache = new HashMap<Class, Map<String, Method>>();
    private final Map<Class, Map<String, PropertyDescriptor>> propertyDescriptorsCache = new HashMap<Class, Map<String, PropertyDescriptor>>();
    private Pattern propertyNamePattern = Pattern.compile("\\p{Lower}\\p{Upper}.*");
    private final Map<Object, String> evaluatingObjects = new HashMap<Object, String>();

    public static Introspector instance() {
        if (instance == null) {
            instance = new Introspector();
        }
        return instance;
    }

    public boolean containsValidProperty(Object object, String name, String value) {
        boolean valid;
        try {
            Object propertyValue = this.getProperty(object, name);
            boolean bl = valid = propertyValue != null;
            if (valid) {
                if (propertyValue instanceof Collection) {
                    valid = !((Collection)propertyValue).isEmpty();
                } else {
                    String valueAsString = String.valueOf(propertyValue);
                    if (StringUtils.isNotBlank((String)value)) {
                        valid = valueAsString.equals(value);
                    } else if (propertyValue instanceof Boolean) {
                        valid = Boolean.valueOf(valueAsString);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            valid = false;
        }
        return valid;
    }

    public void setProperty(Object object, String name, Object value) {
        this.setNestedProperty(object, name, value);
    }

    private void setNestedProperty(Object object, String name, Object value) {
        if (object != null && StringUtils.isNotBlank((String)name)) {
            int dotIndex = name.indexOf(46);
            if (dotIndex >= name.length()) {
                throw new IntrospectorException("Invalid property call --> '" + name + '\'');
            }
            String[] names = name.split("\\.");
            Object objectToPopulate = object;
            for (int ctr = 0; ctr < names.length; ++ctr) {
                name = names[ctr];
                if (ctr == names.length - 1) break;
                objectToPopulate = this.internalGetProperty(objectToPopulate, name);
            }
            this.internalSetProperty(objectToPopulate, name, value);
        }
    }

    public final Object getProperty(Object object, String name) {
        Object result;
        try {
            result = this.getNestedProperty(object, name);
        }
        catch (IntrospectorException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            throwable = ExceptionUtils.getRootCause((Throwable)throwable);
            if (throwable instanceof IntrospectorException) {
                throw (IntrospectorException)throwable;
            }
            throw new IntrospectorException(throwable);
        }
        return result;
    }

    private Object getNestedProperty(Object object, String name) {
        Object property = null;
        if (object != null && StringUtils.isNotBlank((String)name)) {
            int dotIndex = name.indexOf(46);
            if (dotIndex == -1) {
                property = this.internalGetProperty(object, name);
            } else {
                if (dotIndex >= name.length()) {
                    throw new IntrospectorException("Invalid property call --> '" + name + '\'');
                }
                Object nextInstance = this.internalGetProperty(object, name.substring(0, dotIndex));
                property = this.getNestedProperty(nextInstance, name.substring(dotIndex + 1));
            }
        }
        return property;
    }

    private Method getWriteMethod(Object object, String name) {
        Method writeMethod = null;
        Class<?> objectClass = object.getClass();
        Map<String, Method> classWriteMethods = this.writeMethodsCache.get(objectClass);
        if (classWriteMethods == null) {
            classWriteMethods = new HashMap<String, Method>();
        } else {
            writeMethod = classWriteMethods.get(name);
        }
        if (writeMethod == null) {
            PropertyDescriptor descriptor = this.getPropertyDescriptor(object.getClass(), name);
            Method method = writeMethod = descriptor != null ? descriptor.getWriteMethod() : null;
            if (writeMethod != null) {
                classWriteMethods.put(name, writeMethod);
                this.writeMethodsCache.put(objectClass, classWriteMethods);
            }
        }
        return writeMethod;
    }

    public boolean isReadable(Object object, String name) {
        return this.getReadMethod(object, name) != null;
    }

    public boolean isWritable(Object object, String name) {
        return this.getWriteMethod(object, name) != null;
    }

    private Method getReadMethod(Object object, String name) {
        Method readMethod = null;
        Class<?> objectClass = object.getClass();
        Map<String, Method> classReadMethods = this.readMethodsCache.get(objectClass);
        if (classReadMethods == null) {
            classReadMethods = new HashMap<String, Method>();
        } else {
            readMethod = classReadMethods.get(name);
        }
        if (readMethod == null) {
            PropertyDescriptor descriptor = this.getPropertyDescriptor(object.getClass(), name);
            Method method = readMethod = descriptor != null ? descriptor.getReadMethod() : null;
            if (readMethod != null) {
                classReadMethods.put(name, readMethod);
                this.readMethodsCache.put(objectClass, classReadMethods);
            }
        }
        return readMethod;
    }

    private PropertyDescriptor getPropertyDescriptor(Class type, String name) {
        PropertyDescriptor propertyDescriptor = null;
        Map<String, PropertyDescriptor> classPropertyDescriptors = this.propertyDescriptorsCache.get(type);
        if (classPropertyDescriptors == null) {
            classPropertyDescriptors = new HashMap<String, PropertyDescriptor>();
        } else {
            propertyDescriptor = classPropertyDescriptors.get(name);
        }
        if (propertyDescriptor == null) {
            try {
                for (PropertyDescriptor descriptor : java.beans.Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                    String compareName;
                    String string = compareName = this.propertyNamePattern.matcher(name).matches() ? StringUtils.capitalize((String)name) : name;
                    if (!descriptor.getName().equals(compareName)) continue;
                    propertyDescriptor = descriptor;
                    break;
                }
                if (propertyDescriptor == null && name.indexOf(46) != -1) {
                    int dotIndex = name.indexOf(46);
                    if (dotIndex >= name.length()) {
                        throw new IntrospectorException("Invalid property call --> '" + name + '\'');
                    }
                    PropertyDescriptor nextInstance = this.getPropertyDescriptor(type, name.substring(0, dotIndex));
                    propertyDescriptor = this.getPropertyDescriptor(nextInstance.getPropertyType(), name.substring(dotIndex + 1));
                }
            }
            catch (IntrospectionException exception) {
                throw new IntrospectorException(exception);
            }
            classPropertyDescriptors.put(name, propertyDescriptor);
            this.propertyDescriptorsCache.put(type, classPropertyDescriptors);
        }
        return propertyDescriptor;
    }

    private Object internalGetProperty(Object object, String name) {
        Object property = null;
        String value = this.evaluatingObjects.get(object);
        if (value == null || !value.equals(name)) {
            this.evaluatingObjects.put(object, name);
            if (object != null || StringUtils.isNotBlank((String)name)) {
                Method method = this.getReadMethod(object, name);
                if (method == null) {
                    throw new IntrospectorException("No readable property named '" + name + "', exists on object '" + object + '\'');
                }
                try {
                    property = method.invoke(object, (Object[])null);
                }
                catch (Throwable throwable) {
                    if (throwable.getCause() != null) {
                        throwable = throwable.getCause();
                    }
                    StackTraceElement[] trace = throwable.getStackTrace();
                    String location = " AT " + trace[0].getClassName() + '.' + trace[0].getMethodName() + ':' + trace[0].getLineNumber();
                    if (throwable.getMessage() != null) {
                        location = location + ' ' + throwable.getMessage();
                    }
                    logger.error((Object)("Introspector " + throwable + " invoking " + object + " METHOD " + method + " WITH " + name + location));
                    throw new IntrospectorException(throwable);
                }
            }
            this.evaluatingObjects.remove(object);
        }
        return property;
    }

    private void internalSetProperty(Object object, String name, Object value) {
        if (object != null || StringUtils.isNotBlank((String)name)) {
            Method method;
            PropertyDescriptor descriptor;
            Class<?> expectedType = null;
            if (value != null && object != null && (descriptor = this.getPropertyDescriptor(object.getClass(), name)) != null) {
                expectedType = this.getPropertyDescriptor(object.getClass(), name).getPropertyType();
                value = Converter.convert(value, expectedType);
            }
            if ((method = this.getWriteMethod(object, name)) == null) {
                throw new IntrospectorException("No writeable property named '" + name + "', exists on object '" + object + '\'');
            }
            try {
                method.invoke(object, value);
            }
            catch (Throwable throwable) {
                throw new IntrospectorException(throwable);
            }
        }
    }

    public void shutdown() {
        this.propertyDescriptorsCache.clear();
        this.writeMethodsCache.clear();
        this.readMethodsCache.clear();
        this.evaluatingObjects.clear();
        instance = null;
    }
}

