/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.IntrospectorException;
import org.apache.log4j.Logger;

public class Converter {
    private static final String VALUE_OF_METHOD_NAME = "valueOf";
    private static final Logger LOGGER = Logger.getLogger(Converter.class);
    private static final Map primitiveWrappers = new HashMap();

    public static Object convert(Object object, Class expectedType) {
        block11: {
            Method method = null;
            try {
                if (expectedType == String.class) {
                    object = object.toString();
                    break block11;
                }
                if (expectedType == Class.class) {
                    object = ClassUtils.loadClass(object.toString());
                    break block11;
                }
                Class originalType = expectedType;
                if (expectedType.isPrimitive()) {
                    expectedType = (Class)primitiveWrappers.get(expectedType);
                }
                try {
                    method = expectedType.getDeclaredMethod(VALUE_OF_METHOD_NAME, object.getClass());
                    object = method.invoke((Object)expectedType, object);
                }
                catch (NoSuchMethodException exception) {
                    // empty catch block
                }
                if (method != null) break block11;
                try {
                    Constructor constructor = expectedType.getConstructor(originalType);
                    object = constructor.newInstance(object);
                }
                catch (NoSuchMethodException exception) {
                    throw new IntrospectorException("Could not convert '" + object + "' to type '" + expectedType.getName() + '\'');
                }
            }
            catch (Throwable throwable) {
                if (throwable.getCause() != null) {
                    throwable = throwable.getCause();
                }
                StackTraceElement[] trace = throwable.getStackTrace();
                String location = " AT " + trace[0].getClassName() + '.' + trace[0].getMethodName() + ':' + trace[0].getLineNumber();
                if (throwable.getMessage() != null) {
                    location = location + ' ' + throwable.getMessage();
                }
                LOGGER.error((Object)("Converter " + throwable + " invoking " + object + " METHOD " + method + " WITH " + expectedType.getName() + location));
                throw new IntrospectorException(throwable);
            }
        }
        return object;
    }

    static {
        primitiveWrappers.put(Boolean.TYPE, Boolean.class);
        primitiveWrappers.put(Integer.TYPE, Integer.class);
        primitiveWrappers.put(Long.TYPE, Long.class);
        primitiveWrappers.put(Short.TYPE, Short.class);
        primitiveWrappers.put(Byte.TYPE, Byte.class);
        primitiveWrappers.put(Float.TYPE, Float.class);
        primitiveWrappers.put(Double.TYPE, Double.class);
        primitiveWrappers.put(Character.TYPE, Character.class);
    }
}

