/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.andromda.core.common.ClassUtilsException;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.ResourceUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ClassUtils
extends org.apache.commons.lang.ClassUtils {
    public static final String CLASS_EXTENSION = ".class";

    public static Object newInstance(String className) {
        try {
            return ClassUtils.loadClass(className).newInstance();
        }
        catch (Throwable throwable) {
            throw new ClassUtilsException(throwable);
        }
    }

    public static Object newInstance(Class type) {
        try {
            return type != null ? type.newInstance() : null;
        }
        catch (Throwable throwable) {
            throw new ClassUtilsException(throwable);
        }
    }

    public static Class loadClass(String className) {
        Class<?> loadedClass;
        ExceptionUtils.checkEmpty("className", className);
        className = StringUtils.trimToNull((String)className);
        className = StringUtils.replace((String)className, (String)"[]", (String)"");
        ClassLoader loader = ClassUtils.getClassLoader();
        try {
            loadedClass = ClassUtils.isPrimitiveType(className) ? ClassUtils.getPrimitiveClass(className, loader) : loader.loadClass(className);
        }
        catch (Throwable throwable) {
            throw new ClassUtilsException(throwable);
        }
        return loadedClass;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassUtils.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(loader);
        }
        return loader;
    }

    protected static Class getPrimitiveClass(String name, ClassLoader loader) {
        ExceptionUtils.checkEmpty("name", name);
        ExceptionUtils.checkNull("loader", loader);
        Class primitiveClass = null;
        if (ClassUtils.isPrimitiveType(name) && !"void".equals(name)) {
            String className = "char".equals(name) ? "Character" : ("int".equals(name) ? "Integer" : StringUtils.capitalize((String)name));
            try {
                if (StringUtils.isNotBlank((String)className)) {
                    Field field = loader.loadClass(className).getField("TYPE");
                    primitiveClass = (Class)field.get(null);
                }
            }
            catch (Exception exception) {
                throw new ClassUtilsException(exception);
            }
        }
        return primitiveClass;
    }

    public static Collection<Object> getStaticFieldValues(Class clazz, Class type) throws IllegalAccessException {
        ExceptionUtils.checkNull("clazz", clazz);
        Field[] fields = clazz.getFields();
        int fieldsNum = fields.length;
        ArrayList<Object> values = new ArrayList<Object>();
        for (int ctr = 0; ctr < fieldsNum; ++ctr) {
            Field field = fields[ctr];
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            if (type != null) {
                if (type != field.getType()) continue;
                values.add(fields[ctr].get(null));
                continue;
            }
            values.add(fields[ctr].get(null));
        }
        return values;
    }

    public static List<Class> getInterfaces(String className) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        if (StringUtils.isNotBlank((String)className)) {
            interfaces.addAll(ClassUtils.getInterfaces(ClassUtils.loadClass(className.trim())));
        }
        return interfaces;
    }

    public static List<Class> getInterfaces(Class clazz) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        if (clazz != null) {
            interfaces.addAll(ClassUtils.getAllInterfaces((Class)clazz));
            if (clazz.isInterface()) {
                interfaces.add(0, clazz);
            }
        }
        return interfaces;
    }

    public static Class[] getInterfacesReversed(String className) {
        List<Class> interfacesList = ClassUtils.getInterfaces(className);
        Object[] interfaces = interfacesList.toArray(new Class[interfacesList.size()]);
        if (interfaces.length > 0) {
            CollectionUtils.reverseArray((Object[])interfaces);
        }
        return interfaces;
    }

    protected static boolean isPrimitiveType(String name) {
        return "void".equals(name) || "char".equals(name) || "byte".equals(name) || "short".equals(name) || "int".equals(name) || "long".equals(name) || "float".equals(name) || "double".equals(name) || "boolean".equals(name);
    }

    public static Class findClassOfType(URL[] directoryUris, Class type) {
        Class<?> found = null;
        if (directoryUris != null && directoryUris.length > 0) {
            block2: for (URL directoryUri : directoryUris) {
                List<String> contents = ResourceUtils.getDirectoryContents(directoryUri, false, null);
                for (String path : contents) {
                    if (!path.endsWith(CLASS_EXTENSION)) continue;
                    String typeName = StringUtils.replace((String)ResourceUtils.normalizePath(path).replace('/', '.'), (String)CLASS_EXTENSION, (String)"");
                    try {
                        Class<?> loadedClass = ClassUtils.getClassLoader().loadClass(typeName);
                        if (!type.isAssignableFrom(loadedClass)) continue;
                        found = loadedClass;
                        continue block2;
                    }
                    catch (ClassNotFoundException exception) {
                    }
                }
            }
        }
        return found;
    }

    public static List<Method> getAllMethods(Class clazz) {
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        ClassUtils.loadMethods(clazz, methods);
        return new ArrayList<Method>(methods);
    }

    private static void loadMethods(Class clazz, Set<Method> methods) {
        methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        if (clazz.getSuperclass() != null) {
            ClassUtils.loadMethods(clazz.getSuperclass(), methods);
        }
    }

    public static boolean isClassOfTypePresent(URL[] directoryUris, Class type) {
        return ClassUtils.findClassOfType(directoryUris, type) != null;
    }
}

