/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.andromda.core.common.ExceptionRecorder;
import org.andromda.core.common.ResourceUtils;

public final class BuildInformation {
    private static final BuildInformation INSTANCE = new BuildInformation();
    private String buildDate;
    private String buildSystem;
    private String buildJdk;
    private String buildBuilder;
    private String buildVersion;

    public static BuildInformation instance() {
        return INSTANCE;
    }

    private BuildInformation() {
        this.initialize();
    }

    private void initialize() {
        String buildPropertiesUri = "META-INF/andromda-build.properties";
        String versionPropertyName = "andromda.build.version";
        String datePropertyName = "andromda.build.date";
        String systemPropertyName = "andromda.build.system";
        String jdkPropertyName = "andromda.build.jdk";
        String builderPropertyName = "andromda.build.builder";
        URL versionUri = ResourceUtils.getResource("META-INF/andromda-build.properties");
        try {
            if (versionUri == null) {
                throw new IllegalStateException("BuildInformation: could not load file --> 'META-INF/andromda-build.properties'");
            }
            Properties properties = new Properties();
            InputStream stream = versionUri.openStream();
            properties.load(stream);
            stream.close();
            this.buildDate = properties.getProperty("andromda.build.date");
            this.buildSystem = properties.getProperty("andromda.build.system");
            this.buildJdk = properties.getProperty("andromda.build.jdk");
            this.buildBuilder = properties.getProperty("andromda.build.builder");
            this.buildVersion = properties.getProperty("andromda.build.version");
        }
        catch (Throwable throwable) {
            ExceptionRecorder.instance().record(throwable);
            throw new IllegalStateException(throwable.getMessage());
        }
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public String getBuildBuilder() {
        return this.buildBuilder;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public String getBuildJdk() {
        return this.buildJdk;
    }

    public String getBuildSystem() {
        return this.buildSystem;
    }
}

