/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.Plugin;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.common.TemplateObject;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.configuration.Property;
import org.andromda.core.namespace.BaseNamespaceComponent;
import org.andromda.core.templateengine.TemplateEngine;
import org.apache.log4j.Logger;

public abstract class BasePlugin
extends BaseNamespaceComponent
implements Plugin {
    private final Collection<String> propertyReferences = new ArrayList<String>();
    private final Collection<TemplateObject> templateObjects = new ArrayList<TemplateObject>();
    private URL mergeLocation;
    private String templateEngineClass;
    private TemplateEngine templateEngine = null;
    private List<String> contents = null;

    @Override
    public void initialize() throws Exception {
        Property mergeProperty = Namespaces.instance().getProperty(this.getNamespace(), "mergeLocation", false);
        URL uRL = this.mergeLocation = mergeProperty != null ? new File(mergeProperty.getValue()).toURI().toURL() : null;
        if (this.mergeLocation != null) {
            this.getTemplateEngine().setMergeLocation(this.getMergeLocation().getFile());
        }
        this.getTemplateEngine().initialize(this.getNamespace());
        for (TemplateObject templateObject : this.templateObjects) {
            templateObject.setResource(this.getResource());
            templateObject.setNamespace(this.getNamespace());
        }
    }

    protected URL getMergeLocation() {
        return this.mergeLocation;
    }

    @Override
    public void shutdown() {
        this.getTemplateEngine().shutdown();
    }

    public void addTemplateObject(TemplateObject templateObject) {
        if (templateObject != null) {
            this.templateObjects.add(templateObject);
        }
    }

    public void addMacrolibrary(String macrolibrary) {
        this.getTemplateEngine().addMacroLibrary(macrolibrary);
    }

    @Override
    public Collection<TemplateObject> getTemplateObjects() {
        return this.templateObjects;
    }

    public void setTemplateEngineClass(String templateEngineClass) {
        this.templateEngineClass = templateEngineClass;
    }

    @Override
    public TemplateEngine getTemplateEngine() {
        if (this.templateEngine == null) {
            this.templateEngine = (TemplateEngine)ComponentContainer.instance().newComponent(this.templateEngineClass, TemplateEngine.class);
        }
        return this.templateEngine;
    }

    @Override
    public String[] getPropertyReferences() {
        return this.propertyReferences.toArray(new String[this.propertyReferences.size()]);
    }

    public void addPropertyReference(String reference) {
        this.propertyReferences.add(reference);
    }

    protected void populateTemplateContext(Map<String, Object> templateContext) {
        if (templateContext == null) {
            templateContext = new LinkedHashMap<String, Object>();
        }
        this.addTemplateObjectsToContext(templateContext);
        this.addPropertyReferencesToContext(templateContext);
    }

    private void addTemplateObjectsToContext(Map<String, Object> templateContext) {
        Collection<TemplateObject> templateObjects = this.getTemplateObjects();
        if (templateObjects != null && !templateObjects.isEmpty()) {
            for (TemplateObject templateObject : templateObjects) {
                templateContext.put(templateObject.getName(), templateObject.getObject());
            }
        }
    }

    private void addPropertyReferencesToContext(Map<String, Object> templateContext) {
        String[] propertyReferences = this.getPropertyReferences();
        if (propertyReferences != null && propertyReferences.length > 0) {
            Namespaces namespaces = Namespaces.instance();
            for (String reference : propertyReferences) {
                templateContext.put(reference, namespaces.getPropertyValue(this.getNamespace(), reference));
            }
        }
    }

    @Override
    public List<String> getContents() {
        if (this.contents == null) {
            if (ResourceUtils.isArchive(this.getResource())) {
                List<String> mergeContents;
                this.contents = ResourceUtils.getClassPathArchiveContents(this.getResource());
                if (this.getMergeLocation() != null && (mergeContents = ResourceUtils.getDirectoryContents(this.getMergeLocation(), 0)) != null && !mergeContents.isEmpty()) {
                    this.contents.addAll(mergeContents);
                }
            } else {
                this.contents = ResourceUtils.getDirectoryContents(this.getResource(), 2);
            }
        }
        return this.contents;
    }

    protected Logger getLogger() {
        return AndroMDALogger.getNamespaceLogger(this.getNamespace());
    }

    public String toString() {
        return super.toString() + '[' + this.getNamespace() + ']';
    }
}

