/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.io.InputStream;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class AndroMDALogger {
    private static final String DEFAULT_LOGGER_NAME = "AndroMDA";
    private static Logger logger = Logger.getLogger((String)"AndroMDA");
    private static String loggingConfigurationUri = null;

    public static void initialize() {
        String defaultConfiguration = "log4j.xml";
        URL url = null;
        String configuration = loggingConfigurationUri;
        if (StringUtils.isNotBlank((String)configuration)) {
            try {
                url = new URL(configuration);
                InputStream stream = url.openStream();
                stream.close();
                AndroMDALogger.configure(url);
                logger.info((Object)("Logging configured from external source --> '" + configuration + '\''));
            }
            catch (Throwable throwable) {
                url = AndroMDALogger.class.getResource(defaultConfiguration);
                AndroMDALogger.configure(url);
                logger.warn((Object)("Invalid logging configuration uri --> '" + configuration + '\''));
            }
        }
        if (url == null) {
            url = AndroMDALogger.class.getResource(defaultConfiguration);
            AndroMDALogger.configure(url);
        }
        if (url == null) {
            throw new RuntimeException("Could not find default logging configuration file '" + defaultConfiguration + '\'');
        }
    }

    public static void setLoggingConfigurationUri(String loggingConfigurationUri) {
        AndroMDALogger.loggingConfigurationUri = loggingConfigurationUri;
    }

    protected static void configure(URL logConfigurationXml) {
        try {
            DOMConfigurator.configure((URL)logConfigurationXml);
        }
        catch (Exception ex) {
            System.err.println("Unable to initialize logging system with configuration file '" + logConfigurationXml + "' --> using basic configuration.");
            BasicConfigurator.configure();
        }
    }

    public static Logger getNamespaceLogger(String namespaceName) {
        Logger logger = namespaceName != null && !"default".equals(namespaceName) ? Logger.getLogger((String)AndroMDALogger.getNamespaceLoggerName(namespaceName)) : Logger.getRootLogger();
        return logger;
    }

    public static String getNamespaceLoggerName(String namespace) {
        return "org.andromda.namespaces." + namespace;
    }

    public static String getNamespaceLogFileName(String namespace) {
        return "andromda-" + namespace + ".log";
    }

    public static void setSuffix(String suffix) {
        logger = AndroMDALogger.getSuffixLogger(suffix);
    }

    public static Logger getSuffixLogger(String suffix) {
        return Logger.getLogger((String)("AndroMDA:" + suffix));
    }

    public static boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    public static void reset() {
        logger = Logger.getLogger((String)DEFAULT_LOGGER_NAME);
    }

    public static void shutdown() {
        LogManager.shutdown();
    }

    public static void debug(Object object) {
        logger.debug(object);
    }

    public static void info(Object object) {
        logger.info(object);
    }

    public static void warn(Object object) {
        logger.warn(object);
    }

    public static void error(Object object) {
        logger.error(object);
    }
}

