/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.cartridge.template;

import java.io.File;
import org.andromda.core.cartridge.Resource;
import org.andromda.core.cartridge.template.ModelElements;
import org.andromda.core.cartridge.template.TemplateException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Template
extends Resource {
    private boolean generateEmptyFiles = false;
    private boolean outputToSingleFile = false;
    private boolean outputOnEmptyElements = true;
    private ModelElements supportedModelElements = new ModelElements();

    public void setGenerateEmptyFiles(boolean generateEmptyFiles) {
        this.generateEmptyFiles = generateEmptyFiles;
    }

    public boolean isGenerateEmptyFiles() {
        return this.generateEmptyFiles;
    }

    public File getOutputLocation(String metafacadeName, String packageName, File directory, String outputPattern) {
        if (StringUtils.isBlank((String)outputPattern)) {
            outputPattern = this.getOutputPattern();
        }
        File file = this.isOutputToSingleFile() ? super.getOutputLocation(new String[]{outputPattern}, directory, outputPattern) : super.getOutputLocation(new String[]{StringUtils.replace((String)StringUtils.trimToEmpty((String)packageName), (String)"::", (String)File.separator), metafacadeName}, directory, outputPattern);
        return file;
    }

    public ModelElements getSupportedModeElements() {
        String methodName = "Template.getModelElements";
        if (this.supportedModelElements == null) {
            throw new TemplateException("Template.getModelElements - supportedModelElements is null!");
        }
        return this.supportedModelElements;
    }

    public void setSupportedModelElements(ModelElements supportedModelElements) {
        this.supportedModelElements = supportedModelElements;
    }

    public boolean isOutputToSingleFile() {
        return this.outputToSingleFile;
    }

    public void setOutputToSingleFile(boolean outputToSingleFile) {
        this.outputToSingleFile = outputToSingleFile;
    }

    public boolean isOutputOnEmptyElements() {
        return this.outputOnEmptyElements;
    }

    public void setOutputOnEmptyElements(boolean outputOnEmptyElements) {
        this.outputOnEmptyElements = outputOnEmptyElements;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

