/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.cartridge.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.andromda.core.cartridge.template.ModelElement;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.metafacade.MetafacadeBase;
import org.apache.commons.lang.StringUtils;

public class ModelElements {
    private String variable;
    private final Collection<ModelElement> modelElements = new ArrayList<ModelElement>();

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        variable = StringUtils.trimToEmpty((String)variable);
        ExceptionUtils.checkEmpty("variable", variable);
        this.variable = variable;
    }

    public void addModelElement(ModelElement modelElement) {
        ExceptionUtils.checkNull("modelElement", modelElement);
        this.modelElements.add(modelElement);
    }

    public Set<MetafacadeBase> getAllMetafacades() {
        LinkedHashSet<MetafacadeBase> allMetafacades = new LinkedHashSet<MetafacadeBase>();
        for (ModelElement modelElement : this.modelElements) {
            allMetafacades.addAll(modelElement.getMetafacades());
        }
        return allMetafacades;
    }

    public Collection<ModelElement> getModelElements() {
        return this.modelElements;
    }

    public boolean isEmpty() {
        return this.modelElements.isEmpty();
    }
}

