/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.cartridge.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.andromda.core.cartridge.template.Type;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.Introspector;
import org.andromda.core.metafacade.MetafacadeBase;
import org.andromda.core.profile.Profile;
import org.apache.commons.lang.StringUtils;

public class ModelElement {
    private String stereotype;
    private final Collection<Type> types = new ArrayList<Type>();
    private String variable;
    private Collection<MetafacadeBase> metafacades = new ArrayList<MetafacadeBase>();

    public String getStereotype() {
        return Profile.instance().get(this.stereotype);
    }

    public boolean hasStereotype() {
        return this.stereotype != null;
    }

    public Collection<Type> getTypes() {
        return this.types;
    }

    public boolean hasTypes() {
        return !this.getTypes().isEmpty();
    }

    public void setStereotype(String stereotype) {
        this.stereotype = stereotype;
        ExceptionUtils.checkEmpty("stereotype", this.stereotype);
    }

    public void addType(Type type) {
        ExceptionUtils.checkNull("type", type);
        this.types.add(type);
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = StringUtils.trimToEmpty((String)variable);
    }

    public void setMetafacades(Collection<MetafacadeBase> metafacades) {
        ExceptionUtils.checkNull("metafacades", metafacades);
        this.metafacades = metafacades;
        this.applyTypeFiltering();
    }

    public Collection<MetafacadeBase> getMetafacades() {
        return this.metafacades;
    }

    private void applyTypeFiltering() {
        if (this.hasTypes()) {
            Iterator<MetafacadeBase> iterator = this.metafacades.iterator();
            while (iterator.hasNext()) {
                if (this.accept(iterator.next())) continue;
                iterator.remove();
            }
        }
    }

    private boolean accept(Object metafacade) {
        boolean accept = true;
        for (Type type : this.types) {
            if (!StringUtils.isNotBlank((String)type.getName())) continue;
            try {
                accept = ClassUtils.loadClass(type.getName()).isAssignableFrom(metafacade.getClass());
                if (!accept) continue;
                for (Type.Property property : type.getProperties()) {
                    accept = Introspector.instance().containsValidProperty(metafacade, property.getName(), property.getValue());
                    if (accept) continue;
                }
            }
            catch (Throwable throwable) {
                accept = false;
            }
        }
        return accept;
    }
}

