/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.cartridge;

import java.io.File;
import java.text.MessageFormat;
import org.andromda.core.cartridge.Cartridge;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.configuration.Property;
import org.apache.commons.lang.StringUtils;

public class Resource {
    private String outlet;
    private String outputCondition;
    private boolean overwrite = false;
    private boolean lastModifiedCheck;
    private String path;
    private Cartridge cartridge;
    private String outputPattern;

    public String getOutlet() {
        return this.outlet;
    }

    public void setOutlet(String outlet) {
        this.outlet = outlet;
    }

    public void setOutputCondition(String outputCondition) {
        this.outputCondition = outputCondition;
    }

    public String getOutputCondition() {
        return this.outputCondition;
    }

    public File getOutputLocation(Object[] arguments, File directory, String outputPattern) {
        File file = null;
        if (directory != null && arguments != null && arguments.length > 0) {
            String outputFileName;
            for (int ctr = 0; ctr < arguments.length; ++ctr) {
                arguments[ctr] = StringUtils.trimToEmpty((String)String.valueOf(arguments[ctr]));
            }
            if (StringUtils.isBlank((String)outputPattern)) {
                outputPattern = this.getOutputPattern();
            }
            try {
                outputFileName = MessageFormat.format(outputPattern, arguments);
            }
            catch (Exception exception) {
                outputFileName = outputPattern;
            }
            file = new File(directory, outputFileName);
        }
        return file;
    }

    public boolean isOverwrite() {
        Property property = Namespaces.instance().getProperty(this.getCartridge().getNamespace(), "overwrite", false);
        if (property != null) {
            this.overwrite = Boolean.valueOf(property.getValue());
        }
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setLastModifiedCheck(boolean lastModifiedCheck) {
        this.lastModifiedCheck = lastModifiedCheck;
    }

    public boolean isLastModifiedCheck() {
        return this.lastModifiedCheck;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Cartridge getCartridge() {
        return this.cartridge;
    }

    public void setCartridge(Cartridge cartridge) {
        this.cartridge = cartridge;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public String getOutputPattern() {
        return StringUtils.trimToEmpty((String)this.outputPattern);
    }
}

