/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.cartridge;

import java.io.File;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.andromda.core.cartridge.CartridgeException;
import org.andromda.core.cartridge.Resource;
import org.andromda.core.cartridge.template.ModelElement;
import org.andromda.core.cartridge.template.ModelElements;
import org.andromda.core.cartridge.template.Template;
import org.andromda.core.cartridge.template.Type;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.BasePlugin;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.Introspector;
import org.andromda.core.common.PathMatcher;
import org.andromda.core.common.PostProcessor;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.common.ResourceWriter;
import org.andromda.core.common.TemplateObject;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.metafacade.MetafacadeBase;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.core.metafacade.ModelAccessFacade;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Cartridge
extends BasePlugin {
    private static final Logger LOGGER = Logger.getLogger(Cartridge.class);
    private static final String FORWARD_SLASH = "/";
    private static final String PATH_PATTERN = "\\*.*";
    private final List<Resource> resources = new ArrayList<Resource>();
    private final Map<String, String> conditions = new LinkedHashMap<String, String>();
    private final Map<String, Boolean> evaluatedConditions = new LinkedHashMap<String, Boolean>();
    private final Collection<PostProcessor> templatePostProcessor = new ArrayList<PostProcessor>();
    private boolean conditionsEvaluated = false;

    public void processModelElements(MetafacadeFactory factory) {
        ExceptionUtils.checkNull("factory", factory);
        List<Resource> resources = this.getResources();
        if (resources != null && !resources.isEmpty()) {
            for (Resource resource : resources) {
                if (resource instanceof Template) {
                    this.processTemplate(factory, (Template)resource);
                    continue;
                }
                this.processResource(resource);
            }
        }
    }

    protected void processTemplate(MetafacadeFactory factory, Template template) {
        ExceptionUtils.checkNull("template", template);
        ModelElements templateModelElements = template.getSupportedModeElements();
        if (templateModelElements != null && !templateModelElements.isEmpty()) {
            for (ModelElement templateModelElement : templateModelElements.getModelElements()) {
                if (templateModelElement.hasStereotype()) {
                    templateModelElement.setMetafacades(factory.getMetafacadesByStereotype(templateModelElement.getStereotype()));
                    continue;
                }
                if (!templateModelElement.hasTypes()) continue;
                templateModelElement.setMetafacades(factory.getAllMetafacades());
            }
            this.processTemplateWithMetafacades(factory, template);
        } else {
            this.processTemplateWithoutMetafacades(template);
        }
    }

    protected void processTemplateWithMetafacades(MetafacadeFactory factory, Template template) {
        ExceptionUtils.checkNull("template", template);
        ModelElements modelElements = template.getSupportedModeElements();
        if (modelElements != null && !modelElements.isEmpty()) {
            try {
                Set<MetafacadeBase> allMetafacades = modelElements.getAllMetafacades();
                LOGGER.info((Object)("Processing " + template.getPath() + " with " + allMetafacades.size() + " metafacades from " + modelElements.getModelElements().size() + " model elements"));
                if (template.isOutputToSingleFile() && (template.isOutputOnEmptyElements() || !allMetafacades.isEmpty())) {
                    LinkedHashMap<String, Object> templateContext = new LinkedHashMap<String, Object>();
                    String modelElementsVariable = modelElements.getVariable();
                    if (StringUtils.isNotBlank((String)modelElementsVariable)) {
                        templateContext.put(modelElementsVariable, allMetafacades);
                    }
                    for (ModelElement modelElement : modelElements.getModelElements()) {
                        String modelElementVariable = modelElement.getVariable();
                        if (!StringUtils.isNotBlank((String)modelElementVariable)) continue;
                        Collection<MetafacadeBase> metafacades = (Collection<MetafacadeBase>)templateContext.get(modelElementVariable);
                        if (metafacades != null) {
                            metafacades.addAll(modelElement.getMetafacades());
                            continue;
                        }
                        metafacades = modelElement.getMetafacades();
                        templateContext.put(modelElementVariable, new LinkedHashSet<MetafacadeBase>(metafacades));
                    }
                    this.processWithTemplate(template, templateContext, null, null);
                } else {
                    for (MetafacadeBase metafacade : allMetafacades) {
                        LinkedHashMap<String, Object> templateContext = new LinkedHashMap<String, Object>();
                        ModelAccessFacade model = factory.getModel();
                        for (ModelElement modelElement : modelElements.getModelElements()) {
                            String variable = modelElement.getVariable();
                            if (StringUtils.isBlank((String)variable)) {
                                variable = modelElements.getVariable();
                            }
                            if (StringUtils.isNotBlank((String)variable)) {
                                templateContext.put(variable, metafacade);
                            }
                            if (this.processPropertyTemplates(template, metafacade, templateContext, modelElement)) continue;
                            this.processWithTemplate(template, templateContext, model.getName(metafacade), model.getPackageName(metafacade));
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throw new CartridgeException(throwable);
            }
        }
    }

    private boolean processPropertyTemplates(Template template, Object metafacade, Map<String, Object> templateContext, ModelElement modelElement) {
        boolean propertyTemplatesEvaluated = false;
        for (Type type : modelElement.getTypes()) {
            for (Type.Property property : type.getProperties()) {
                String variable = property.getVariable();
                propertyTemplatesEvaluated = StringUtils.isNotBlank((String)variable);
                if (!propertyTemplatesEvaluated) continue;
                Object value = Introspector.instance().getProperty(metafacade, property.getName());
                if (value instanceof Collection) {
                    for (Object entry : (Collection)value) {
                        templateContext.put(variable, entry);
                        this.processWithTemplate(template, templateContext, null, null);
                    }
                    continue;
                }
                templateContext.put(variable, value);
                this.processWithTemplate(template, templateContext, null, null);
            }
        }
        return propertyTemplatesEvaluated;
    }

    protected void processTemplateWithoutMetafacades(Template template) {
        ExceptionUtils.checkNull("template", template);
        LinkedHashMap<String, Object> templateContext = new LinkedHashMap<String, Object>();
        this.processWithTemplate(template, templateContext, null, null);
    }

    private void processWithTemplate(Template template, Map<String, Object> templateContext, String metafacadeName, String metafacadePackage) {
        ExceptionUtils.checkNull("template", template);
        ExceptionUtils.checkNull("templateContext", templateContext);
        File outputFile = null;
        try {
            this.populateTemplateContext(templateContext);
            StringWriter output = new StringWriter();
            this.getTemplateEngine().processTemplate(template.getPath(), templateContext, output);
            if (this.isValidOutputCondition(template.getOutputCondition(), templateContext)) {
                String location = Namespaces.instance().getPropertyValue(this.getNamespace(), this.getTemplateEngine().getEvaluatedExpression(template.getOutlet(), templateContext));
                if (location == null) {
                    LOGGER.warn((Object)("Template outlet location '" + template.getOutlet() + "' is not defined in namespace " + this.getNamespace()));
                } else {
                    outputFile = template.getOutputLocation(metafacadeName, metafacadePackage, new File(location), this.getTemplateEngine().getEvaluatedExpression(template.getOutputPattern(), templateContext));
                    if (outputFile == null) {
                        LOGGER.warn((Object)("Template outputFile is null for location " + location));
                    } else if (!outputFile.exists() || template.isOverwrite()) {
                        String outputString = output.toString();
                        AndroMDALogger.setSuffix(this.getNamespace());
                        if (StringUtils.isNotBlank((String)outputString) || template.isGenerateEmptyFiles()) {
                            for (PostProcessor postProcessor : this.getTemplatePostProcessor()) {
                                if (!postProcessor.acceptFile(outputFile)) continue;
                                try {
                                    String lResult = postProcessor.postProcess(outputString, null);
                                    if (StringUtils.isNotBlank((String)lResult)) {
                                        outputString = lResult;
                                        continue;
                                    }
                                    LOGGER.warn((Object)("Error PostProcessing " + outputFile.toURI()));
                                }
                                catch (Exception exc) {
                                    LOGGER.warn((Object)("Error PostProcessing " + outputFile.toURI() + ": " + exc.getMessage()));
                                }
                            }
                            ResourceWriter.instance().writeStringToFile(outputString, outputFile, this.getNamespace());
                            AndroMDALogger.info("Output: '" + outputFile.toURI() + '\'');
                        } else if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)("Empty Output: '" + outputFile.toURI() + "' --> not writing"));
                        }
                        AndroMDALogger.reset();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (FileUtils.deleteQuietly(outputFile)) {
                this.getLogger().info((Object)("Removed: '" + outputFile + '\''));
            }
            String message = "Error processing template '" + template.getPath() + "' with template context '" + templateContext + "' using cartridge '" + this.getNamespace() + '\'';
            throw new CartridgeException(message, throwable);
        }
    }

    protected void processResource(Resource resource) {
        ExceptionUtils.checkNull("resource", resource);
        URL resourceUrl = ResourceUtils.getResource(resource.getPath(), this.getMergeLocation());
        if (resourceUrl == null) {
            List<String> contents = this.getContents();
            if (contents != null) {
                AndroMDALogger.setSuffix(this.getNamespace());
                for (String content : contents) {
                    if (!StringUtils.isNotBlank((String)content) || !PathMatcher.wildcardMatch(content, resource.getPath()) || (resourceUrl = ResourceUtils.getResource(content, this.getMergeLocation())).toString().endsWith(FORWARD_SLASH)) continue;
                    this.writeResource(resource, resourceUrl);
                }
                AndroMDALogger.reset();
            }
        } else {
            this.writeResource(resource, resourceUrl);
        }
    }

    private void writeResource(Resource resource, URL resourceUrl) {
        File outputFile = null;
        try {
            String location;
            String resourceUri = ResourceUtils.normalizePath(resourceUrl.toString());
            String uriSuffix = resource.getPath().replaceAll(PATH_PATTERN, "");
            uriSuffix = resourceUri.contains(uriSuffix) ? resourceUri.substring(resourceUri.indexOf(uriSuffix) + uriSuffix.length(), resourceUri.length()) : resourceUri.substring(resourceUri.lastIndexOf(FORWARD_SLASH), resourceUri.length());
            LinkedHashMap<String, Object> templateContext = new LinkedHashMap<String, Object>();
            this.populateTemplateContext(templateContext);
            if (this.isValidOutputCondition(resource.getOutputCondition(), templateContext) && (location = Namespaces.instance().getPropertyValue(this.getNamespace(), this.getTemplateEngine().getEvaluatedExpression(resource.getOutlet(), templateContext))) != null) {
                outputFile = resource.getOutputLocation(new String[]{uriSuffix}, new File(location), this.getTemplateEngine().getEvaluatedExpression(resource.getOutputPattern(), templateContext));
                boolean lastModifiedCheck = resource.isLastModifiedCheck();
                if ((!lastModifiedCheck || lastModifiedCheck && ResourceUtils.getLastModifiedTime(resourceUrl) > outputFile.lastModified()) && (!outputFile.exists() || resource.isOverwrite())) {
                    ResourceWriter.instance().writeUrlToFile(resourceUrl, outputFile.toString());
                    AndroMDALogger.info("Output: '" + outputFile.toURI() + '\'');
                }
            }
        }
        catch (Throwable throwable) {
            if (outputFile != null) {
                outputFile.delete();
                this.getLogger().info((Object)("Removed: '" + outputFile + '\''));
            }
            throw new CartridgeException(throwable);
        }
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void addResource(Resource resource) {
        ExceptionUtils.checkNull("resource", resource);
        resource.setCartridge(this);
        this.resources.add(resource);
    }

    @Override
    protected void populateTemplateContext(Map<String, Object> templateContext) {
        super.populateTemplateContext(templateContext);
        templateContext.putAll(this.getEvaluatedConditions(templateContext));
    }

    public void addCondition(String name, String value) {
        this.conditions.put(name, StringUtils.trimToEmpty((String)value));
    }

    public Map<String, String> getConditions() {
        return this.conditions;
    }

    private Map<String, Boolean> getEvaluatedConditions(Map<String, Object> templateContext) {
        if (!this.conditionsEvaluated) {
            for (Map.Entry<String, String> entry : this.conditions.entrySet()) {
                String value = entry.getValue();
                if (!StringUtils.isNotBlank((String)value)) continue;
                String evaluationResult = this.getTemplateEngine().getEvaluatedExpression(value, templateContext);
                String name = entry.getKey();
                this.evaluatedConditions.put(name, BooleanUtils.toBoolean((String)evaluationResult));
            }
            this.conditionsEvaluated = true;
        }
        return this.evaluatedConditions;
    }

    private Boolean getGlobalConditionResult(String outputCondition, Map<String, Object> templateContext) {
        return this.getEvaluatedConditions(templateContext).get(outputCondition);
    }

    private boolean isValidOutputCondition(String outputCondition, Map<String, Object> templateContext) {
        boolean validOutputCondition = true;
        if (StringUtils.isNotBlank((String)outputCondition)) {
            Boolean result = this.getGlobalConditionResult(outputCondition, templateContext);
            if (result == null) {
                String outputConditionResult = this.getTemplateEngine().getEvaluatedExpression(outputCondition, templateContext);
                result = outputConditionResult != null ? Boolean.valueOf(BooleanUtils.toBoolean((String)outputConditionResult.trim())) : null;
            }
            validOutputCondition = BooleanUtils.toBoolean((Boolean)result);
        }
        return validOutputCondition;
    }

    public Collection<PostProcessor> getTemplatePostProcessor() {
        return this.templatePostProcessor;
    }

    public void addTemplatePostProcessor(TemplateObject postProcessor) {
        PostProcessor lPostProcessor = (PostProcessor)postProcessor.getObject();
        this.templatePostProcessor.add(lPostProcessor);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.conditions.clear();
        this.evaluatedConditions.clear();
        this.templatePostProcessor.clear();
    }
}

