/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core;

import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.configuration.Configuration;
import org.andromda.core.server.Client;
import org.andromda.core.server.ClientException;
import org.andromda.core.server.Server;
import org.andromda.core.server.ServerException;

public final class AndroMDAServer {
    private Server server;

    public static AndroMDAServer newInstance() {
        return new AndroMDAServer();
    }

    private AndroMDAServer() {
        AndroMDALogger.initialize();
        this.server = (Server)ComponentContainer.instance().findRequiredComponent(Server.class);
    }

    public void start(Configuration configuration) {
        if (configuration == null) {
            throw new ServerException("You must specify a valid 'configuration' in order to start the server");
        }
        org.andromda.core.configuration.Server serverConfiguration = configuration.getServer();
        if (serverConfiguration == null) {
            AndroMDALogger.warn("Can not start the server, you must define the server element within your AndroMDA configuration");
        } else {
            this.server.start(configuration);
        }
    }

    public void stop(Configuration configuration) {
        ComponentContainer container = ComponentContainer.instance();
        Client serverClient = (Client)container.findComponent(Client.class);
        if (serverClient != null) {
            try {
                serverClient.stop(configuration);
            }
            catch (Throwable throwable) {
                throw new ClientException(throwable);
            }
        }
    }
}

