/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core;

import java.io.EOFException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URL;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.configuration.Configuration;
import org.andromda.core.engine.Engine;
import org.andromda.core.metafacade.ModelValidationMessage;
import org.andromda.core.server.Client;
import org.apache.log4j.Logger;

public final class AndroMDA {
    private static final Logger LOGGER = Logger.getLogger(AndroMDA.class);
    private Engine engine;

    public static AndroMDA newInstance() {
        return new AndroMDA();
    }

    private AndroMDA() {
        AndroMDALogger.initialize();
        this.engine = Engine.newInstance();
    }

    public void run(URL configurationUri) {
        ExceptionUtils.checkNull("configurationUri", configurationUri);
        this.run(Configuration.getInstance(configurationUri), false, null);
    }

    public void run(InputStream configurationStream) {
        ExceptionUtils.checkNull("configurationStream", configurationStream);
        this.run(Configuration.getInstance(configurationStream), false, null);
    }

    public void run(String configuration) {
        ExceptionUtils.checkEmpty("configuration", configuration);
        this.run(Configuration.getInstance(configuration), false, null);
    }

    public void initialize(Configuration configuration) {
        ExceptionUtils.checkNull("configuration", configuration);
        this.engine.initialize(configuration);
    }

    public void initialize(InputStream configurationStream) {
        ExceptionUtils.checkNull("configurationStream", configurationStream);
        this.engine.initialize(Configuration.getInstance(configurationStream));
    }

    public void initialize(String configuration) {
        ExceptionUtils.checkEmpty("configuration", configuration);
        this.engine.initialize(Configuration.getInstance(configuration));
    }

    public void initialize(URL configurationUri) {
        ExceptionUtils.checkNull("configurationUri", configurationUri);
        this.run(Configuration.getInstance(configurationUri), false, null);
    }

    public ModelValidationMessage[] run(Configuration configuration, boolean lastModifiedCheck, String historyDir) {
        ModelValidationMessage[] messages = null;
        if (configuration != null) {
            Client serverClient = (Client)ComponentContainer.instance().findRequiredComponent(Client.class);
            boolean client = true;
            if (configuration.getServer() != null) {
                try {
                    serverClient.start(configuration);
                }
                catch (Throwable throwable) {
                    Throwable cause = ExceptionUtils.getRootCause(throwable);
                    if (cause instanceof ConnectException || cause instanceof EOFException) {
                        client = false;
                    }
                    throw new RuntimeException(throwable);
                }
            } else {
                client = false;
            }
            if (!client) {
                this.engine.initialize(configuration);
                messages = this.engine.run(configuration, lastModifiedCheck, historyDir);
            }
        } else {
            LOGGER.warn((Object)"AndroMDA could not run because no configuration was defined");
        }
        return messages == null ? new ModelValidationMessage[]{} : messages;
    }

    public void shutdown() {
        this.engine.shutdown();
    }
}

