/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SessionFactory;
import org.alfresco.jlan.client.SessionSettings;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestConfiguration;
import org.alfresco.jlan.test.cluster.TestResult;
import org.alfresco.jlan.test.cluster.TestServer;

public class ClusterTest {
    private static long BarrierWaitTimeout = 60L;
    private TestConfiguration m_config;
    private TestThread[] m_testThreads;
    private CyclicBarrier m_startBarrier;
    private CyclicBarrier m_stopBarrier;
    private BitSet m_testDone;
    private TestResult[] m_results;
    private TestResult m_didNotFinishResult = new BooleanTestResult(false, "Test thread did not complete");

    public ClusterTest(String[] args) throws Exception {
        this.m_config = new TestConfiguration();
        this.m_config.loadConfiguration(args[0]);
    }

    public void runTests() {
        try {
            Provider provider = (Provider)Class.forName("cryptix.jce.provider.CryptixCrypto").newInstance();
            Security.addProvider(provider);
        }
        catch (Exception ex) {
            Debug.println(ex);
        }
        SessionFactory.setSMBSigningEnabled(false);
        Debug.println("----- Cluster Tests Running --- " + new Date() + " -----");
        Debug.println("Run tests: " + (this.m_config.runInterleaved() ? "Interleaved" : "Sequentially"));
        Debug.println("Threads per server: " + this.m_config.getThreadsPerServer());
        Debug.println("");
        Debug.println("Servers configured:");
        for (TestServer testSrv : this.m_config.getServerList()) {
            Debug.print("  ");
            Debug.print(testSrv.getName());
        }
        Debug.println("");
        Debug.println("");
        Debug.println("Tests configured:");
        for (Test test : this.m_config.getTestList()) {
            Debug.print("  ");
            Debug.println(test.toString());
        }
        Debug.println("");
        int numTestThreads = this.m_config.getServerList().size() * this.m_config.getThreadsPerServer();
        this.m_startBarrier = new CyclicBarrier(numTestThreads);
        this.m_stopBarrier = new CyclicBarrier(numTestThreads);
        this.m_testDone = new BitSet(numTestThreads);
        this.m_results = new TestResult[numTestThreads];
        for (Test curTest : this.m_config.getTestList()) {
            Debug.println("----- Start test " + curTest.getName() + " --- " + new Date() + " -----");
            this.m_testThreads = new TestThread[numTestThreads];
            int idx = 0;
            for (TestServer curSrv : this.m_config.getServerList()) {
                for (int perSrv = 0; perSrv < this.m_config.getThreadsPerServer(); ++perSrv) {
                    TestThread testThread;
                    this.m_testThreads[idx] = testThread = new TestThread(curSrv, curTest, idx + 1, curTest.getIterations());
                    ++idx;
                    testThread.setDaemon(true);
                    testThread.start();
                }
            }
            int waitThread = this.m_testThreads.length;
            while (waitThread > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                waitThread = 0;
                for (TestThread testThread : this.m_testThreads) {
                    if (testThread.isComplete()) continue;
                    ++waitThread;
                }
            }
            for (int i = 0; i < this.m_testThreads.length; ++i) {
                TestThread curThread = this.m_testThreads[i];
                if (!curThread.isAlive()) continue;
                curThread.interrupt();
            }
            this.m_testThreads = null;
            System.gc();
            Debug.println("----- End test " + curTest.getName() + " --- " + new Date() + " -----");
        }
        Debug.println("-- End all tests --- " + new Date() + " --");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: <testConfig XML file>");
            System.exit(1);
        }
        try {
            ClusterTest clusterTest = new ClusterTest(args);
            clusterTest.runTests();
        }
        catch (Exception ex) {
            Debug.println(ex);
        }
    }

    class TestThread
    extends Thread {
        private String m_name;
        private int m_id;
        private int m_iter;
        private TestServer m_server;
        private Test m_test;
        private boolean m_wait;
        private boolean m_complete;

        public TestThread(TestServer server, Test test, int id, int iter) {
            this.m_server = server;
            this.m_test = test;
            this.m_name = this.m_test.getName() + "_" + id;
            this.m_id = id;
            this.m_iter = iter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName(this.m_name);
            if (this.m_test.isVerbose()) {
                Debug.println(this.m_name + " running, using server " + this.m_server.getName());
            }
            this.m_complete = false;
            PCShare share = null;
            DiskSession sess = null;
            boolean initOK = false;
            try {
                share = new PCShare(this.m_server.getName(), this.m_server.getShareName(), this.m_server.getUserName(), this.m_server.getPassword());
                SessionSettings sessSettings = new SessionSettings();
                sessSettings.setVirtualCircuit(this.m_id);
                sess = SessionFactory.OpenDisk(share, sessSettings);
                sess.setProcessId(this.m_id);
                if (this.m_test.getPath() != null) {
                    if (this.isPrimaryThread() && !sess.FileExists(this.m_test.getPath())) {
                        sess.CreateDirectory(this.m_test.getPath());
                    }
                    sess.setWorkingDirectory(this.m_test.getPath());
                }
                this.waitAtStartBarrier();
                initOK = this.m_test.initTest(this.m_id, this.m_iter, sess);
                if (!initOK) {
                    Debug.println("Failed to initialize test " + this.m_test.getName());
                }
                ((ClusterTest)ClusterTest.this).m_results[this.m_id - 1] = ClusterTest.this.m_didNotFinishResult;
                this.waitAtStopBarrier();
            }
            catch (Exception ex) {
                Debug.println("Error server=" + this.m_server);
                Debug.println(ex);
            }
            finally {
                if (!initOK && sess != null) {
                    try {
                        sess.CloseSession();
                        sess = null;
                    }
                    catch (Exception ex) {}
                }
            }
            if (sess != null) {
                for (int iteration = 1; iteration <= this.m_iter; ++iteration) {
                    if (!this.m_test.runInit(this.m_id, iteration, sess)) {
                        Debug.println("Run initialization failed, id=" + this.m_id + ", iter=" + iteration);
                    }
                    StringWriter testLog = new StringWriter(512);
                    this.waitAtStartBarrier();
                    try {
                        TestResult result;
                        if (this.m_id == 1) {
                            Debug.println("------- Start iteration " + iteration + " for " + this.m_test.getName() + " --- " + new Date() + " -----");
                        }
                        ((ClusterTest)ClusterTest.this).m_results[this.m_id - 1] = result = this.m_test.runTest(this.m_id, iteration, sess, testLog);
                    }
                    catch (Exception ex) {
                        Debug.println(ex);
                    }
                    this.waitAtStopBarrier();
                    if (this.m_test.hasTestCleanup()) {
                        this.waitAtStartBarrier();
                        try {
                            this.m_test.cleanupTest(this.m_id, iteration, sess, testLog);
                        }
                        catch (Exception ex) {
                            Debug.println(this.getName() + " Exception during cleanup");
                            Debug.println(ex);
                        }
                        this.waitAtStopBarrier();
                    }
                    if (testLog.getBuffer().length() > 0) {
                        Debug.println(testLog.toString());
                    }
                    if (this.m_id != 1) continue;
                    List<TestResult> resultsList = Arrays.asList(ClusterTest.this.m_results);
                    TestResult finalResult = this.m_test.processTestResults(resultsList);
                    if (!finalResult.isSuccess()) {
                        Debug.println("Final test result: " + finalResult);
                        Debug.println("Test results:");
                        for (TestResult result : resultsList) {
                            Debug.println("" + result);
                        }
                        Debug.println("");
                    }
                    Debug.println("------- End iteration " + iteration + " for " + this.m_test.getName() + "   --- " + new Date() + " -----");
                }
                try {
                    sess.CloseSession();
                }
                catch (Exception ex) {
                    Debug.println(ex);
                }
            }
            this.m_complete = true;
        }

        public final boolean isComplete() {
            return this.m_complete;
        }

        public boolean isWaiting() {
            return this.m_wait;
        }

        public boolean isPrimaryThread() {
            return this.m_id == 1;
        }

        protected void waitAtStartBarrier() {
            try {
                if (this.m_id == 1) {
                    ClusterTest.this.m_stopBarrier.reset();
                }
                this.m_wait = true;
                ClusterTest.this.m_startBarrier.await(BarrierWaitTimeout, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.m_wait = false;
        }

        protected void waitAtStopBarrier() {
            try {
                if (this.m_id == 1) {
                    ClusterTest.this.m_startBarrier.reset();
                }
                this.m_wait = true;
                ClusterTest.this.m_stopBarrier.await(BarrierWaitTimeout, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.m_wait = false;
        }
    }
}

