/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth;

import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.CifsAuthenticator;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.auth.UserAccount;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.smb.server.SMBSrvSession;

public class LocalAuthenticator
extends CifsAuthenticator {
    public LocalAuthenticator() {
        this.setAccessMode(1);
        this.setExtendedSecurity(false);
    }

    @Override
    public int authenticateShareConnect(ClientInfo client, SharedDevice share, String pwd, SrvSession sess) {
        if (this.getAccessMode() == 0) {
            return 2;
        }
        if (share.getType() == 3) {
            return 2;
        }
        UserAccount user = null;
        if (client != null) {
            user = this.getUserDetails(client.getUserName());
        }
        if (user == null) {
            return this.allowGuest() ? 2 : 0;
        }
        if (!user.hasShare(share.getName())) {
            return 0;
        }
        return 2;
    }

    @Override
    public int authenticateUser(ClientInfo client, SrvSession sess, int alg) {
        UserAccount userAcc = this.getUserDetails(client.getUserName());
        if (userAcc != null) {
            boolean authSts = false;
            if (client.getPassword() != null) {
                authSts = this.validatePassword(userAcc, client, sess.getAuthenticationContext(), alg);
            } else if (client.hasANSIPassword()) {
                authSts = this.validatePassword(userAcc, client, sess.getAuthenticationContext(), 0);
            }
            return authSts ? 0 : -2;
        }
        if (client.isNullSession() && sess instanceof SMBSrvSession) {
            return 0;
        }
        return this.allowGuest() ? 0x10000000 : -1;
    }
}

