/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.app;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.alfresco.jlan.app.CifsOnlyXMLServerConfiguration;
import org.alfresco.jlan.ftp.FTPConfigSection;
import org.alfresco.jlan.ftp.FTPPath;
import org.alfresco.jlan.ftp.FTPSiteInterface;
import org.alfresco.jlan.ftp.InvalidPathException;
import org.alfresco.jlan.oncrpc.nfs.NFSConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.filesys.cache.hazelcast.ClusterConfigSection;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.GenericConfigElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLServerConfiguration
extends CifsOnlyXMLServerConfiguration {
    private static final int DEFAULT_FTP_PORT = 21;
    private static final String ANONYMOUS_FTP_ACCOUNT = "anonymous";
    private static final String[] m_ftpDebugStr = new String[]{"STATE", "RXDATA", "TXDATA", "DUMPDATA", "SEARCH", "INFO", "FILE", "FILEIO", "ERROR", "PKTTYPE", "TIMING", "DATAPORT", "DIRECTORY", "SSL"};
    private static final String[] m_nfsDebugStr = new String[]{"RXDATA", "TXDATA", "DUMPDATA", "SEARCH", "INFO", "FILE", "FILEIO", "ERROR", "TIMING", "DIRECTORY", "SESSION"};
    private boolean m_cifsEnabled;
    private boolean m_ftpEnabled;
    private boolean m_nfsEnabled;

    @Override
    public void loadConfiguration(Document doc) throws IOException, InvalidConfigurationException {
        this.removeAllConfigSections();
        try {
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            this.procClusterElement(this.findChildNode("cluster", childNodes));
            this.procDebugElement(this.findChildNode("debug", childNodes));
            this.procServersElement(this.findChildNode("servers", childNodes));
            this.procServerCoreElement(this.findChildNode("server-core", childNodes));
            this.procGlobalElement(this.findChildNode("global", childNodes));
            this.procSecurityElement(this.findChildNode("security", childNodes));
            this.procSharesElement(this.findChildNode("shares", childNodes));
            if (this.isCIFSServerEnabled()) {
                this.procSMBServerElement(this.findChildNode("SMB", childNodes));
            }
            if (this.isFTPServerEnabled()) {
                this.procFTPServerElement(this.findChildNode("FTP", childNodes));
            }
            if (this.isNFSServerEnabled()) {
                this.procNFSServerElement(this.findChildNode("NFS", childNodes));
            }
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("XML error", ex);
        }
    }

    public final boolean isCIFSServerEnabled() {
        return this.m_cifsEnabled;
    }

    public final boolean isFTPServerEnabled() {
        return this.m_ftpEnabled;
    }

    public final boolean isNFSServerEnabled() {
        return this.m_nfsEnabled;
    }

    protected final void procServersElement(Element servers) throws InvalidConfigurationException {
        if (servers != null) {
            if (this.findChildNode("SMB", servers.getChildNodes()) != null || this.findChildNode("CIFS", servers.getChildNodes()) != null) {
                this.m_cifsEnabled = true;
            }
            if (this.findChildNode("FTP", servers.getChildNodes()) != null) {
                this.m_ftpEnabled = true;
            }
            if (this.findChildNode("NFS", servers.getChildNodes()) != null) {
                this.m_nfsEnabled = true;
            }
        }
    }

    protected final void procFTPServerElement(Element ftp) throws InvalidConfigurationException {
        Element elem;
        FTPConfigSection ftpConfig;
        block53: {
            if (ftp == null) {
                if (this.isFTPServerEnabled()) {
                    throw new InvalidConfigurationException("FTP server enabled, but not configured");
                }
                return;
            }
            ftpConfig = new FTPConfigSection(this);
            elem = this.findChildNode("bindto", ftp.getChildNodes());
            if (elem != null) {
                if (elem.hasAttribute("adapter")) {
                    InetAddress bindAddr = this.parseAdapterName(elem.getAttribute("adapter"));
                    ftpConfig.setFTPBindAddress(bindAddr);
                } else {
                    String bindText = this.getText(elem);
                    try {
                        InetAddress bindAddr = InetAddress.getByName(bindText);
                        ftpConfig.setFTPBindAddress(bindAddr);
                    }
                    catch (UnknownHostException ex) {
                        throw new InvalidConfigurationException(ex.toString());
                    }
                }
            }
            if ((elem = this.findChildNode("port", ftp.getChildNodes())) != null) {
                try {
                    ftpConfig.setFTPPort(Integer.parseInt(this.getText(elem)));
                    if (ftpConfig.getFTPPort() <= 0 || ftpConfig.getFTPPort() >= 65535) {
                        throw new InvalidConfigurationException("FTP server port out of valid range");
                    }
                    break block53;
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid FTP server port");
                }
            }
            ftpConfig.setFTPPort(21);
        }
        elem = this.findChildNode("allowAnonymous", ftp.getChildNodes());
        if (elem != null) {
            ftpConfig.setAllowAnonymousFTP(true);
            String anonAcc = elem.getAttribute("user");
            if (anonAcc != null && anonAcc.length() > 0) {
                ftpConfig.setAnonymousFTPAccount(anonAcc);
                if (ftpConfig.getAnonymousFTPAccount() == null || ftpConfig.getAnonymousFTPAccount().length() == 0) {
                    throw new InvalidConfigurationException("Anonymous FTP account invalid");
                }
            } else {
                ftpConfig.setAnonymousFTPAccount(ANONYMOUS_FTP_ACCOUNT);
            }
        } else {
            ftpConfig.setAllowAnonymousFTP(false);
        }
        elem = this.findChildNode("rootDirectory", ftp.getChildNodes());
        if (elem != null) {
            String rootPath = this.getText(elem);
            try {
                new FTPPath(rootPath);
                ftpConfig.setFTPRootPath(rootPath);
            }
            catch (InvalidPathException ex) {
                throw new InvalidConfigurationException("Invalid FTP root directory, " + rootPath);
            }
        }
        if ((elem = this.findChildNode("dataPorts", ftp.getChildNodes())) != null) {
            int rangeFrom = -1;
            int rangeTo = -1;
            String rangeStr = elem.getAttribute("rangeFrom");
            if (rangeStr != null && rangeStr.length() > 0) {
                try {
                    rangeFrom = Integer.parseInt(rangeStr);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid FTP rangeFrom value, " + rangeStr);
                }
            }
            if ((rangeStr = elem.getAttribute("rangeTo")) != null && rangeStr.length() > 0) {
                try {
                    rangeTo = Integer.parseInt(rangeStr);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid FTP rangeTo value, " + rangeStr);
                }
            }
            if (rangeFrom == -1 || rangeTo == -1) {
                throw new InvalidConfigurationException("FTP data port range from/to must be specified");
            }
            if (rangeFrom < 1024 || rangeFrom > 65535) {
                throw new InvalidConfigurationException("Invalid FTP data port rangeFrom value, " + rangeFrom);
            }
            if (rangeTo < 1024 || rangeTo > 65535) {
                throw new InvalidConfigurationException("Invalid FTP data port rangeTo value, " + rangeTo);
            }
            if (rangeFrom >= rangeTo) {
                throw new InvalidConfigurationException("Invalid FTP data port range, " + rangeFrom + "-" + rangeTo);
            }
            ftpConfig.setFTPDataPortLow(rangeFrom);
            ftpConfig.setFTPDataPortHigh(rangeTo);
        }
        if ((elem = this.findChildNode("debug", ftp.getChildNodes())) != null) {
            String flags = elem.getAttribute("flags");
            int ftpDbg = 0;
            if (flags != null) {
                flags = flags.toUpperCase();
                StringTokenizer token = new StringTokenizer(flags, ",");
                while (token.hasMoreTokens()) {
                    int idx;
                    String dbg = token.nextToken().trim();
                    for (idx = 0; idx < m_ftpDebugStr.length && !m_ftpDebugStr[idx].equalsIgnoreCase(dbg); ++idx) {
                    }
                    if (idx >= m_ftpDebugStr.length) {
                        throw new InvalidConfigurationException("Invalid FTP debug flag, " + dbg);
                    }
                    ftpDbg += 1 << idx;
                }
            }
            ftpConfig.setFTPDebug(ftpDbg);
        }
        if ((elem = this.findChildNode("siteInterface", ftp.getChildNodes())) != null) {
            Element classElem = this.findChildNode("class", elem.getChildNodes());
            if (classElem == null) {
                throw new InvalidConfigurationException("Class not specified for FTP site interface");
            }
            String siteClass = this.getText(classElem);
            try {
                Object siteObj = Class.forName(siteClass).newInstance();
                if (siteObj instanceof FTPSiteInterface) {
                    GenericConfigElement params = this.buildConfigElement(elem);
                    FTPSiteInterface ftpSiteInterface = (FTPSiteInterface)siteObj;
                    ftpSiteInterface.initializeSiteInterface(this, params);
                    ftpConfig.setFTPSiteInterface(ftpSiteInterface);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidConfigurationException("FTP site interface class " + siteClass + " not found");
            }
            catch (Exception ex) {
                throw new InvalidConfigurationException("FTP site interface setup error, " + ex.toString());
            }
        }
        if ((elem = this.findChildNode("authenticator", ftp.getChildNodes())) != null) {
            Element classElem = this.findChildNode("class", elem.getChildNodes());
            if (classElem == null) {
                throw new InvalidConfigurationException("FTP Authenticator class not specified");
            }
            GenericConfigElement params = this.buildConfigElement(elem);
            ftpConfig.setAuthenticator(this.getText(classElem), params);
        }
        if ((elem = this.findChildNode("keyStore", ftp.getChildNodes())) != null) {
            String keyStorePath = this.getText(elem);
            File keyStoreFile = new File(keyStorePath);
            if (!keyStoreFile.exists()) {
                throw new InvalidConfigurationException("FTPS key store file does not exist, " + keyStorePath);
            }
            if (keyStoreFile.isDirectory()) {
                throw new InvalidConfigurationException("FTPS key store path is a directory, " + keyStorePath);
            }
            ftpConfig.setKeyStorePath(keyStorePath);
        }
        if ((elem = this.findChildNode("trustStore", ftp.getChildNodes())) != null) {
            String trustStorePath = this.getText(elem);
            File trustStoreFile = new File(trustStorePath);
            if (!trustStoreFile.exists()) {
                throw new InvalidConfigurationException("FTPS trust store file does not exist, " + trustStorePath);
            }
            if (trustStoreFile.isDirectory()) {
                throw new InvalidConfigurationException("FTPS trust store path is a directory, " + trustStorePath);
            }
            ftpConfig.setTrustStorePath(trustStorePath);
        }
        if ((elem = this.findChildNode("storePassphrase", ftp.getChildNodes())) != null) {
            ftpConfig.setPassphrase(this.getText(elem));
        }
        if ((elem = this.findChildNode("requireSecureSession", ftp.getChildNodes())) != null) {
            ftpConfig.setRequireSecureSession(true);
        }
        if (!(ftpConfig.getKeyStorePath() == null && ftpConfig.getTrustStorePath() == null && ftpConfig.getPassphrase() == null || ftpConfig.getKeyStorePath() != null && ftpConfig.getTrustStorePath() != null && ftpConfig.getPassphrase() != null)) {
            throw new InvalidConfigurationException("FTPS configuration requires keyStore, trustStore and storePassphrase to be set");
        }
        elem = this.findChildNode("sslEngineDebug", ftp.getChildNodes());
        if (elem != null) {
            System.setProperty("javax.net.debug", "ssl,handshake");
        }
    }

    protected final void procNFSServerElement(Element nfs) throws InvalidConfigurationException {
        Element elem;
        if (nfs == null) {
            return;
        }
        NFSConfigSection nfsConfig = new NFSConfigSection(this);
        if (this.findChildNode("enablePortMapper", nfs.getChildNodes()) != null) {
            nfsConfig.setNFSPortMapper(true);
        }
        if ((elem = this.findChildNode("ThreadPool", nfs.getChildNodes())) == null) {
            elem = this.findChildNode("TCPThreadPool", nfs.getChildNodes());
        }
        if (elem != null) {
            try {
                int poolSize = Integer.parseInt(this.getText(elem));
                if (poolSize < 4) {
                    throw new InvalidConfigurationException("NFS thread pool size is below minimum of 4");
                }
                nfsConfig.setNFSThreadPoolSize(poolSize);
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid NFS thread pool size setting, " + this.getText(elem));
            }
        }
        if ((elem = this.findChildNode("PacketPool", nfs.getChildNodes())) != null) {
            try {
                int pktPoolSize = Integer.parseInt(this.getText(elem));
                if (pktPoolSize < 10) {
                    throw new InvalidConfigurationException("NFS packet pool size is below minimum of 10");
                }
                if (pktPoolSize < nfsConfig.getNFSThreadPoolSize() + 1) {
                    throw new InvalidConfigurationException("NFS packet pool must be at least thread pool size plus one");
                }
                nfsConfig.setNFSPacketPoolSize(pktPoolSize);
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid NFS packet pool size setting, " + this.getText(elem));
            }
        }
        if (this.findChildNode("disablePortMapperRegistration", nfs.getChildNodes()) != null) {
            nfsConfig.setPortMapperPort(-1);
        } else {
            elem = this.findChildNode("PortMapperPort", nfs.getChildNodes());
            if (elem != null) {
                try {
                    nfsConfig.setPortMapperPort(Integer.parseInt(this.getText(elem)));
                    if (nfsConfig.getPortMapperPort() <= 0 || nfsConfig.getPortMapperPort() >= 65535) {
                        throw new InvalidConfigurationException("Port mapper server port out of valid range");
                    }
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid port mapper server port");
                }
            }
        }
        elem = this.findChildNode("MountServerPort", nfs.getChildNodes());
        if (elem != null) {
            try {
                nfsConfig.setMountServerPort(Integer.parseInt(this.getText(elem)));
                if (nfsConfig.getMountServerPort() <= 0 || nfsConfig.getMountServerPort() >= 65535) {
                    throw new InvalidConfigurationException("Mount server port out of valid range");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid mount server port");
            }
        }
        if ((elem = this.findChildNode("NFSServerPort", nfs.getChildNodes())) != null) {
            try {
                nfsConfig.setNFSServerPort(Integer.parseInt(this.getText(elem)));
                if (nfsConfig.getNFSServerPort() <= 0 || nfsConfig.getNFSServerPort() >= 65535) {
                    throw new InvalidConfigurationException("NFS server port out of valid range");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid NFS server port");
            }
        }
        if ((elem = this.findChildNode("RPCRegisterPort", nfs.getChildNodes())) != null) {
            try {
                nfsConfig.setRPCRegistrationPort(Integer.parseInt(this.getText(elem)));
                if (nfsConfig.getRPCRegistrationPort() <= 0 || nfsConfig.getRPCRegistrationPort() >= 65535) {
                    throw new InvalidConfigurationException("RPC registration port out of valid range");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid RPC registration port");
            }
        }
        if ((elem = this.findChildNode("rpcAuthenticator", nfs.getChildNodes())) != null) {
            Element classElem = this.findChildNode("class", elem.getChildNodes());
            if (classElem == null) {
                throw new InvalidConfigurationException("RPC Authenticator class not specified");
            }
            GenericConfigElement params = this.buildConfigElement(elem);
            nfsConfig.setRpcAuthenticator(this.getText(classElem), params);
        } else {
            nfsConfig.setRpcAuthenticator("org.alfresco.jlan.oncrpc.DefaultRpcAuthenticator", new ConfigElement("", ""));
        }
        elem = this.findChildNode("debug", nfs.getChildNodes());
        if (elem != null) {
            String flags = elem.getAttribute("flags");
            int nfsDbg = 0;
            if (flags != null) {
                flags = flags.toUpperCase();
                StringTokenizer token = new StringTokenizer(flags, ",");
                while (token.hasMoreTokens()) {
                    int idx;
                    String dbg = token.nextToken().trim();
                    for (idx = 0; idx < m_nfsDebugStr.length && !m_nfsDebugStr[idx].equalsIgnoreCase(dbg); ++idx) {
                    }
                    if (idx >= m_nfsDebugStr.length) {
                        throw new InvalidConfigurationException("Invalid NFS debug flag, " + dbg);
                    }
                    nfsDbg += 1 << idx;
                }
            }
            nfsConfig.setNFSDebug(nfsDbg);
        }
        if ((elem = this.findChildNode("mountServerDebug", nfs.getChildNodes())) != null) {
            nfsConfig.setMountServerDebug(true);
        }
        if ((elem = this.findChildNode("portMapperDebug", nfs.getChildNodes())) != null) {
            nfsConfig.setPortMapperDebug(true);
        }
        if ((elem = this.findChildNode("FileCache", nfs.getChildNodes())) != null) {
            try {
                String numVal = this.getText(elem);
                long cacheIOTimer = -1L;
                long cacheCloseTimer = -1L;
                int pos = numVal.indexOf(58);
                if (pos == -1) {
                    cacheIOTimer = Integer.parseInt(numVal);
                } else {
                    String val = numVal.substring(0, pos);
                    cacheIOTimer = Integer.parseInt(val);
                    val = numVal.substring(pos + 1);
                    cacheCloseTimer = Integer.parseInt(val);
                }
                if (cacheIOTimer < 0L || cacheIOTimer > 30L) {
                    throw new InvalidConfigurationException("Invalid NFS file cache I/O timer value, " + cacheIOTimer);
                }
                nfsConfig.setNFSFileCacheIOTimer(cacheIOTimer * 1000L);
                if (cacheCloseTimer != -1L) {
                    if (cacheCloseTimer < 0L || cacheCloseTimer > 120L) {
                        throw new InvalidConfigurationException("Invalid NFS file cache close timer value, " + cacheCloseTimer);
                    }
                    nfsConfig.setNFSFileCacheCloseTimer(cacheCloseTimer * 1000L);
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid NFS file cache timer value, " + ex.toString());
            }
        }
        if (this.findChildNode("fileCacheDebug", nfs.getChildNodes()) != null) {
            nfsConfig.setNFSFileCacheDebug(true);
        }
    }

    protected final void procClusterElement(Element cluster) throws InvalidConfigurationException {
        if (cluster != null) {
            try {
                Class.forName("com.hazelcast.core.HazelcastInstance");
                Class.forName("com.hazelcast.core.IMap");
                Class.forName("com.hazelcast.core.ITopic");
                Class.forName("org.alfresco.jlan.server.filesys.cache.hazelcast.ClusterConfigSection");
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidConfigurationException("Hazelcast classes not found on the classpath, required for cluster support");
            }
            ClusterConfigSection clusterConfig = new ClusterConfigSection(this);
            Element elem = this.findChildNode("configFile", cluster.getChildNodes());
            if (elem != null) {
                String configPath = this.getText(elem);
                try {
                    File confFile = new File(configPath);
                    if (!confFile.exists()) {
                        throw new InvalidConfigurationException("HazelCast configuration file does not exist, " + configPath);
                    }
                    if (confFile.isDirectory()) {
                        throw new InvalidConfigurationException("HazelCast configuration file is a folder path, " + configPath);
                    }
                    clusterConfig.setConfigFile(configPath);
                }
                catch (Exception ex) {
                    throw new InvalidConfigurationException("HazelCast configuration file not valid", ex);
                }
            } else {
                throw new InvalidConfigurationException("HazelCast configuration file not specified");
            }
        }
    }
}

