/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.app;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.alfresco.jlan.app.DriveMappingsConfigSection;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.debug.DebugConfigSection;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.server.auth.UserAccount;
import org.alfresco.jlan.server.auth.UserAccountList;
import org.alfresco.jlan.server.auth.acl.ACLParseException;
import org.alfresco.jlan.server.auth.acl.AccessControlList;
import org.alfresco.jlan.server.auth.acl.AccessControlParser;
import org.alfresco.jlan.server.auth.acl.InvalidACLTypeException;
import org.alfresco.jlan.server.config.CoreServerConfigSection;
import org.alfresco.jlan.server.config.GlobalConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.SecurityConfigSection;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.core.SharedDeviceList;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.VolumeInfo;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.jlan.server.filesys.cache.StandaloneFileStateCache;
import org.alfresco.jlan.smb.DialectSelector;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.util.DriveMapping;
import org.alfresco.jlan.smb.util.DriveMappingList;
import org.alfresco.jlan.util.IPAddress;
import org.alfresco.jlan.util.MemorySize;
import org.alfresco.jlan.util.Platform;
import org.alfresco.jlan.util.StringList;
import org.alfresco.jlan.util.X64;
import org.springframework.extensions.config.element.GenericConfigElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CifsOnlyXMLServerConfiguration
extends ServerConfiguration {
    private static final int ELEMENT_TYPE = 1;
    private static final String[] m_sessDbgStr = new String[]{"NETBIOS", "STATE", "RXDATA", "TXDATA", "DUMPDATA", "NEGOTIATE", "TREE", "SEARCH", "INFO", "FILE", "FILEIO", "TRANSACT", "ECHO", "ERROR", "IPC", "LOCK", "PKTTYPE", "DCERPC", "STATECACHE", "TIMING", "NOTIFY", "STREAMS", "SOCKET", "PKTPOOL", "PKTSTATS", "THREADPOOL", "BENCHMARK", "OPLOCK", "PKTALLOC"};
    private static final int DEFAULT_SESSDEBUG = 10690;
    private static final String _driveLetters = "CDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int DefaultThreadPoolInit = 25;
    private static final int DefaultThreadPoolMax = 50;
    private static final int[] DefaultMemoryPoolBufSizes = new int[]{256, 4096, 16384, 66000};
    private static final int[] DefaultMemoryPoolInitAlloc = new int[]{20, 20, 5, 5};
    private static final int[] DefaultMemoryPoolMaxAlloc = new int[]{100, 50, 50, 50};
    private static final int MemoryPoolMinimumPacketSize = 256;
    private static final int MemoryPoolMaximumPacketSize = 131072;
    private static final int MemoryPoolMinimumAllocation = 5;
    private static final int MemoryPoolMaximumAllocation = 500;
    private static final int MaxSessionTimeout = 3600;
    private SimpleDateFormat m_dateFmt = new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss");

    public CifsOnlyXMLServerConfiguration() {
        super("");
    }

    @Override
    public final void loadConfiguration(String fname) throws IOException, InvalidConfigurationException {
        FileInputStream inFile = new FileInputStream(fname);
        InputStreamReader inRead = new InputStreamReader(inFile);
        this.loadConfiguration(inRead);
    }

    public final void loadConfiguration(Reader in) throws IOException, InvalidConfigurationException {
        this.removeAllConfigSections();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource xmlSource = new InputSource(in);
            Document doc = builder.parse(xmlSource);
            this.loadConfiguration(doc);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("XML error", ex);
        }
        finally {
            in.close();
        }
    }

    public void loadConfiguration(Document doc) throws IOException, InvalidConfigurationException {
        this.removeAllConfigSections();
        try {
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            this.procDebugElement(this.findChildNode("debug", childNodes));
            this.procServerCoreElement(this.findChildNode("server-core", childNodes));
            this.procGlobalElement(this.findChildNode("global", childNodes));
            this.procSecurityElement(this.findChildNode("security", childNodes));
            this.procSharesElement(this.findChildNode("shares", childNodes));
            this.procSMBServerElement(this.findChildNode("SMB", childNodes));
            this.procDriveMappingsElement(this.findChildNode("DriveMappings", childNodes));
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("XML error", ex);
        }
    }

    protected final void procServerCoreElement(Element srvCore) throws InvalidConfigurationException {
        CoreServerConfigSection coreConfig = new CoreServerConfigSection(this);
        if (srvCore == null) {
            coreConfig.setMemoryPool(DefaultMemoryPoolBufSizes, DefaultMemoryPoolInitAlloc, DefaultMemoryPoolMaxAlloc);
            coreConfig.setThreadPool(25, 50);
            return;
        }
        Element elem = this.findChildNode("threadPool", srvCore.getChildNodes());
        if (elem != null) {
            String initSizeStr = elem.getAttribute("init");
            if (initSizeStr == null || initSizeStr.length() == 0) {
                throw new InvalidConfigurationException("Thread pool initial size not specified");
            }
            int initSize = 0;
            try {
                initSize = Integer.parseInt(initSizeStr);
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid thread pool size value, " + initSizeStr);
            }
            if (initSize < 4) {
                throw new InvalidConfigurationException("Thread pool size below minimum allowed size");
            }
            if (initSize > 250) {
                throw new InvalidConfigurationException("Thread pool size above maximum allowed size");
            }
            String maxSizeStr = elem.getAttribute("max");
            int maxSize = initSize;
            if (maxSizeStr.length() > 0) {
                try {
                    maxSize = Integer.parseInt(maxSizeStr);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException(" Invalid thread pool maximum size value, " + maxSizeStr);
                }
                if (maxSize < 4) {
                    throw new InvalidConfigurationException("Thread pool maximum size below minimum allowed size");
                }
                if (maxSize > 250) {
                    throw new InvalidConfigurationException("Thread pool maximum size above maximum allowed size");
                }
                if (maxSize < initSize) {
                    throw new InvalidConfigurationException("Initial size is larger than maxmimum size");
                }
            } else if (maxSizeStr != null) {
                throw new InvalidConfigurationException("Thread pool maximum size not specified");
            }
            coreConfig.setThreadPool(initSize, maxSize);
        } else {
            coreConfig.setThreadPool(25, 50);
        }
        if (this.findChildNode("threadPoolDebug", srvCore.getChildNodes()) != null) {
            coreConfig.getThreadPool().setDebug(true);
        }
        if ((elem = this.findChildNode("memoryPool", srvCore.getChildNodes())) != null) {
            Element pktElem = this.findChildNode("packetSizes", elem.getChildNodes());
            if (pktElem != null) {
                NodeList nodeList = pktElem.getChildNodes();
                int elemCnt = 0;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    if (nodeList.item(i).getNodeType() != 1) continue;
                    ++elemCnt;
                }
                int[] pktSizes = new int[elemCnt];
                int[] initSizes = new int[elemCnt];
                int[] maxSizes = new int[elemCnt];
                int elemIdx = 0;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element curElem;
                    Node curNode = nodeList.item(i);
                    if (curNode.getNodeType() != 1 || !(curElem = (Element)curNode).getNodeName().equals("packet")) continue;
                    int pktSize = -1;
                    int initAlloc = -1;
                    int maxAlloc = -1;
                    String pktSizeStr = curElem.getAttribute("size");
                    if (pktSizeStr == null || pktSizeStr.length() == 0) {
                        throw new InvalidConfigurationException("Memory pool packet size not specified");
                    }
                    try {
                        pktSize = MemorySize.getByteValueInt(pktSizeStr);
                    }
                    catch (NumberFormatException ex) {
                        throw new InvalidConfigurationException("Memory pool packet size, invalid size value, " + pktSizeStr);
                    }
                    if (elemIdx > 0 && pktSizes[elemIdx - 1] >= pktSize) {
                        throw new InvalidConfigurationException("Invalid packet size specified, less than/equal to previous packet size");
                    }
                    String initSizeStr = curElem.getAttribute("init");
                    if (initSizeStr == null || initSizeStr.length() == 0) {
                        throw new InvalidConfigurationException("Memory pool initial allocation not specified");
                    }
                    try {
                        initAlloc = Integer.parseInt(initSizeStr);
                    }
                    catch (NumberFormatException ex) {
                        throw new InvalidConfigurationException("Invalid initial allocation, " + initSizeStr);
                    }
                    if (initAlloc < 5) {
                        throw new InvalidConfigurationException("Initial memory pool allocation below minimum of 5");
                    }
                    if (initAlloc > 500) {
                        throw new InvalidConfigurationException("Initial memory pool allocation above maximum of 500");
                    }
                    String maxSizeStr = curElem.getAttribute("max");
                    if (maxSizeStr == null || maxSizeStr.length() == 0) {
                        throw new InvalidConfigurationException("Memory pool maximum allocation not specified");
                    }
                    try {
                        maxAlloc = Integer.parseInt(maxSizeStr);
                    }
                    catch (NumberFormatException ex) {
                        throw new InvalidConfigurationException("Invalid maximum allocation, " + maxSizeStr);
                    }
                    if (maxAlloc < 5) {
                        throw new InvalidConfigurationException("Maximum memory pool allocation below minimum of 5");
                    }
                    if (initAlloc > 500) {
                        throw new InvalidConfigurationException("Maximum memory pool allocation above maximum of 500");
                    }
                    pktSizes[elemIdx] = pktSize;
                    initSizes[elemIdx] = initAlloc;
                    maxSizes[elemIdx] = maxAlloc;
                    ++elemIdx;
                }
                if (elemIdx < pktSizes.length) {
                    int[] newPktSizes = new int[elemIdx];
                    int[] newInitSizes = new int[elemIdx];
                    int[] newMaxSizes = new int[elemIdx];
                    System.arraycopy(pktSizes, 0, newPktSizes, 0, elemIdx);
                    System.arraycopy(initSizes, 0, newInitSizes, 0, elemIdx);
                    System.arraycopy(maxSizes, 0, newMaxSizes, 0, elemIdx);
                    pktSizes = newPktSizes;
                    initSizes = newInitSizes;
                    maxSizes = newMaxSizes;
                }
                coreConfig.setMemoryPool(pktSizes, initSizes, maxSizes);
            }
        } else {
            coreConfig.setMemoryPool(DefaultMemoryPoolBufSizes, DefaultMemoryPoolInitAlloc, DefaultMemoryPoolMaxAlloc);
        }
    }

    protected final void procGlobalElement(Element global) throws InvalidConfigurationException {
        GlobalConfigSection globalConfig = new GlobalConfigSection(this);
        if (global == null) {
            return;
        }
        Element elem = this.findChildNode("timezone", global.getChildNodes());
        if (elem != null) {
            String tzOffset;
            String tzName = elem.getAttribute("name");
            if (tzName != null && tzName.length() > 0) {
                globalConfig.setTimeZone(tzName);
            }
            if ((tzOffset = elem.getAttribute("offset")) != null && tzOffset.length() > 0 && tzName != null && tzName.length() > 0) {
                throw new InvalidConfigurationException("Specify name or offset for timezone");
            }
            if (tzOffset != null && tzOffset.length() > 0) {
                int offset = 0;
                try {
                    offset = Integer.parseInt(tzOffset);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid timezone offset value, " + tzOffset);
                }
                if (offset < -1440 || offset > 1440) {
                    throw new InvalidConfigurationException("Invalid timezone offset, value out of valid range, " + tzOffset);
                }
                globalConfig.setTimeZoneOffset(offset);
            }
        }
    }

    protected final void procSMBServerElement(Element smb) throws InvalidConfigurationException {
        Element authElem;
        String maxVCVal;
        if (smb == null) {
            throw new InvalidConfigurationException("SMB section must be specified");
        }
        CIFSConfigSection cifsConfig = new CIFSConfigSection(this);
        this.procHostElement(this.findChildNode("host", smb.getChildNodes()), cifsConfig);
        Element elem = this.findChildNode("netbiosDebug", smb.getChildNodes());
        if (elem != null) {
            cifsConfig.setNetBIOSDebug(true);
        }
        if ((elem = this.findChildNode("announceDebug", smb.getChildNodes())) != null) {
            cifsConfig.setHostAnnounceDebug(true);
        }
        if ((elem = this.findChildNode("sessionDebug", smb.getChildNodes())) != null) {
            String flags = elem.getAttribute("flags");
            int sessDbg = 10690;
            if (flags != null) {
                sessDbg = 0;
                flags = flags.toUpperCase();
                StringTokenizer token = new StringTokenizer(flags, ",");
                while (token.hasMoreTokens()) {
                    int idx;
                    String dbg = token.nextToken().trim();
                    for (idx = 0; idx < m_sessDbgStr.length && !m_sessDbgStr[idx].equalsIgnoreCase(dbg); ++idx) {
                    }
                    if (idx >= m_sessDbgStr.length) {
                        throw new InvalidConfigurationException("Invalid session debug flag, " + dbg);
                    }
                    sessDbg += 1 << idx;
                }
            }
            cifsConfig.setSessionDebugFlags(sessDbg);
        }
        if (this.findChildNode("disableNIO", smb.getChildNodes()) != null) {
            cifsConfig.setDisableNIOCode(true);
        }
        if ((elem = this.findChildNode("virtualCircuits", smb.getChildNodes())) != null && (maxVCVal = elem.getAttribute("maxPerSession")) != null && maxVCVal.length() > 0) {
            try {
                int maxVC = Integer.parseInt(maxVCVal);
                if (maxVC < 4 || maxVC > 2000) {
                    throw new InvalidConfigurationException("Maximum virtual circuits value out of range, valid range 4 - 2000");
                }
                cifsConfig.setMaximumVirtualCircuits(maxVC);
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid maximum virtual circuits value, " + maxVCVal);
            }
        }
        if ((authElem = this.findChildNode("authenticator", smb.getChildNodes())) != null) {
            Element classElem = this.findChildNode("class", authElem.getChildNodes());
            String authClass = null;
            if (classElem == null) {
                String authType = authElem.getAttribute("type");
                if (authType == null) {
                    throw new InvalidConfigurationException("Authenticator class not specified");
                }
                if (authType.equalsIgnoreCase("local")) {
                    authClass = "org.alfresco.jlan.server.auth.LocalAuthenticator";
                } else if (authType.equalsIgnoreCase("passthru")) {
                    authClass = "org.alfresco.jlan.server.auth.passthru.PassthruAuthenticator";
                } else if (authType.equalsIgnoreCase("enterprise")) {
                    authClass = "org.alfresco.jlan.server.auth.EnterpriseCifsAuthenticator";
                }
            } else {
                authClass = this.getText(classElem);
            }
            Element modeElem = this.findChildNode("mode", authElem.getChildNodes());
            int accessMode = 1;
            if (modeElem != null) {
                String mode = this.getText(modeElem);
                if (mode.equalsIgnoreCase("user")) {
                    accessMode = 1;
                } else if (mode.equalsIgnoreCase("share")) {
                    accessMode = 0;
                } else {
                    throw new InvalidConfigurationException("Invalid authentication mode, must be USER or SHARE");
                }
            }
            Element allowGuest = this.findChildNode("allowGuest", authElem.getChildNodes());
            GenericConfigElement params = this.buildConfigElement(authElem);
            cifsConfig.setAuthenticator(authClass, params, accessMode, allowGuest != null);
        }
    }

    protected final void procHostElement(Element host, CIFSConfigSection cifsConfig) throws InvalidConfigurationException {
        List<Platform.Type> enabledPlatforms;
        String platformsStr;
        InetAddress bindAddr;
        Element elem;
        if (host == null) {
            throw new InvalidConfigurationException("Host section must be specified");
        }
        String attr = host.getAttribute("name");
        if (attr == null || attr.length() == 0) {
            throw new InvalidConfigurationException("Host name not specified or invalid");
        }
        cifsConfig.setServerName(attr.toUpperCase());
        if (this.getServerName() == null) {
            this.setServerName(cifsConfig.getServerName());
        }
        if ((attr = host.getAttribute("domain")) != null && attr.length() > 0) {
            cifsConfig.setDomainName(attr.toUpperCase());
        }
        if ((elem = this.findChildNode("smbdialects", host.getChildNodes())) != null) {
            DialectSelector diaSel = cifsConfig.getEnabledDialects();
            diaSel.ClearAll();
            StringTokenizer token = new StringTokenizer(this.getText(elem), ",");
            while (token.hasMoreTokens()) {
                String dia = token.nextToken().trim();
                if (dia.equalsIgnoreCase("CORE")) {
                    diaSel.AddDialect(0);
                    diaSel.AddDialect(1);
                    continue;
                }
                if (dia.equalsIgnoreCase("LANMAN")) {
                    diaSel.AddDialect(2);
                    diaSel.AddDialect(4);
                    diaSel.AddDialect(3);
                    diaSel.AddDialect(5);
                    diaSel.AddDialect(6);
                    continue;
                }
                if (dia.equalsIgnoreCase("NT")) {
                    diaSel.AddDialect(7);
                    continue;
                }
                throw new InvalidConfigurationException("Invalid SMB dialect, " + dia);
            }
            cifsConfig.setEnabledDialects(diaSel);
        }
        if ((elem = this.findChildNode("comment", host.getChildNodes())) != null) {
            cifsConfig.setComment(this.getText(elem));
        }
        if ((elem = this.findChildNode("bindto", host.getChildNodes())) != null) {
            if (elem.hasAttribute("adapter")) {
                InetAddress bindAddr2 = this.parseAdapterName(elem.getAttribute("adapter"));
                cifsConfig.setSMBBindAddress(bindAddr2);
            } else {
                String bindText = this.getText(elem);
                try {
                    bindAddr = InetAddress.getByName(bindText);
                    cifsConfig.setSMBBindAddress(bindAddr);
                }
                catch (UnknownHostException ex) {
                    throw new InvalidConfigurationException(ex.toString());
                }
            }
        }
        if ((elem = this.findChildNode("hostAnnounce", host.getChildNodes())) != null) {
            attr = elem.getAttribute("interval");
            if (attr != null && attr.length() > 0) {
                try {
                    cifsConfig.setHostAnnounceInterval(Integer.parseInt(attr));
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid host announcement interval");
                }
            }
            if (cifsConfig.getDomainName() == null) {
                throw new InvalidConfigurationException("Domain name must be specified if host announcement is enabled");
            }
            cifsConfig.setHostAnnouncer(true);
        }
        if ((elem = this.findChildNode("HostAnnouncerPort", host.getChildNodes())) != null) {
            try {
                cifsConfig.setHostAnnouncerPort(Integer.parseInt(this.getText(elem)));
                if (cifsConfig.getHostAnnouncerPort() <= 0 || cifsConfig.getHostAnnouncerPort() >= 65535) {
                    throw new InvalidConfigurationException("Host announcer port out of valid range");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid host announcer port");
            }
        }
        if ((elem = this.findChildNode("netBIOSSMB", host.getChildNodes())) != null) {
            boolean platformOK = false;
            if (elem.hasAttribute("platforms")) {
                platformsStr = elem.getAttribute("platforms");
                enabledPlatforms = this.parsePlatformString(platformsStr);
                if (enabledPlatforms.contains((Object)this.getPlatformType())) {
                    platformOK = true;
                }
            } else {
                platformOK = true;
            }
            cifsConfig.setNetBIOSSMB(platformOK);
            if (platformOK) {
                attr = elem.getAttribute("sessionPort");
                if (attr != null && attr.length() > 0) {
                    try {
                        cifsConfig.setSessionPort(Integer.parseInt(attr));
                        if (cifsConfig.getSessionPort() <= 0 || cifsConfig.getSessionPort() >= 65535) {
                            throw new InvalidConfigurationException("NetBIOS SMB session port out of valid range");
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new InvalidConfigurationException("Invalid NetBIOS SMB session port");
                    }
                }
                if ((attr = elem.getAttribute("datagramPort")) != null && attr.length() > 0) {
                    try {
                        cifsConfig.setNameServerPort(Integer.parseInt(attr));
                        if (cifsConfig.getNameServerPort() <= 0 || cifsConfig.getNameServerPort() >= 65535) {
                            throw new InvalidConfigurationException("NetBIOS SMB datagram port out of valid range");
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new InvalidConfigurationException("Invalid NetBIOS SMB datagram port");
                    }
                }
                if ((attr = elem.getAttribute("namingPort")) != null && attr.length() > 0) {
                    try {
                        cifsConfig.setNameServerPort(Integer.parseInt(attr));
                        if (cifsConfig.getNameServerPort() <= 0 || cifsConfig.getNameServerPort() >= 65535) {
                            throw new InvalidConfigurationException("NetBIOS SMB naming port out of valid range");
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new InvalidConfigurationException("Invalid NetBIOS SMB naming port");
                    }
                }
                if ((attr = elem.getAttribute("bindto")) != null && attr.length() > 0) {
                    try {
                        bindAddr = InetAddress.getByName(attr);
                        cifsConfig.setNetBIOSBindAddress(bindAddr);
                    }
                    catch (UnknownHostException ex) {
                        throw new InvalidConfigurationException(ex.toString());
                    }
                } else if (elem.hasAttribute("adapter")) {
                    bindAddr = this.parseAdapterName(elem.getAttribute("adapter"));
                    cifsConfig.setNetBIOSBindAddress(bindAddr);
                } else if (cifsConfig.hasSMBBindAddress()) {
                    cifsConfig.setNetBIOSBindAddress(cifsConfig.getSMBBindAddress());
                }
            }
        } else {
            cifsConfig.setNetBIOSSMB(false);
        }
        elem = this.findChildNode("tcpipSMB", host.getChildNodes());
        if (elem != null) {
            boolean platformOK = false;
            if (elem.hasAttribute("platforms")) {
                platformsStr = elem.getAttribute("platforms");
                enabledPlatforms = this.parsePlatformString(platformsStr);
                if (enabledPlatforms.contains((Object)this.getPlatformType())) {
                    platformOK = true;
                }
            } else {
                platformOK = true;
            }
            cifsConfig.setTcpipSMB(platformOK);
            attr = elem.getAttribute("port");
            if (attr != null && attr.length() > 0) {
                try {
                    cifsConfig.setTcpipSMBPort(Integer.parseInt(attr));
                    if (cifsConfig.getTcpipSMBPort() <= 0 || cifsConfig.getTcpipSMBPort() >= 65535) {
                        throw new InvalidConfigurationException("TCP/IP SMB port out of valid range");
                    }
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid TCP/IP SMB port");
                }
            }
        } else {
            cifsConfig.setTcpipSMB(false);
        }
        if (cifsConfig.hasNetBIOSSMB() || cifsConfig.hasEnableAnnouncer()) {
            elem = this.findChildNode("broadcast", host.getChildNodes());
            if (elem != null) {
                if (!IPAddress.isNumericAddress(this.getText(elem))) {
                    throw new InvalidConfigurationException("Invalid broadcast mask, must be n.n.n.n format");
                }
                cifsConfig.setBroadcastMask(this.getText(elem));
            } else {
                throw new InvalidConfigurationException("Network broadcast mask not specified");
            }
        }
        if ((elem = this.findChildNode("Win32NetBIOS", host.getChildNodes())) != null) {
            String osName;
            attr = elem.getAttribute("name");
            if (attr != null && attr.length() > 0) {
                if (attr.length() > 16) {
                    throw new InvalidConfigurationException("Invalid Win32 NetBIOS name, " + attr);
                }
                cifsConfig.setWin32NetBIOSName(attr);
            }
            if ((attr = elem.getAttribute("accept")) != null && attr.length() > 0) {
                if (attr.length() > 15) {
                    throw new InvalidConfigurationException("Invalid Win32 NetBIOS accept name, " + attr);
                }
                cifsConfig.setWin32NetBIOSClientAccept(attr);
            }
            if ((attr = elem.getAttribute("lana")) != null && attr.length() > 0) {
                int lana = -1;
                if (IPAddress.isNumericAddress(attr)) {
                    lana = Win32NetBIOS.getLANAForIPAddress(attr);
                    if (lana == -1) {
                        throw new InvalidConfigurationException("Failed to convert IP address " + attr + " to a LANA");
                    }
                } else if (attr.length() > 1 && Character.isLetter(attr.charAt(0))) {
                    lana = Win32NetBIOS.getLANAForAdapterName(attr);
                    if (lana == -1) {
                        throw new InvalidConfigurationException("Failed to convert network adapter " + attr + " to a LANA");
                    }
                } else {
                    try {
                        lana = Integer.parseInt(attr);
                    }
                    catch (NumberFormatException ex) {
                        throw new InvalidConfigurationException("Invalid Win32 NetBIOS LANA specified");
                    }
                    if (lana < 0 || lana > 255) {
                        throw new InvalidConfigurationException("Invalid Win32 NetBIOS LANA number, " + lana);
                    }
                }
                cifsConfig.setWin32LANA(lana);
            }
            if ((attr = elem.getAttribute("api")) != null && attr.length() > 0) {
                boolean useWinsock = true;
                if (attr.equalsIgnoreCase("netbios")) {
                    useWinsock = false;
                } else if (!attr.equalsIgnoreCase("winsock")) {
                    throw new InvalidConfigurationException("Invalid NetBIOS API type, spefify 'winsock' or 'netbios'");
                }
                cifsConfig.setWin32WinsockNetBIOS(useWinsock);
            }
            if (cifsConfig.useWinsockNetBIOS() && X64.isWindows64()) {
                Debug.println("Using older Netbios() API code, Winsock NetBIOS not available on x64");
                cifsConfig.setWin32WinsockNetBIOS(false);
            }
            if ((osName = System.getProperty("os.name")).startsWith("Windows") && !osName.endsWith("95") && !osName.endsWith("98") && !osName.endsWith("ME")) {
                cifsConfig.setWin32NetBIOS(true);
            } else {
                cifsConfig.setWin32NetBIOS(false);
            }
        } else {
            cifsConfig.setWin32NetBIOS(false);
        }
        elem = this.findChildNode("Win32Announce", host.getChildNodes());
        if (elem != null) {
            attr = elem.getAttribute("interval");
            if (attr != null && attr.length() > 0) {
                try {
                    cifsConfig.setWin32HostAnnounceInterval(Integer.parseInt(attr));
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid host announcement interval");
                }
            }
            if (cifsConfig.getDomainName() == null) {
                throw new InvalidConfigurationException("Domain name must be specified if host announcement is enabled");
            }
            cifsConfig.setWin32HostAnnouncer(true);
        }
        if (!(cifsConfig.hasNetBIOSSMB() || cifsConfig.hasTcpipSMB() || cifsConfig.hasWin32NetBIOS())) {
            throw new InvalidConfigurationException("NetBIOS SMB, TCP/IP SMB or Win32 NetBIOS must be enabled");
        }
        elem = this.findChildNode("alias", host.getChildNodes());
        if (elem != null) {
            attr = elem.getAttribute("names");
            if (attr == null || attr.length() == 0) {
                throw new InvalidConfigurationException("Alias name(s) not specified");
            }
            StringList names = new StringList();
            StringTokenizer nameTokens = new StringTokenizer(attr, ",");
            while (nameTokens.hasMoreTokens()) {
                String alias = nameTokens.nextToken().trim().toUpperCase();
                if (alias.equalsIgnoreCase(this.getServerName())) {
                    throw new InvalidConfigurationException("Alias is the same as the main server name");
                }
                if (names.containsString(alias)) {
                    throw new InvalidConfigurationException("Same alias specified twice, " + alias);
                }
                names.addString(alias);
            }
            cifsConfig.addAliasNames(names);
        }
        if ((elem = this.findChildNode("macExtensions", host.getChildNodes())) != null) {
            cifsConfig.setMacintoshExtensions(true);
        }
        if ((elem = this.findChildNode("WINS", host.getChildNodes())) != null) {
            Element winsSrv = this.findChildNode("primary", elem.getChildNodes());
            if (winsSrv == null) {
                throw new InvalidConfigurationException("No primary WINS server configured");
            }
            InetAddress primaryWINS = null;
            try {
                primaryWINS = InetAddress.getByName(this.getText(winsSrv));
            }
            catch (UnknownHostException ex) {
                throw new InvalidConfigurationException("Invalid primary WINS server address, " + winsSrv.getNodeValue());
            }
            winsSrv = this.findChildNode("secondary", elem.getChildNodes());
            InetAddress secondaryWINS = null;
            if (winsSrv != null) {
                try {
                    secondaryWINS = InetAddress.getByName(this.getText(winsSrv));
                }
                catch (UnknownHostException ex) {
                    throw new InvalidConfigurationException("Invalid secondary WINS server address, " + winsSrv.getNodeValue());
                }
            }
            cifsConfig.setPrimaryWINSServer(primaryWINS);
            if (secondaryWINS != null) {
                cifsConfig.setSecondaryWINSServer(secondaryWINS);
            }
        }
        if ((elem = this.findChildNode("sessionTimeout", host.getChildNodes())) != null) {
            String sessTmo = this.getText(elem);
            if (sessTmo != null && sessTmo.length() > 0) {
                try {
                    int tmo = Integer.parseInt(sessTmo);
                    if (tmo < 0 || tmo > 3600) {
                        throw new InvalidConfigurationException("Session timeout out of range (0 - 3600)");
                    }
                    cifsConfig.setSocketTimeout(tmo * 1000);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid session timeout value, " + sessTmo);
                }
            } else {
                throw new InvalidConfigurationException("Session timeout value not specified");
            }
        }
    }

    protected final void procDebugElement(Element debug) throws InvalidConfigurationException {
        if (debug == null) {
            return;
        }
        DebugConfigSection debugConfig = new DebugConfigSection(this);
        Element elem = this.findChildNode("output", debug.getChildNodes());
        if (elem == null) {
            throw new InvalidConfigurationException("Output class must be specified to enable debug output");
        }
        Element debugClass = this.findChildNode("class", elem.getChildNodes());
        if (debugClass == null) {
            throw new InvalidConfigurationException("Class must be specified for debug output");
        }
        GenericConfigElement params = this.buildConfigElement(elem);
        debugConfig.setDebug(this.getText(debugClass), params);
    }

    protected final void procSharesElement(Element shares) throws InvalidConfigurationException {
        if (shares == null) {
            return;
        }
        FilesystemsConfigSection filesysConfig = new FilesystemsConfigSection(this);
        NodeList children = shares.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Element child;
                Node node = children.item(i);
                if (node.getNodeType() != 1 || !(child = (Element)node).getNodeName().equalsIgnoreCase("diskshare")) continue;
                this.addDiskShare(child, filesysConfig);
            }
        }
    }

    protected final void procSecurityElement(Element security) throws InvalidConfigurationException {
        Element usersIface;
        Element mapper;
        Element usersElem;
        Element jceElem;
        AccessControlList acls;
        if (security == null) {
            return;
        }
        SecurityConfigSection secConfig = new SecurityConfigSection(this);
        Element aclElem = this.findChildNode("accessControlManager", security.getChildNodes());
        if (aclElem != null) {
            Element classElem = this.findChildNode("class", aclElem.getChildNodes());
            if (classElem == null) {
                throw new InvalidConfigurationException("Access control manager class not specified");
            }
            GenericConfigElement params = this.buildConfigElement(aclElem);
            secConfig.setAccessControlManager(this.getText(classElem), params);
        } else {
            secConfig.setAccessControlManager("org.alfresco.jlan.server.auth.acl.DefaultAccessControlManager", new GenericConfigElement("aclManager"));
        }
        Element globalACLs = this.findChildNode("globalAccessControl", security.getChildNodes());
        if (globalACLs != null && (acls = this.procAccessControlElement(globalACLs, secConfig)) != null) {
            secConfig.setGlobalAccessControls(acls);
        }
        if ((jceElem = this.findChildNode("JCEProvider", security.getChildNodes())) != null) {
            secConfig.setJCEProvider(this.getText(jceElem));
        }
        if ((usersElem = this.findChildNode("users", security.getChildNodes())) != null) {
            NodeList userList = usersElem.getChildNodes();
            for (int i = 0; i < userList.getLength(); ++i) {
                Node node = userList.item(i);
                if (node.getNodeType() != 1) continue;
                Element userElem = (Element)node;
                this.addUser(userElem, secConfig);
            }
        }
        if ((mapper = this.findChildNode("shareMapper", security.getChildNodes())) != null) {
            Element classElem = this.findChildNode("class", mapper.getChildNodes());
            if (classElem == null) {
                throw new InvalidConfigurationException("Share mapper class not specified");
            }
            GenericConfigElement params = this.buildConfigElement(mapper);
            secConfig.setShareMapper(this.getText(classElem), params);
        }
        if ((usersIface = this.findChildNode("usersInterface", security.getChildNodes())) != null) {
            Element classElem = this.findChildNode("class", usersIface.getChildNodes());
            if (classElem == null) {
                throw new InvalidConfigurationException("Users interface class not specified");
            }
            GenericConfigElement params = this.buildConfigElement(usersIface);
            secConfig.setUsersInterface(this.getText(classElem), params);
        }
    }

    protected final void procDriveMappingsElement(Element mappings) throws InvalidConfigurationException {
        if (mappings == null) {
            return;
        }
        DriveMappingsConfigSection mapConfig = new DriveMappingsConfigSection(this);
        NodeList mapElems = mappings.getChildNodes();
        DriveMappingList mapList = null;
        if (mapElems != null && mapElems.getLength() > 0) {
            mapList = new DriveMappingList();
            CIFSConfigSection cifsConfig = (CIFSConfigSection)this.getConfigSection("CIFS");
            SecurityConfigSection secConfig = (SecurityConfigSection)this.getConfigSection("Security");
            SharedDeviceList shareList = secConfig.getShareMapper().getShareList(this.getServerName(), null, false);
            for (int i = 0; i < mapElems.getLength(); ++i) {
                Element elem;
                Node node = mapElems.item(i);
                if (node.getNodeType() != 1 || !(elem = (Element)node).getNodeName().equals("mapDrive")) continue;
                String localPath = elem.getAttribute("drive").toUpperCase();
                String shareName = elem.getAttribute("share");
                if (localPath.length() != 2) {
                    throw new InvalidConfigurationException("Invalid local drive specified, " + localPath);
                }
                if (localPath.charAt(1) != ':' || _driveLetters.indexOf(localPath.charAt(0)) == -1) {
                    throw new InvalidConfigurationException("Invalid local drive specified, " + localPath);
                }
                if (shareName.length() == 0) {
                    throw new InvalidConfigurationException("Empty share name for mapped drive, " + localPath);
                }
                if (shareList.findShare(shareName, 0, true) == null) {
                    throw new InvalidConfigurationException("Mapped drive share " + shareName + " does not exist");
                }
                String userName = null;
                String password = null;
                if (elem.hasAttribute("username")) {
                    userName = elem.getAttribute("username");
                }
                if (elem.hasAttribute("password")) {
                    password = elem.getAttribute("password");
                }
                boolean interact = false;
                boolean prompt = false;
                if (elem.hasAttribute("interactive") && elem.getAttribute("interactive").equalsIgnoreCase("YES")) {
                    interact = true;
                }
                if (elem.hasAttribute("prompt") && elem.getAttribute("prompt").equalsIgnoreCase("YES")) {
                    prompt = true;
                }
                StringBuffer remPath = new StringBuffer();
                remPath.append("\\\\");
                if (cifsConfig.hasWin32NetBIOS() && cifsConfig.getWin32ServerName() != null) {
                    remPath.append(cifsConfig.getWin32ServerName());
                } else {
                    remPath.append(this.getServerName());
                }
                remPath.append("\\");
                remPath.append(shareName.toUpperCase());
                mapList.addMapping(new DriveMapping(localPath, remPath.toString(), userName, password, interact, prompt));
            }
            mapConfig.setMappedDrives(mapList);
        }
    }

    protected final AccessControlList procAccessControlElement(Element acl, SecurityConfigSection secConfig) throws InvalidConfigurationException {
        NodeList aclElems;
        if (secConfig.getAccessControlManager() == null) {
            throw new InvalidConfigurationException("No access control manager configured");
        }
        AccessControlList acls = new AccessControlList();
        String attrib = acl.getAttribute("default");
        if (attrib != null && attrib.length() > 0) {
            try {
                int access = AccessControlParser.parseAccessTypeString(attrib);
                acls.setDefaultAccessLevel(access);
            }
            catch (InvalidACLTypeException ex) {
                throw new InvalidConfigurationException("Default access level error, " + ex.toString());
            }
            catch (ACLParseException ex) {
                throw new InvalidConfigurationException("Default access level error, " + ex.toString());
            }
        }
        if ((aclElems = acl.getChildNodes()) != null && aclElems.getLength() > 0) {
            GenericConfigElement params = null;
            String type = null;
            for (int i = 0; i < aclElems.getLength(); ++i) {
                Node node = aclElems.item(i);
                if (node.getNodeType() != 1) continue;
                Element elem = (Element)node;
                type = elem.getNodeName();
                params = new GenericConfigElement("acl");
                NamedNodeMap attrs = elem.getAttributes();
                if (attrs == null || attrs.getLength() == 0) {
                    throw new InvalidConfigurationException("Missing attribute(s) for access control " + type);
                }
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Node attr = attrs.item(j);
                    params.addAttribute(attr.getNodeName(), attr.getNodeValue());
                }
                try {
                    acls.addControl(secConfig.getAccessControlManager().createAccessControl(type, params));
                    continue;
                }
                catch (InvalidACLTypeException ex) {
                    throw new InvalidConfigurationException("Invalid access control type - " + type);
                }
                catch (ACLParseException ex) {
                    throw new InvalidConfigurationException("Access control parse error (" + type + "), " + ex.toString());
                }
            }
        }
        if (acls.getDefaultAccessLevel() == 0 && acls.numberOfControls() == 0) {
            throw new InvalidConfigurationException("Empty access control list and default access 'None' not allowed");
        }
        return acls;
    }

    protected final void addUser(Element user, SecurityConfigSection secConfig) throws InvalidConfigurationException {
        UserAccountList accList;
        String attr = user.getAttribute("name");
        if (attr == null || attr.length() == 0) {
            throw new InvalidConfigurationException("User name not specified, or zero length");
        }
        String userName = attr;
        if (secConfig.hasUserAccounts() && secConfig.getUserAccounts().findUser(userName) != null) {
            throw new InvalidConfigurationException("User " + userName + " already defined");
        }
        byte[] md4 = null;
        String password = null;
        Element elem = this.findChildNode("md4", user.getChildNodes());
        if (elem != null) {
            String md4Str = this.getText(elem);
            if (md4Str == null || md4Str.length() != 32) {
                throw new InvalidConfigurationException("Invalid MD4 hashed password for user " + userName);
            }
            md4 = new byte[16];
            for (int i = 0; i < 16; ++i) {
                String hexPair = md4Str.substring(i * 2, i * 2 + 2);
                md4[i] = (byte)Integer.parseInt(hexPair, 16);
            }
        } else {
            elem = this.findChildNode("password", user.getChildNodes());
            if (elem == null) {
                throw new InvalidConfigurationException("No password specified for user " + userName);
            }
            password = this.getText(elem);
        }
        UserAccount userAcc = new UserAccount(userName, password);
        userAcc.setMD4Password(md4);
        elem = this.findChildNode("administrator", user.getChildNodes());
        if (elem != null) {
            userAcc.setAdministrator(true);
        }
        if ((elem = this.findChildNode("realname", user.getChildNodes())) != null) {
            userAcc.setRealName(this.getText(elem));
        }
        if ((elem = this.findChildNode("comment", user.getChildNodes())) != null) {
            userAcc.setComment(this.getText(elem));
        }
        if ((elem = this.findChildNode("home", user.getChildNodes())) != null) {
            userAcc.setHomeDirectory(this.getText(elem));
        }
        if ((accList = secConfig.getUserAccounts()) == null) {
            secConfig.setUserAccounts(new UserAccountList());
        }
        secConfig.getUserAccounts().addUser(userAcc);
    }

    protected final void addDiskShare(Element disk, FilesystemsConfigSection filesysConfig) throws InvalidConfigurationException {
        Element driverElem;
        String attr = disk.getAttribute("name");
        if (attr == null || attr.length() == 0) {
            throw new InvalidConfigurationException("Disk share name must be specified");
        }
        String name = attr;
        String comment = null;
        attr = disk.getAttribute("comment");
        if (attr != null && attr.length() > 0) {
            comment = attr;
        }
        if ((driverElem = this.findChildNode("driver", disk.getChildNodes())) == null) {
            throw new InvalidConfigurationException("No driver specified for disk share " + name);
        }
        Element classElem = this.findChildNode("class", driverElem.getChildNodes());
        if (classElem == null || this.getText(classElem).length() == 0) {
            throw new InvalidConfigurationException("No driver class specified for disk share " + name);
        }
        SecurityConfigSection secConfig = (SecurityConfigSection)this.getConfigSection("Security");
        AccessControlList acls = null;
        Element aclElem = this.findChildNode("accessControl", disk.getChildNodes());
        acls = aclElem != null ? this.procAccessControlElement(aclElem, secConfig) : secConfig.getGlobalAccessControls();
        GenericConfigElement params = this.buildConfigElement(driverElem);
        boolean changeNotify = this.findChildNode("disableChangeNotification", disk.getChildNodes()) == null;
        Element volElem = this.findChildNode("volume", disk.getChildNodes());
        VolumeInfo volInfo = null;
        if (volElem != null) {
            volInfo = new VolumeInfo("");
            attr = volElem.getAttribute("label");
            if (attr != null && attr.length() > 0) {
                volInfo.setVolumeLabel(attr);
            }
            if ((attr = volElem.getAttribute("serial")) != null && attr.length() > 0) {
                try {
                    volInfo.setSerialNumber(Integer.parseInt(attr));
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Volume serial number invalid, " + attr);
                }
            }
            if ((attr = volElem.getAttribute("created")) != null && attr.length() > 0) {
                try {
                    volInfo.setCreationDateTime(this.m_dateFmt.parse(attr));
                }
                catch (ParseException ex) {
                    throw new InvalidConfigurationException("Volume creation date/time invalid, " + attr);
                }
            }
        } else {
            volInfo = new VolumeInfo(name, (int)System.currentTimeMillis(), new Date(System.currentTimeMillis()));
        }
        SrvDiskInfo diskInfo = null;
        Element sizeElem = this.findChildNode("size", disk.getChildNodes());
        if (sizeElem != null) {
            long totSize = -1L;
            long freeSize = 0L;
            attr = sizeElem.getAttribute("totalSize");
            if (attr != null && attr.length() > 0) {
                totSize = MemorySize.getByteValue(attr);
            }
            if (totSize == -1L) {
                throw new InvalidConfigurationException("Total disk size invalid or not specified");
            }
            attr = sizeElem.getAttribute("freeSize");
            freeSize = attr != null && attr.length() > 0 ? MemorySize.getByteValue(attr) : totSize / 10L * 9L;
            if (freeSize == -1L) {
                throw new InvalidConfigurationException("Free disk size invalid or not specified");
            }
            long blockSize = 512L;
            long blocksPerUnit = 64L;
            attr = sizeElem.getAttribute("blockSize");
            if (attr != null && attr.length() > 0) {
                try {
                    blockSize = Long.parseLong(attr);
                    if (blockSize <= 0L || blockSize % 512L != 0L) {
                        throw new InvalidConfigurationException("Block size must be a multiple of 512");
                    }
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid block size specified, " + attr);
                }
            }
            if ((attr = sizeElem.getAttribute("blocksPerUnit")) != null && attr.length() > 0) {
                try {
                    blocksPerUnit = Long.parseLong(attr);
                    if (blocksPerUnit <= 0L) {
                        throw new InvalidConfigurationException("Invalid blocks per unit, must be greater than zero");
                    }
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid blocks per unit value");
                }
            }
            long unitSize = blockSize * blocksPerUnit;
            long totUnits = totSize / unitSize;
            long freeUnits = freeSize / unitSize;
            diskInfo = new SrvDiskInfo(totUnits, blocksPerUnit, blockSize, freeUnits);
        } else {
            diskInfo = new SrvDiskInfo(2560000, 64, 512, 2304000);
        }
        Element cacheElem = this.findChildNode("stateCache", disk.getChildNodes());
        FileStateCache stateCache = null;
        if (cacheElem != null) {
            GenericConfigElement cacheConfig = this.buildConfigElement(cacheElem);
            attr = cacheElem.getAttribute("type");
            if (attr.equalsIgnoreCase("standalone")) {
                stateCache = new StandaloneFileStateCache();
            } else {
                if (attr.equalsIgnoreCase("cluster")) {
                    try {
                        stateCache = (FileStateCache)Class.forName("org.alfresco.jlan.server.filesys.cache.hazelcast.HazelCastClusterFileStateCache").newInstance();
                    }
                    catch (ClassNotFoundException ex) {
                        throw new InvalidConfigurationException("Clustered file state cache not available, check build/Jar");
                    }
                    catch (Exception ex) {
                        throw new InvalidConfigurationException("Failed to load clustered file state cache class, " + ex);
                    }
                }
                if (attr.equalsIgnoreCase("custom")) {
                    Element cacheClass = this.findChildNode("class", cacheElem.getChildNodes());
                    if (cacheClass == null || this.getText(cacheClass).length() == 0) {
                        throw new InvalidConfigurationException("Custom state cache class not specified");
                    }
                    try {
                        Object cacheObj = Class.forName(this.getText(cacheClass)).newInstance();
                        if (!(cacheObj instanceof FileStateCache)) {
                            throw new InvalidConfigurationException("State cache class is not a FileStateCache based class");
                        }
                        stateCache = (FileStateCache)cacheObj;
                    }
                    catch (ClassNotFoundException ex) {
                        throw new InvalidConfigurationException("Clustered file state cache not available, check build/Jar");
                    }
                    catch (Exception ex) {
                        throw new InvalidConfigurationException("Failed to load clustered file state cache class, " + ex);
                    }
                }
            }
            if (stateCache != null) {
                stateCache.initializeCache(cacheConfig, this);
            } else {
                throw new InvalidConfigurationException("Failed to initialize state cache for filesystem " + name);
            }
        }
        if (filesysConfig.getShares().findShare(name) != null) {
            throw new InvalidConfigurationException("Share " + name + " already exists");
        }
        try {
            Object drvObj = Class.forName(this.getText(classElem)).newInstance();
            if (drvObj instanceof DiskInterface) {
                DiskInterface diskDrv = (DiskInterface)drvObj;
                DiskDeviceContext devCtx = (DiskDeviceContext)diskDrv.createContext(name, params);
                devCtx.setConfigurationParameters(params);
                devCtx.enableChangeHandler(changeNotify);
                devCtx.setVolumeInformation(volInfo);
                devCtx.setDiskInformation(diskInfo);
                devCtx.setShareName(name);
                if (devCtx.requiresStateCache() && stateCache == null) {
                    stateCache = new StandaloneFileStateCache();
                    stateCache.initializeCache(new GenericConfigElement("stateCache"), this);
                }
                if (!devCtx.requiresStateCache() && stateCache != null) {
                    throw new InvalidConfigurationException("Filesystem does not use state caching");
                }
                devCtx.setStateCache(stateCache);
                DiskSharedDevice diskDev = new DiskSharedDevice(name, diskDrv, devCtx);
                diskDev.setComment(comment);
                diskDev.setConfiguration(this);
                diskDev.setAccessControlList(acls);
                if (devCtx.hasStateCache()) {
                    filesysConfig.addFileStateCache(name, devCtx.getStateCache());
                }
                devCtx.startFilesystem(diskDev);
                if (devCtx.hasStateCache()) {
                    devCtx.getStateCache().setDriverDetails(diskDev);
                }
                filesysConfig.addShare(diskDev);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidConfigurationException("Disk driver class " + this.getText(classElem) + " not found");
        }
        catch (DeviceContextException ex) {
            throw new InvalidConfigurationException("Driver context error", ex);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Disk share setup error", ex);
        }
    }

    protected final Element findChildNode(String name, NodeList list) {
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!child.getNodeName().equals(name) || child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    protected final String getText(Element elem) {
        NodeList children = elem.getChildNodes();
        String text = "";
        if (children != null && children.getLength() > 0 && children.item(0).getNodeType() != 1) {
            text = children.item(0).getNodeValue();
        }
        return text;
    }

    protected final GenericConfigElement buildConfigElement(Element root) {
        return this.buildConfigElement(root, null);
    }

    protected final GenericConfigElement buildConfigElement(Element root, GenericConfigElement cfgElem) {
        NodeList nodes;
        GenericConfigElement rootElem = cfgElem;
        if (rootElem == null) {
            rootElem = new GenericConfigElement(root.getNodeName());
            NamedNodeMap attribs = root.getAttributes();
            if (attribs != null) {
                for (int i = 0; i < attribs.getLength(); ++i) {
                    Node attribNode = attribs.item(i);
                    rootElem.addAttribute(attribNode.getNodeName(), attribNode.getNodeValue());
                }
            }
        }
        if ((nodes = root.getChildNodes()) == null) {
            return rootElem;
        }
        GenericConfigElement childElem = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element elem = (Element)node;
            NodeList children = elem.getChildNodes();
            if (children != null && children.getLength() > 1) {
                childElem = this.buildConfigElement(elem, null);
            } else {
                if (children.getLength() > 0) {
                    childElem = new GenericConfigElement(elem.getNodeName());
                    childElem.setValue(children.item(0).getNodeValue());
                } else {
                    childElem = new GenericConfigElement(elem.getNodeName());
                }
                NamedNodeMap attribs = elem.getAttributes();
                if (attribs != null) {
                    for (int j = 0; j < attribs.getLength(); ++j) {
                        Node attribNode = attribs.item(j);
                        childElem.addAttribute(attribNode.getNodeName(), attribNode.getNodeValue());
                    }
                }
            }
            rootElem.addChild(childElem);
        }
        return rootElem;
    }

    protected final List<Platform.Type> parsePlatformString(String platforms) throws InvalidConfigurationException {
        ArrayList<Platform.Type> platformIds = new ArrayList<Platform.Type>();
        if (platforms == null) {
            return platformIds;
        }
        StringTokenizer tokens = new StringTokenizer(platforms.toUpperCase(Locale.ENGLISH), ",");
        while (tokens.hasMoreTokens()) {
            String platform = tokens.nextToken().trim();
            Platform.Type id = Platform.Type.Unknown;
            if (platform.equalsIgnoreCase("WINDOWS")) {
                id = Platform.Type.WINDOWS;
            } else if (platform.equalsIgnoreCase("LINUX")) {
                id = Platform.Type.LINUX;
            } else if (platform.equalsIgnoreCase("MACOSX")) {
                id = Platform.Type.MACOSX;
            } else if (platform.equalsIgnoreCase("SOLARIS")) {
                id = Platform.Type.SOLARIS;
            }
            if (id == Platform.Type.Unknown) {
                throw new InvalidConfigurationException("Invalid platform type '" + platform + "'");
            }
            platformIds.add(id);
        }
        return platformIds;
    }

    protected final InetAddress parseAdapterName(String adapter) throws InvalidConfigurationException {
        NetworkInterface ni = null;
        try {
            ni = NetworkInterface.getByName(adapter);
        }
        catch (SocketException ex) {
            throw new InvalidConfigurationException("Invalid adapter name, " + adapter);
        }
        if (ni == null) {
            throw new InvalidConfigurationException("Invalid network adapter name, " + adapter);
        }
        InetAddress adapAddr = null;
        Enumeration<InetAddress> addrEnum = ni.getInetAddresses();
        while (addrEnum.hasMoreElements() && adapAddr == null) {
            InetAddress addr = addrEnum.nextElement();
            if (!IPAddress.isNumericAddress(addr.getHostAddress())) continue;
            adapAddr = addr;
        }
        if (adapAddr == null) {
            throw new InvalidConfigurationException("Adapter " + adapter + " does not have a valid IP address");
        }
        return adapAddr;
    }
}

