/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.lock.isolation;

import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.lock.ObjectLock;
import org.apache.ojb.otm.lock.isolation.AbstractIsolation;

public class RepeatableReadIsolation
extends AbstractIsolation {
    public void readLock(Transaction tx, ObjectLock lock) throws LockingException {
        Transaction writer = lock.getWriter();
        if (writer == null) {
            lock.readLock(tx);
            if (lock.getWriter() != null) {
                lock.releaseLock(tx);
                this.readLock(tx, lock);
            }
        } else if (tx != writer) {
            lock.waitForTx(writer);
            this.readLock(tx, lock);
        }
    }

    public void writeLock(Transaction tx, ObjectLock lock) throws LockingException {
        Collection readers = lock.getReaders();
        if (!readers.isEmpty()) {
            Iterator it = readers.iterator();
            while (it.hasNext()) {
                Transaction reader = (Transaction)it.next();
                if (reader == tx) continue;
                lock.waitForTx(reader);
                this.writeLock(tx, lock);
                return;
            }
        }
        lock.writeLock(tx);
        readers = lock.getReaders();
        if (readers.size() > 1) {
            lock.releaseLock(tx);
            this.writeLock(tx, lock);
        }
    }
}

