/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.ObjectEnvelopeOrdering;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.link.LinkEntry;
import org.apache.ojb.odmg.link.LinkEntryMtoN;
import org.apache.ojb.odmg.states.StateOldClean;
import org.odmg.LockNotGrantedException;
import org.odmg.ODMGRuntimeException;
import org.odmg.TransactionAbortedException;

public class ObjectEnvelopeTable {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$ObjectEnvelopeTable == null ? (class$org$apache$ojb$odmg$ObjectEnvelopeTable = ObjectEnvelopeTable.class$("org.apache.ojb.odmg.ObjectEnvelopeTable")) : class$org$apache$ojb$odmg$ObjectEnvelopeTable);
    private TransactionImpl transaction;
    private List newAssociatedIdentites = new ArrayList();
    private List m2nLinkList = new ArrayList();
    private List m2nUnlinkList = new ArrayList();
    private List markedForDeletionList = new ArrayList();
    private List markedForInsertList = new ArrayList();
    private Map mhtObjectEnvelopes = new HashMap();
    private ArrayList mvOrderOfIds = new ArrayList();
    private boolean needsCommit = false;
    static /* synthetic */ Class class$org$apache$ojb$odmg$ObjectEnvelopeTable;

    public ObjectEnvelopeTable(TransactionImpl myTransaction) {
        this.transaction = myTransaction;
    }

    TransactionImpl getTransaction() {
        return this.transaction;
    }

    public void refresh() {
        this.needsCommit = false;
        this.mhtObjectEnvelopes = new HashMap();
        this.mvOrderOfIds = new ArrayList();
        this.afterWriteCleanup();
    }

    void afterWriteCleanup() {
        this.m2nLinkList.clear();
        this.m2nUnlinkList.clear();
        this.newAssociatedIdentites.clear();
        this.markedForDeletionList.clear();
        this.markedForInsertList.clear();
    }

    public void writeObjects(boolean needsReusePrepare) throws TransactionAbortedException, LockNotGrantedException {
        PersistenceBroker broker = this.transaction.getBroker();
        ConnectionManagerIF connMan = broker.serviceConnectionManager();
        boolean saveBatchMode = connMan.isBatchMode();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("PB is in internal tx: " + broker.isInTransaction() + "  broker was: " + broker);
            }
            if (!broker.isInTransaction()) {
                this.log.error("PB associated with current odmg-tx is not in tx");
                throw new TransactionAbortedException("Underlying PB is not in tx, was begin call done before commit?");
            }
            connMan.setBatchMode(true);
            this.checkAllEnvelopes(broker);
            this.cascadingDependents();
            this.upgradeLockIfNeeded();
            this.reorder();
            this.writeAllEnvelopes(needsReusePrepare);
            connMan.executeBatch();
            this.cleanupEnvelopes(needsReusePrepare);
            this.afterWriteCleanup();
        }
        catch (Exception e) {
            connMan.clearBatch();
            if (e instanceof OptimisticLockException) {
                this.log.warn("Optimistic lock exception while write objects", e);
                Object sourceObject = ((OptimisticLockException)((Object)e)).getSourceObject();
                throw new LockNotGrantedException("Optimistic lock exception occur, source object was (" + sourceObject + ")," + " message was (" + e.getMessage() + ")");
            }
            if (!(e instanceof RuntimeException)) {
                this.log.warn("Error while write objects for tx " + this.transaction, e);
                throw new ODMGRuntimeException("Unexpected error while write objects: " + e.getMessage());
            }
            this.log.warn("Error while write objects for tx " + this.transaction, e);
            throw (RuntimeException)e;
        }
        finally {
            this.needsCommit = false;
            connMan.setBatchMode(saveBatchMode);
        }
    }

    private void writeAllEnvelopes(boolean needsReusePrepare) {
        if (this.needsCommit) {
            this.performM2NUnlinkEntries();
            Iterator iter = ((List)this.mvOrderOfIds.clone()).iterator();
            while (iter.hasNext()) {
                ObjectEnvelope mod = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iter.next());
                boolean insert = mod.needsInsert();
                mod.getModificationState().commit(mod);
                if (!needsReusePrepare || !insert) continue;
                this.getTransaction().doSingleLock(mod.getClassDescriptor(), mod.getObject(), mod.getIdentity(), 4);
            }
            this.performM2NLinkEntries();
        } else {
            this.performM2NUnlinkEntries();
            this.performM2NLinkEntries();
        }
    }

    private void checkAllEnvelopes(PersistenceBroker broker) {
        Iterator iter = ((List)this.mvOrderOfIds.clone()).iterator();
        while (iter.hasNext()) {
            ObjectEnvelope mod = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iter.next());
            mod.markReferenceElements(broker);
        }
    }

    private void cleanupEnvelopes(boolean needsReusePrepare) {
        if (!needsReusePrepare) {
            return;
        }
        Iterator iter = ((List)this.mvOrderOfIds.clone()).iterator();
        while (iter.hasNext()) {
            ObjectEnvelope mod = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iter.next());
            mod.refreshObjectImage();
            if (!this.needsCommit || mod.getModificationState() == StateOldClean.getInstance()) continue;
            mod.setModificationState(mod.getModificationState().markClean());
        }
    }

    private void upgradeLockIfNeeded() {
        Iterator iter = ((List)this.mvOrderOfIds.clone()).iterator();
        while (iter.hasNext()) {
            ObjectEnvelope mod = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iter.next());
            if (!mod.needsInsert()) {
                if (!mod.needsDelete() && !mod.needsUpdate() && !mod.hasChanged(this.getTransaction().getBroker())) continue;
                this.needsCommit = true;
                mod.setModificationState(mod.getModificationState().markDirty());
                ClassDescriptor cld = mod.getClassDescriptor();
                if (mod.isWriteLocked()) continue;
                this.getTransaction().doSingleLock(cld, mod.getObject(), mod.getIdentity(), 4);
                continue;
            }
            this.needsCommit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            Iterator iter = this.mvOrderOfIds.iterator();
            while (iter.hasNext()) {
                ObjectEnvelope mod = (ObjectEnvelope)this.mhtObjectEnvelopes.get(iter.next());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("rollback: " + mod);
                }
                if (mod.hasChanged(this.transaction.getBroker())) {
                    mod.setModificationState(mod.getModificationState().markDirty());
                }
                mod.getModificationState().rollback(mod);
            }
        }
        finally {
            this.needsCommit = false;
        }
        this.afterWriteCleanup();
    }

    public void remove(Object pKey) {
        Identity id = null;
        id = pKey instanceof Identity ? (Identity)pKey : this.transaction.getBroker().serviceIdentity().buildIdentity(pKey);
        this.mhtObjectEnvelopes.remove(id);
        this.mvOrderOfIds.remove(id);
    }

    public Enumeration elements() {
        return Collections.enumeration(this.mhtObjectEnvelopes.values());
    }

    public ObjectEnvelope getByIdentity(Identity id) {
        return (ObjectEnvelope)this.mhtObjectEnvelopes.get(id);
    }

    public ObjectEnvelope get(Object pKey, boolean isNew) {
        PersistenceBroker broker = this.transaction.getBroker();
        Identity oid = broker.serviceIdentity().buildIdentity(pKey);
        return this.get(oid, pKey, isNew);
    }

    public ObjectEnvelope get(Identity oid, Object pKey, boolean isNew) {
        ObjectEnvelope result = this.getByIdentity(oid);
        if (result == null) {
            result = new ObjectEnvelope(this, oid, pKey, isNew);
            this.mhtObjectEnvelopes.put(oid, result);
            this.mvOrderOfIds.add(oid);
            if (this.log.isDebugEnabled()) {
                this.log.debug("register: " + result);
            }
        }
        return result;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        buf.append((Object)"### ObjectEnvelopeTable dump:");
        Enumeration en = this.elements();
        while (en.hasMoreElements()) {
            ObjectEnvelope mod = (ObjectEnvelope)en.nextElement();
            buf.append((Object)mod.toString());
        }
        return buf.toString();
    }

    public boolean contains(Identity oid) {
        return this.mhtObjectEnvelopes.containsKey(oid);
    }

    private void reorder() {
        if (this.needsCommit) {
            ObjectEnvelopeOrdering ordering = new ObjectEnvelopeOrdering(this.transaction, this.mvOrderOfIds, this.mhtObjectEnvelopes);
            ordering.reorder();
            Identity[] newOrder = ordering.getOrdering();
            this.mvOrderOfIds.clear();
            for (int i = 0; i < newOrder.length; ++i) {
                this.mvOrderOfIds.add(newOrder[i]);
            }
        }
    }

    void cascadingDependents() {
        Iterator it = this.mhtObjectEnvelopes.values().iterator();
        while (it.hasNext()) {
            ObjectEnvelope mod = (ObjectEnvelope)it.next();
            if (mod.needsDelete()) {
                this.addForDeletionDependent(mod);
            }
            if (!mod.needsInsert()) continue;
            this.addForInsertDependent(mod);
        }
        this.cascadeMarkedForDeletion();
        this.cascadeMarkedForInsert();
    }

    void addNewAssociatedIdentity(Identity oid) {
        this.newAssociatedIdentites.add(oid);
    }

    boolean isNewAssociatedObject(Identity oid) {
        return this.newAssociatedIdentites.contains(oid);
    }

    void addForInsertDependent(ObjectEnvelope mod) {
        this.markedForInsertList.add(mod);
    }

    private void cascadeMarkedForInsert() {
        ArrayList alreadyPrepared = new ArrayList();
        for (int i = 0; i < this.markedForInsertList.size(); ++i) {
            ObjectEnvelope mod = (ObjectEnvelope)this.markedForInsertList.get(i);
            if (!mod.needsInsert()) continue;
            this.cascadeInsertFor(mod, alreadyPrepared);
            alreadyPrepared.clear();
        }
        this.markedForInsertList.clear();
    }

    private void cascadeInsertFor(ObjectEnvelope mod, List alreadyPrepared) {
        if (alreadyPrepared.contains(mod.getIdentity())) {
            return;
        }
        alreadyPrepared.add(mod.getIdentity());
        ClassDescriptor cld = this.getTransaction().getBroker().getClassDescriptor(mod.getObject().getClass());
        Vector refs = cld.getObjectReferenceDescriptors();
        this.cascadeInsertSingleReferences(mod, refs, alreadyPrepared);
        Vector colls = cld.getCollectionDescriptors();
        this.cascadeInsertCollectionReferences(mod, colls, alreadyPrepared);
    }

    private void cascadeInsertSingleReferences(ObjectEnvelope source, List descriptor, List alreadyPrepared) {
        for (int i = 0; i < descriptor.size(); ++i) {
            RuntimeObject rt;
            Identity oid;
            ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)descriptor.get(i);
            Object depObj = ord.getPersistentField().get(source.getObject());
            if (depObj == null) continue;
            source.addLinkOneToOne(ord, false);
            IndirectionHandler handler = ProxyHelper.getIndirectionHandler(depObj);
            if (handler != null && !handler.alreadyMaterialized() || alreadyPrepared.contains(oid = (rt = handler != null ? new RuntimeObject(handler.getRealSubject(), this.getTransaction(), false) : new RuntimeObject(depObj, this.getTransaction())).getIdentity())) continue;
            ObjectEnvelope depMod = this.getByIdentity(oid);
            if (depMod == null) {
                this.getTransaction().lockAndRegister(rt, 4, false);
                depMod = this.getByIdentity(oid);
            }
            if (depMod == null) {
                throw new RuntimeException("Unexpected behavior");
            }
            this.cascadeInsertFor(depMod, alreadyPrepared);
        }
    }

    private void cascadeInsertCollectionReferences(ObjectEnvelope source, List descriptor, List alreadyPrepared) {
        for (int i = 0; i < descriptor.size(); ++i) {
            CollectionDescriptor col = (CollectionDescriptor)descriptor.get(i);
            Object collOrArray = col.getPersistentField().get(source.getObject());
            CollectionProxy proxy = ProxyHelper.getCollectionProxy(collOrArray);
            if (proxy != null || collOrArray == null) continue;
            Iterator it = BrokerHelper.getCollectionIterator(collOrArray);
            while (it.hasNext()) {
                Object colObj = it.next();
                if (colObj == null) continue;
                RuntimeObject rt = new RuntimeObject(colObj, this.getTransaction());
                Identity oid = rt.getIdentity();
                if (!source.needsInsert()) continue;
                colObj = ProxyHelper.getRealObject(colObj);
                ObjectEnvelope oe = this.getByIdentity(oid);
                if (oe == null) {
                    this.getTransaction().lockAndRegister(rt, 4, false);
                    oe = this.getByIdentity(oid);
                }
                if (col.isMtoNRelation()) {
                    this.addM2NLinkEntry(col, source.getObject(), colObj);
                } else {
                    oe.addLinkOneToN(col, source.getObject(), false);
                }
                this.cascadeInsertFor(oe, alreadyPrepared);
            }
        }
    }

    void addForDeletionDependent(ObjectEnvelope mod) {
        this.markedForDeletionList.add(mod);
    }

    private void cascadeMarkedForDeletion() {
        ArrayList alreadyPrepared = new ArrayList();
        for (int i = 0; i < this.markedForDeletionList.size(); ++i) {
            ObjectEnvelope mod = (ObjectEnvelope)this.markedForDeletionList.get(i);
            if (this.isNewAssociatedObject(mod.getIdentity())) continue;
            this.cascadeDeleteFor(mod, alreadyPrepared);
            alreadyPrepared.clear();
        }
        this.markedForDeletionList.clear();
    }

    private void cascadeDeleteFor(ObjectEnvelope mod, List alreadyPrepared) {
        if (alreadyPrepared.contains(mod.getIdentity())) {
            return;
        }
        alreadyPrepared.add(mod.getIdentity());
        ClassDescriptor cld = this.getTransaction().getBroker().getClassDescriptor(mod.getObject().getClass());
        Vector refs = cld.getObjectReferenceDescriptors();
        this.cascadeDeleteSingleReferences(mod, refs, alreadyPrepared);
        Vector colls = cld.getCollectionDescriptors();
        this.cascadeDeleteCollectionReferences(mod, colls, alreadyPrepared);
    }

    private void cascadeDeleteSingleReferences(ObjectEnvelope source, List descriptor, List alreadyPrepared) {
        for (int i = 0; i < descriptor.size(); ++i) {
            Identity oid;
            Object depObj;
            ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)descriptor.get(i);
            if (!this.getTransaction().cascadeDeleteFor(ord) || (depObj = ord.getPersistentField().get(source.getObject())) == null || this.isNewAssociatedObject(oid = this.getTransaction().getBroker().serviceIdentity().buildIdentity(depObj))) continue;
            ObjectEnvelope depMod = this.get(oid, depObj, false);
            depMod.setModificationState(depMod.getModificationState().markDelete());
            this.cascadeDeleteFor(depMod, alreadyPrepared);
        }
    }

    private void cascadeDeleteCollectionReferences(ObjectEnvelope source, List descriptor, List alreadyPrepared) {
        PersistenceBroker pb = this.getTransaction().getBroker();
        for (int i = 0; i < descriptor.size(); ++i) {
            CollectionDescriptor col = (CollectionDescriptor)descriptor.get(i);
            boolean cascadeDelete = this.getTransaction().cascadeDeleteFor(col);
            Object collOrArray = col.getPersistentField().get(source.getObject());
            CollectionProxyDefaultImpl proxy = (CollectionProxyDefaultImpl)ProxyHelper.getCollectionProxy(collOrArray);
            if (proxy != null) {
                collOrArray = proxy.getData();
            }
            if (collOrArray == null) continue;
            Iterator it = BrokerHelper.getCollectionIterator(collOrArray);
            while (it.hasNext()) {
                Object colObj = ProxyHelper.getRealObject(it.next());
                Identity oid = pb.serviceIdentity().buildIdentity(colObj);
                ObjectEnvelope colMod = this.get(oid, colObj, false);
                if (cascadeDelete) {
                    colMod.setModificationState(colMod.getModificationState().markDelete());
                    this.cascadeDeleteFor(colMod, alreadyPrepared);
                } else if (!col.isMtoNRelation()) {
                    colMod.addLinkOneToN(col, source.getObject(), true);
                    colMod.setModificationState(colMod.getModificationState().markDirty());
                }
                if (!col.isMtoNRelation()) continue;
                this.addM2NUnlinkEntry(col, source.getObject(), colObj);
            }
        }
    }

    void addM2NLinkEntry(CollectionDescriptor cod, Object leftSource, Object rightSource) {
        if (!cod.isMtoNRelation()) {
            throw new OJBRuntimeException("Expect a m:n releation, but specified a 1:n");
        }
        this.m2nLinkList.add(new LinkEntryMtoN(leftSource, cod, rightSource, false));
    }

    void performM2NLinkEntries() {
        PersistenceBroker broker = this.getTransaction().getBroker();
        LinkEntry entry = null;
        for (int i = 0; i < this.m2nLinkList.size(); ++i) {
            entry = (LinkEntry)this.m2nLinkList.get(i);
            entry.execute(broker);
        }
    }

    void addM2NUnlinkEntry(CollectionDescriptor cod, Object leftSource, Object rightSource) {
        if (!cod.isMtoNRelation()) {
            throw new OJBRuntimeException("Expect a m:n releation, but specified a 1:n");
        }
        this.m2nUnlinkList.add(new LinkEntryMtoN(leftSource, cod, rightSource, true));
    }

    void performM2NUnlinkEntries() {
        PersistenceBroker broker = this.getTransaction().getBroker();
        for (int i = 0; i < this.m2nUnlinkList.size(); ++i) {
            LinkEntry entry = (LinkEntry)this.m2nUnlinkList.get(i);
            entry.execute(broker);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

