/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import javax.transaction.Synchronization;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.ImplementationImpl;
import org.apache.ojb.odmg.JTATxManager;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxUtil;
import org.odmg.LockNotGrantedException;
import org.odmg.ODMGRuntimeException;
import org.odmg.TransactionAbortedException;

public class J2EETransactionImpl
extends TransactionImpl
implements Synchronization {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$J2EETransactionImpl == null ? (class$org$apache$ojb$odmg$J2EETransactionImpl = J2EETransactionImpl.class$("org.apache.ojb.odmg.J2EETransactionImpl")) : class$org$apache$ojb$odmg$J2EETransactionImpl);
    private boolean isInExternTransaction = false;
    private boolean beforeCompletionCall = false;
    private boolean afterCompletionCall = false;
    static /* synthetic */ Class class$org$apache$ojb$odmg$J2EETransactionImpl;

    public J2EETransactionImpl(ImplementationImpl implementation) {
        super(implementation);
    }

    public void setInExternTransaction(boolean mode) {
        this.isInExternTransaction = mode;
    }

    public boolean isInExternTransaction() {
        return this.isInExternTransaction;
    }

    public void join() {
        throw new UnsupportedOperationException("Not supported in managed enviroment");
    }

    public void leave() {
        throw new UnsupportedOperationException("Not supported in managed enviroment");
    }

    public void checkpoint() {
        throw new UnsupportedOperationException("Not supported in managed enviroment");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterCompletion(int status) {
        if (this.afterCompletionCall) {
            return;
        }
        this.log.info("Method afterCompletion was called");
        try {
            switch (status) {
                case 3: {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Method afterCompletion: Do commit internal odmg-tx, status of JTA-tx is " + TxUtil.getStatusString(status));
                    }
                    this.commit();
                    return;
                }
                default: {
                    this.log.error("Method afterCompletion: Do abort call on internal odmg-tx, status of JTA-tx is " + TxUtil.getStatusString(status));
                    this.abort();
                    return;
                }
            }
        }
        finally {
            this.afterCompletionCall = true;
            this.log.info("Method afterCompletion finished");
        }
    }

    public void beforeCompletion() {
        if (this.beforeCompletionCall) {
            return;
        }
        this.log.info("Method beforeCompletion was called");
        int status = 5;
        try {
            JTATxManager mgr = (JTATxManager)this.getImplementation().getTxManager();
            status = mgr.getJTATransaction().getStatus();
            if (status == 1 || status == 4 || status == 9 || status == 5 || status == 6) {
                this.log.error("Synchronization#beforeCompletion: Can't prepare for commit, because tx status was " + TxUtil.getStatusString(status) + ". Do internal cleanup only.");
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Synchronization#beforeCompletion: Prepare for commit");
                }
                this.prepareCommit();
            }
        }
        catch (Exception e) {
            this.log.error("Synchronization#beforeCompletion: Error while prepare for commit", e);
            if (e instanceof LockNotGrantedException) {
                throw (LockNotGrantedException)e;
            }
            if (e instanceof TransactionAbortedException) {
                throw (TransactionAbortedException)e;
            }
            if (e instanceof ODMGRuntimeException) {
                throw (ODMGRuntimeException)e;
            }
            throw new ODMGRuntimeException("Method beforeCompletion() fails, status of JTA-tx was " + TxUtil.getStatusString(status) + ", message: " + e.getMessage());
        }
        finally {
            this.beforeCompletionCall = true;
            this.setInExternTransaction(false);
            this.internalCleanup();
        }
    }

    private void internalCleanup() {
        if (this.hasBroker()) {
            ConnectionManagerIF cm;
            PersistenceBroker broker = this.getBroker();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Do internal cleanup and close the internal used connection without closing the used broker");
            }
            if ((cm = broker.serviceConnectionManager()).isInLocalTransaction()) {
                cm.localCommit();
            }
            cm.releaseConnection();
        }
    }

    public void commit() {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Commit transaction " + this + ", commit on broker " + this.broker);
            }
            if (this.hasBroker()) {
                this.getBroker().commitTransaction();
                this.doClose();
            }
            this.setStatus(3);
            this.performTransactionAwareAfterCommit();
        }
        catch (Exception ex) {
            this.log.error("Unexpected error while do commit on used PB-Instance and close resources", ex);
            this.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (this.getStatus() == 4) {
            return;
        }
        try {
            try {
                this.doAbort();
            }
            catch (Exception ignore) {
                this.log.error("Failure while do abort call", ignore);
            }
            this.getImplementation().getTxManager().abortExternalTx(this);
            try {
                this.doClose();
            }
            catch (Exception e) {
                this.log.error("Failure while do abort call", e);
            }
            this.setStatus(4);
        }
        finally {
            this.setInExternTransaction(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

