/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.sql.SQLException;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.metadata.JdbcTypesHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class SequenceManagerMSSQLGuidImpl
extends AbstractSequenceManager {
    private static final JdbcType JDBC_TYPE_VARCHAR = JdbcTypesHelper.getJdbcTypeByName("varchar");

    public SequenceManagerMSSQLGuidImpl(PersistenceBroker broker) {
        super(broker);
    }

    public Object getUniqueValue(FieldDescriptor field) throws SequenceManagerException {
        if (!((Object)field.getJdbcType()).equals(JDBC_TYPE_VARCHAR)) {
            throw new SequenceManagerException("This implementation only works with fields defined as VARCHAR, but given field was " + (field != null ? field.getJdbcType() : null));
        }
        Object result = this.getUniqueString(field);
        result = field.getFieldConversion().sqlToJava(result);
        return result;
    }

    protected String getUniqueString(FieldDescriptor field) throws SequenceManagerException {
        ResultSetAndStatement rsStmt = null;
        String returnValue = null;
        try {
            rsStmt = this.getBrokerForClass().serviceJdbcAccess().executeSQL("select newid()", field.getClassDescriptor(), false);
            if (rsStmt.m_rs.next()) {
                returnValue = rsStmt.m_rs.getString(1);
            } else {
                LoggerFactory.getDefaultLogger().error(this.getClass() + ": Can't lookup new oid for field " + field);
            }
        }
        catch (PersistenceBrokerException e) {
            throw new SequenceManagerException((Throwable)((Object)e));
        }
        catch (SQLException e) {
            throw new SequenceManagerException(e);
        }
        finally {
            if (rsStmt != null) {
                rsStmt.close();
            }
        }
        return returnValue;
    }

    protected int getUniqueId(FieldDescriptor field) throws SequenceManagerException {
        throw new SequenceManagerException(SystemUtils.LINE_SEPARATOR + "Failure attempting to retrieve a Guid for a field that is an int -- field should be returned as a VARCHAR");
    }

    protected long getUniqueLong(FieldDescriptor field) throws SequenceManagerException {
        throw new SequenceManagerException(SystemUtils.LINE_SEPARATOR + "Failure attempting to retrieve a Guid for a field that is a long -- field should be returned as a VARCHAR");
    }
}

