/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.util.Map;
import java.util.Properties;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.SequenceDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.util.sequence.SequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public abstract class AbstractSequenceManager
implements SequenceManager {
    public static final String PROPERTY_AUTO_NAMING = "autoNaming";
    private PersistenceBroker brokerForClass;
    private Platform platform;
    private Properties configurationProperties;

    public AbstractSequenceManager(PersistenceBroker broker) {
        this.brokerForClass = broker;
        this.configurationProperties = new Properties();
        this.platform = this.brokerForClass.serviceConnectionManager().getSupportedPlatform();
        SequenceDescriptor sd = this.brokerForClass.serviceConnectionManager().getConnectionDescriptor().getSequenceDescriptor();
        if (sd != null) {
            this.configurationProperties.putAll((Map<?, ?>)sd.getConfigurationProperties());
        }
    }

    protected abstract long getUniqueLong(FieldDescriptor var1) throws SequenceManagerException;

    public Platform getPlatform() {
        return this.platform;
    }

    public PersistenceBroker getBrokerForClass() {
        return this.brokerForClass;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Properties prop) {
        this.configurationProperties.putAll((Map<?, ?>)prop);
    }

    public String getConfigurationProperty(String key, String defaultValue) {
        String result = this.configurationProperties.getProperty(key);
        return result != null ? result : defaultValue;
    }

    public void setConfigurationProperty(String key, String value) {
        this.configurationProperties.setProperty(key, value);
    }

    public boolean useAutoNaming() {
        return Boolean.valueOf(this.getConfigurationProperty(PROPERTY_AUTO_NAMING, "true"));
    }

    public String calculateSequenceName(FieldDescriptor field) throws SequenceManagerException {
        String seqName = field.getSequenceName();
        if (seqName == null) {
            seqName = SequenceManagerHelper.buildSequenceName(this.getBrokerForClass(), field, this.useAutoNaming());
        }
        return seqName;
    }

    public Object getUniqueValue(FieldDescriptor field) throws SequenceManagerException {
        Object result = field.getJdbcType().sequenceKeyConversion(new Long(this.getUniqueLong(field)));
        result = field.getFieldConversion().sqlToJava(result);
        return result;
    }

    public void afterStore(JdbcAccess dbAccess, ClassDescriptor cld, Object obj) throws SequenceManagerException {
    }

    public void setReferenceFKs(Object obj, ClassDescriptor cld) throws SequenceManagerException {
    }
}

