/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ojb.broker.platforms.PlatformDefaultImpl;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PlatformOracleImpl
extends PlatformDefaultImpl {
    protected static final String THIN_URL_PREFIX = "jdbc:oracle:thin";
    protected static final int THIN_BLOB_MAX_SIZE = 2000;
    protected static final int THIN_CLOB_MAX_SIZE = 4000;
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$platforms$PlatformOracleImpl == null ? (class$org$apache$ojb$broker$platforms$PlatformOracleImpl = PlatformOracleImpl.class$("org.apache.ojb.broker.platforms.PlatformOracleImpl")) : class$org$apache$ojb$broker$platforms$PlatformOracleImpl);
    static /* synthetic */ Class class$org$apache$ojb$broker$platforms$PlatformOracleImpl;

    public CallableStatement prepareNextValProcedureStatement(Connection con, String procedureName, String sequenceName) throws PlatformException {
        try {
            String sp = "{?= call " + procedureName + " (?)}";
            CallableStatement cs = con.prepareCall(sp);
            cs.registerOutParameter(1, 4);
            cs.setString(2, sequenceName);
            return cs;
        }
        catch (SQLException e) {
            throw new PlatformException(e);
        }
    }

    public void afterStatementCreate(Statement stmt) throws PlatformException {
        try {
            stmt.setEscapeProcessing(true);
        }
        catch (SQLException e) {
            throw new PlatformException("Could not set escape processing", e);
        }
    }

    public void setObjectForStatement(PreparedStatement ps, int index, Object value, int sqlType) throws SQLException {
        if ((sqlType == -3 || sqlType == -4 || sqlType == 2004) && value instanceof byte[]) {
            byte[] buf = (byte[])value;
            int length = buf.length;
            if (PlatformOracleImpl.isUsingOracleThinDriver(ps.getConnection()) && length > 2000) {
                throw new SQLException("Oracle thin driver cannot update BLOB values with length>2000. (Consider using Oracle9i as OJB platform.)");
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buf);
            this.changePreparedStatementResultSetType(ps);
            ps.setBinaryStream(index, (InputStream)inputStream, length);
        } else if (value instanceof Double) {
            ps.setDouble(index, (Double)value);
        } else if (sqlType == -5 && value instanceof Integer) {
            ps.setLong(index, ((Integer)value).intValue());
        } else if (sqlType == 4 && value instanceof Long) {
            ps.setLong(index, (Long)value);
        } else if (sqlType == 91 && value instanceof String) {
            ps.setString(index, (String)value);
        } else if (sqlType == 2005 && (value instanceof String || value instanceof byte[])) {
            Reader reader = null;
            int length = 0;
            if (value instanceof String) {
                String stringValue = (String)value;
                length = stringValue.length();
                reader = new StringReader(stringValue);
            } else {
                byte[] buf = (byte[])value;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(buf);
                reader = new InputStreamReader(inputStream);
                length = buf.length;
            }
            if (PlatformOracleImpl.isUsingOracleThinDriver(ps.getConnection()) && length > 4000) {
                throw new SQLException("Oracle thin driver cannot insert CLOB values with length>4000. (Consider using Oracle9i as OJB platform.)");
            }
            ps.setCharacterStream(index, reader, length);
        } else if ((sqlType == 1 || sqlType == 12) && (value instanceof String || value instanceof Character)) {
            if (value instanceof String) {
                ps.setString(index, (String)value);
            } else {
                ps.setString(index, value.toString());
            }
        } else {
            super.setObjectForStatement(ps, index, value, sqlType);
        }
    }

    protected void changePreparedStatementResultSetType(PreparedStatement ps) {
        try {
            final Field f = ps.getClass().getSuperclass().getDeclaredField("m_userRsetType");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    f.setAccessible(true);
                    return null;
                }
            });
            f.setInt(ps, 1);
            f.setAccessible(false);
        }
        catch (Exception e) {
            this.logger.info("Not using classes12.zip.");
        }
    }

    public byte getJoinSyntaxType() {
        return 2;
    }

    public String createSequenceQuery(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String nextSequenceQuery(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    public String dropSequenceQuery(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    protected static boolean isUsingOracleThinDriver(Connection conn) {
        if (conn == null) {
            return false;
        }
        try {
            DatabaseMetaData dbMetaData = conn.getMetaData();
            String dbUrl = dbMetaData.getURL();
            if (dbUrl != null && dbUrl.startsWith(THIN_URL_PREFIX)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

