/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.lang.reflect.Field;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class AbstractPersistentField
implements PersistentField {
    public static final String PATH_TOKEN = "::";
    public static final Class PERSISTENT_FIELD_IMPL_FOR_NESTED = class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldDirectAccessImpl == null ? (class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldDirectAccessImpl = AbstractPersistentField.class$("org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldDirectAccessImpl")) : class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldDirectAccessImpl;
    private static final int UNKNOWN_FIELD = 0;
    private static final int NORMAL_FIELD = 1;
    private static final int NESTED_FIELD = 2;
    protected transient Field field;
    protected String fieldName;
    protected Class rootObjectType;
    private int isNestedField = 0;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldDirectAccessImpl;
    static /* synthetic */ Class class$java$lang$Object;

    public AbstractPersistentField() {
    }

    public AbstractPersistentField(Class clazz, String fieldname) {
        this.rootObjectType = clazz;
        this.fieldName = fieldname;
    }

    public abstract void doSet(Object var1, Object var2);

    public abstract Object doGet(Object var1);

    public abstract boolean makeAccessible();

    public void set(Object targetObject, Object value) throws MetadataException {
        if (targetObject == null) {
            return;
        }
        if (this.isNestedField()) {
            if (value != null || !this.getField().getType().isPrimitive()) {
                this.setNestedObject(targetObject, this.fieldName, value);
            }
        } else {
            this.doSet(targetObject, value);
        }
    }

    public Object get(Object targetObject) throws MetadataException {
        if (targetObject == null) {
            return null;
        }
        if (this.isNestedField()) {
            return this.getNestedObject(targetObject, this.fieldName);
        }
        return this.doGet(targetObject);
    }

    protected Logger getLog() {
        return LoggerFactory.getLogger("PersistentField");
    }

    protected Field getField() {
        if (this.field == null) {
            this.field = AbstractPersistentField.computeField(this.rootObjectType, this.fieldName, this.isNestedField(), this.makeAccessible());
        }
        return this.field;
    }

    protected static Field computeField(Class c, String fieldname, boolean isNested, boolean makeAccessible) {
        try {
            Field f = isNested ? AbstractPersistentField.getNestedRecursiveField(c, fieldname) : AbstractPersistentField.getFieldRecursive(c, fieldname);
            if (makeAccessible) {
                f.setAccessible(true);
            }
            return f;
        }
        catch (NoSuchFieldException e) {
            throw new MetadataException("Can't find member '" + fieldname + "' in " + c.getName(), e);
        }
    }

    private static Field getFieldRecursive(Class c, String name) throws NoSuchFieldException {
        try {
            Field f = c.getDeclaredField(name);
            return f;
        }
        catch (NoSuchFieldException e) {
            if (c == (class$java$lang$Object == null ? (class$java$lang$Object = AbstractPersistentField.class$("java.lang.Object")) : class$java$lang$Object) || c.getSuperclass() == null || c.isInterface()) {
                throw e;
            }
            return AbstractPersistentField.getFieldRecursive(c.getSuperclass(), name);
        }
    }

    private static Field getNestedRecursiveField(Class c, String aFieldName) throws NoSuchFieldException {
        Field result = null;
        int index = aFieldName.indexOf(PATH_TOKEN);
        if (index >= 0) {
            String pathName = aFieldName.substring(0, index);
            Field path = AbstractPersistentField.getFieldRecursive(c, pathName);
            result = AbstractPersistentField.getNestedRecursiveField(path.getType(), aFieldName.substring(index + PATH_TOKEN.length()));
        } else {
            result = AbstractPersistentField.getFieldRecursive(c, aFieldName);
        }
        return result;
    }

    protected boolean isNestedField() {
        if (this.isNestedField == 0) {
            if (this.fieldName == null) {
                throw new MetadataException("Unexpected behaviour: fieldName is null, can not calculate field rootObjectType");
            }
            this.isNestedField = this.fieldName.indexOf(PATH_TOKEN) >= 0 ? 2 : 1;
        }
        return this.isNestedField == 2;
    }

    protected Object getNestedObject(Object obj, String aFieldName) {
        Object result = null;
        int index = aFieldName.indexOf(PATH_TOKEN);
        Object realObj = ProxyHelper.getRealObject(obj);
        Class realClass = ProxyHelper.getRealClass(obj);
        if (index >= 0) {
            String name = aFieldName.substring(0, index);
            PersistentField pField = this.createInternPersistentField(realClass, name);
            Object attrib = pField.get(realObj);
            if (attrib != null) {
                String nestedName = aFieldName.substring(index + PATH_TOKEN.length());
                result = this.getNestedObject(attrib, nestedName);
            }
        } else {
            PersistentField pField = this.createInternPersistentField(realClass, aFieldName);
            result = pField.get(realObj);
        }
        return result;
    }

    protected void setNestedObject(Object obj, String fieldName, Object value) {
        int index = fieldName.indexOf(PATH_TOKEN);
        Class realClass = ProxyHelper.getRealClass(obj);
        Object realObj = ProxyHelper.getRealObject(obj);
        if (index >= 0) {
            String name = fieldName.substring(0, index);
            PersistentField pField = this.createInternPersistentField(realClass, name);
            Object attrib = pField.get(realObj);
            if (attrib != null || value != null) {
                if (attrib == null) {
                    try {
                        attrib = this.createNestedFieldValue(pField);
                    }
                    catch (InstantiationException e) {
                        throw new MetadataException("Error instantiate field: " + name + " in object:" + realClass.getName(), e);
                    }
                    catch (IllegalAccessException e) {
                        throw new MetadataException("Error getting field:" + name + " in object:" + realClass.getName(), e);
                    }
                    if (pField instanceof AbstractPersistentField) {
                        ((AbstractPersistentField)pField).doSet(realObj, attrib);
                    } else {
                        pField.set(realObj, attrib);
                    }
                }
                String nestedName = fieldName.substring(index + PATH_TOKEN.length());
                this.setNestedObject(attrib, nestedName, value);
            }
        } else {
            PersistentField pField = this.createInternPersistentField(realClass, fieldName);
            pField.set(realObj, value);
        }
    }

    protected Object createNestedFieldValue(PersistentField nestedField) throws InstantiationException, IllegalAccessException {
        return nestedField.getType().newInstance();
    }

    private PersistentField createInternPersistentField(Class fieldType, String aFieldName) {
        try {
            return PersistentFieldFactory.createPersistentField(fieldType, aFieldName);
        }
        catch (Exception e) {
            throw new MetadataException("Cannot create PersistentField for field '" + aFieldName + "' of class " + fieldType.getName(), e);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("fieldName=");
        buf.append(this.fieldName);
        buf.append(", field [");
        buf.append(this.field);
        buf.append("]");
        return buf.toString();
    }

    public String getName() {
        return this.fieldName;
    }

    public Class getType() {
        return this.getField().getType();
    }

    public Class getDeclaringClass() {
        return this.getField().getDeclaringClass();
    }

    public String buildMessageString(Object obj, Object value, Field aField) {
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer buf = new StringBuffer();
        buf.append(eol + "[try to set 'object value' in 'target object'").append(eol + "target obj class: " + (obj != null ? obj.getClass().getName() : null)).append(eol + "target field name: " + (aField != null ? aField.getName() : null)).append(eol + "target field type: " + (aField != null ? aField.getType() : null)).append(eol + "object value class: " + (value != null ? value.getClass().getName() : null)).append(eol + "object value: " + (value != null ? value : null)).append(eol + "]");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

