/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.pooling.PoolConfiguration;

public class ConnectionPoolDescriptor
extends PoolConfiguration
implements Serializable,
XmlCapable {
    private static final long serialVersionUID = -3071461685659671879L;
    private Class connectionFactory;

    public ConnectionPoolDescriptor() {
        this.init();
    }

    public void init() {
        this.setTestOnBorrow(true);
        this.setTestOnReturn(false);
        this.setTestWhileIdle(false);
        this.setLogAbandoned(false);
        this.setRemoveAbandoned(false);
    }

    public Class getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(Class connectionFactory) {
        if (connectionFactory == null) {
            throw new MetadataException("Given ConnectionFactory was null");
        }
        this.connectionFactory = connectionFactory;
    }

    public String toXML() {
        RepositoryTags tags = RepositoryTags.getInstance();
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer buf = new StringBuffer();
        buf.append("      " + tags.getOpeningTagNonClosingById(65) + eol);
        buf.append("         " + tags.getAttribute(55, "" + this.getMaxActive()) + eol);
        buf.append("         " + tags.getAttribute(56, "" + this.getMaxIdle()) + eol);
        buf.append("         " + tags.getAttribute(57, "" + this.getMaxWait()) + eol);
        buf.append("         " + tags.getAttribute(58, "" + this.getMinEvictableIdleTimeMillis()) + eol);
        buf.append("         " + tags.getAttribute(59, "" + this.getNumTestsPerEvictionRun()) + eol);
        buf.append("         " + tags.getAttribute(60, "" + this.isTestOnBorrow()) + eol);
        buf.append("         " + tags.getAttribute(61, "" + this.isTestOnReturn()) + eol);
        buf.append("         " + tags.getAttribute(62, "" + this.isTestWhileIdle()) + eol);
        buf.append("         " + tags.getAttribute(63, "" + this.getTimeBetweenEvictionRunsMillis()) + eol);
        buf.append("         " + tags.getAttribute(64, "" + this.getWhenExhaustedAction()) + eol);
        buf.append("         " + tags.getAttribute(79, "" + this.getValidationQuery()) + eol);
        buf.append("         " + tags.getAttribute(87, "" + this.isLogAbandoned()) + eol);
        buf.append("         " + tags.getAttribute(85, "" + this.isRemoveAbandoned()) + eol);
        buf.append("         " + tags.getAttribute(86, "" + this.getRemoveAbandonedTimeout()) + eol);
        buf.append("      />" + eol);
        return buf.toString();
    }
}

