/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.apache.ojb.broker.locking.LockManager;
import org.apache.ojb.broker.locking.LockRuntimeException;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class LockManagerRemoteImpl
implements LockManager,
Configurable {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$locking$LockManagerRemoteImpl == null ? (class$org$apache$ojb$broker$locking$LockManagerRemoteImpl = LockManagerRemoteImpl.class$("org.apache.ojb.broker.locking.LockManagerRemoteImpl")) : class$org$apache$ojb$broker$locking$LockManagerRemoteImpl);
    public static final byte METHOD_READ_LOCK = 97;
    public static final byte METHOD_WRITE_LOCK = 115;
    public static final byte METHOD_UPGRADE_LOCK = 117;
    public static final byte METHOD_CHECK_READ = 114;
    public static final byte METHOD_CHECK_WRITE = 119;
    public static final byte METHOD_CHECK_UPGRADE = 118;
    public static final byte METHOD_RELEASE_SINGLE_LOCK = 101;
    public static final byte METHOD_RELEASE_LOCKS = 120;
    public static final byte METHOD_LOCK_INFO = 105;
    public static final byte METHOD_LOCK_TIMEOUT = 116;
    public static final byte METHOD_LOCK_TIMEOUT_SET = 121;
    public static final byte METHOD_BLOCK_TIMEOUT = 99;
    public static final byte METHOD_BLOCK_TIMEOUT_SET = 100;
    private static URL lockservlet = null;
    static /* synthetic */ Class class$org$apache$ojb$broker$locking$LockManagerRemoteImpl;

    public void configure(Configuration pConfig) throws ConfigurationException {
        String url = pConfig.getString("LockServletUrl", "http://127.0.0.1:8080/ojb-lockserver");
        this.log.info("Lock server servlet URL: " + url);
        try {
            lockservlet = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid LockServlet Url was specified: " + url, e);
        }
    }

    public void setLockTimeout(long timeout) {
    }

    public long getLockTimeout() {
        LockInfo info = new LockInfo(116);
        try {
            byte[] requestBarr = this.serialize(info);
            return this.performRequestLong(requestBarr);
        }
        catch (Throwable t) {
            throw new LockRuntimeException("Can't get locking info", t);
        }
    }

    public long getBlockTimeout() {
        LockInfo info = new LockInfo(99);
        try {
            byte[] requestBarr = this.serialize(info);
            return this.performRequestLong(requestBarr);
        }
        catch (Throwable t) {
            throw new LockRuntimeException("Can't get block timeout value", t);
        }
    }

    public void setBlockTimeout(long timeout) {
    }

    public String getLockInfo() {
        LockInfo info = new LockInfo(105);
        try {
            byte[] requestBarr = this.serialize(info);
            return this.performRequestString(requestBarr);
        }
        catch (Throwable t) {
            throw new LockRuntimeException("Can't get locking info", t);
        }
    }

    public boolean readLock(Object key, Object resourceId, int isolationLevel) {
        LockInfo info = new LockInfo(key, resourceId, isolationLevel, 97);
        try {
            byte[] requestBarr = this.serialize(info);
            return this.performRequest(requestBarr);
        }
        catch (Throwable t) {
            throw new LockRuntimeException("Cannot check read lock for '" + resourceId + "' using key '" + key + "'", t);
        }
    }

    public boolean releaseLock(Object key, Object resourceId) {
        LockInfo info = new LockInfo(key, resourceId, 101);
        try {
            byte[] requestBarr = this.serialize(info);
            return this.performRequest(requestBarr);
        }
        catch (Throwable t) {
            throw new LockRuntimeException("Cannot remove write lock for '" + resourceId + "' using key '" + key + "'", t);
        }
    }

    public void releaseLocks(Object key) {
        LockInfo info = new LockInfo(key, null, 120);
        try {
            byte[] requestBarr = this.serialize(info);
            this.performRequest(requestBarr);
        }
        catch (Throwable t) {
            throw new LockRuntimeException("Cannot release locks using owner key '" + key + "'", t);
        }
    }

    public boolean writeLock(Object key, Object resourceId, int isolationLevel) {
        LockInfo info = new LockInfo(key, resourceId, isolationLevel, 115);
        try {
            byte[] requestBarr = this.serialize(info);
            return this.performRequest(requestBarr);
        }
        catch (Throwable t) {
            throw new LockRuntimeException("Cannot set write lock for '" + resourceId + "' using key '" + key + "'", t);
        }
    }

    public boolean upgradeLock(Object key, Object resourceId, int isolationLevel) {
        LockInfo info = new LockInfo(key, resourceId, isolationLevel, 117);
        try {
            byte[] requestBarr = this.serialize(info);
            return this.performRequest(requestBarr);
        }
        catch (Throwable t) {
            throw new LockRuntimeException("Cannot set write lock for '" + resourceId + "' using key '" + key + "'", t);
        }
    }

    public boolean hasRead(Object key, Object resourceId) {
        try {
            byte[] requestBarr = this.serialize(new LockInfo(key, resourceId, 114));
            return this.performRequest(requestBarr);
        }
        catch (Throwable t) {
            throw new LockRuntimeException("Cannot check read lock for '" + resourceId + "' using key '" + key + "'", t);
        }
    }

    public boolean hasWrite(Object key, Object resourceId) {
        try {
            byte[] requestBarr = this.serialize(new LockInfo(key, resourceId, 119));
            return this.performRequest(requestBarr);
        }
        catch (Throwable t) {
            throw new LockRuntimeException("Cannot check write lock for '" + resourceId + "' using key '" + key + "'", t);
        }
    }

    public boolean hasUpgrade(Object key, Object resourceId) {
        try {
            byte[] requestBarr = this.serialize(new LockInfo(key, resourceId, 118));
            return this.performRequest(requestBarr);
        }
        catch (Throwable t) {
            throw new LockRuntimeException("Cannot check write lock for '" + resourceId + "' using key '" + key + "'", t);
        }
    }

    private HttpURLConnection getHttpUrlConnection() throws MalformedURLException, IOException, ProtocolException {
        URL lockserver = this.getLockserverUrl();
        HttpURLConnection conn = (HttpURLConnection)lockserver.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setAllowUserInteraction(false);
        conn.setUseCaches(false);
        return conn;
    }

    private URL getLockserverUrl() {
        return lockservlet;
    }

    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bao);
        oos.writeObject(obj);
        oos.close();
        bao.close();
        byte[] result = bao.toByteArray();
        return result;
    }

    private boolean performRequest(byte[] requestBarr) throws IOException, ClassNotFoundException {
        Object result = this.performRequestObject(requestBarr);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new LockRuntimeException("Remote lock server error, expect return value of type 'Boolean'");
    }

    private String performRequestString(byte[] requestBarr) throws IOException, ClassNotFoundException {
        Object result = this.performRequestObject(requestBarr);
        if (result instanceof String) {
            return (String)result;
        }
        throw new LockRuntimeException("Remote lock server error, expect return value of type 'String'");
    }

    private long performRequestLong(byte[] requestBarr) throws IOException, ClassNotFoundException {
        Object result = this.performRequestObject(requestBarr);
        if (result instanceof Long) {
            return (Long)result;
        }
        throw new LockRuntimeException("Remote lock server error, expect return value of type 'String'");
    }

    private Object performRequestObject(byte[] requestBarr) throws IOException, ClassNotFoundException {
        HttpURLConnection conn = this.getHttpUrlConnection();
        BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
        out.write(requestBarr, 0, requestBarr.length);
        out.flush();
        InputStream in = conn.getInputStream();
        ObjectInputStream ois = new ObjectInputStream(in);
        Object result = ois.readObject();
        ois.close();
        out.close();
        conn.disconnect();
        if (result instanceof Throwable) {
            throw new LockRuntimeException("Remote lock server error", (Throwable)result);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class LockInfo
    implements Serializable {
        public Object key;
        public Object resourceId;
        public int isolationLevel;
        public byte methodName;
        public long lockTimeout;
        public long blockTimeout;

        public LockInfo(byte methodName) {
            this.methodName = methodName;
        }

        public LockInfo(Object key, Object resourceId, byte methodName) {
            this.key = key;
            this.resourceId = resourceId;
            this.methodName = methodName;
        }

        public LockInfo(Object key, Object resourceId, int isolationLevel, byte methodName) {
            this.key = key;
            this.resourceId = resourceId;
            this.isolationLevel = isolationLevel;
            this.methodName = methodName;
        }
    }
}

