/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;

public class PersistenceBrokerThreadMapping {
    private static ThreadLocal currentBrokerMap = new ThreadLocal();

    public static void setCurrentPersistenceBroker(PBKey key, PersistenceBroker broker) throws PBFactoryException {
        HashMap<PBKey, WeakHashMap<PersistenceBroker, Object>> map = (HashMap<PBKey, WeakHashMap<PersistenceBroker, Object>>)currentBrokerMap.get();
        WeakHashMap<PersistenceBroker, Object> set = null;
        if (map == null) {
            map = new HashMap<PBKey, WeakHashMap<PersistenceBroker, Object>>();
            currentBrokerMap.set(map);
        } else {
            set = (WeakHashMap<PersistenceBroker, Object>)map.get(key);
        }
        if (set == null) {
            set = new WeakHashMap<PersistenceBroker, Object>();
            map.put(key, set);
        }
        set.put(broker, null);
    }

    public static void unsetCurrentPersistenceBroker(PBKey key, PersistenceBroker broker) throws PBFactoryException {
        HashMap map = (HashMap)currentBrokerMap.get();
        WeakHashMap set = null;
        if (map != null && (set = (WeakHashMap)map.get(key)) != null) {
            set.remove(broker);
        }
    }

    public static PersistenceBroker currentPersistenceBroker(PBKey key) throws PBFactoryException, PersistenceBrokerException {
        HashMap map = (HashMap)currentBrokerMap.get();
        PersistenceBroker broker = null;
        if (map == null) {
            return null;
        }
        WeakHashMap set = (WeakHashMap)map.get(key);
        if (set == null) {
            return null;
        }
        Iterator it = set.keySet().iterator();
        while (it.hasNext()) {
            PersistenceBroker tmp = (PersistenceBroker)it.next();
            if (tmp == null || tmp.isClosed()) {
                it.remove();
                continue;
            }
            broker = tmp;
            if (!tmp.isInTransaction()) continue;
            break;
        }
        return broker;
    }
}

