/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.conversions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.accesslayer.conversions.ConversionException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;

public class StringList2VarcharFieldConversion
implements FieldConversion {
    private static final String NULLVALUE = "#NULL#";
    private static final String EMPTYCOLLEC = "#EMTPY#";

    public Object javaToSql(Object source) throws ConversionException {
        if (source == null) {
            return NULLVALUE;
        }
        try {
            List stringList = (List)source;
            if (stringList.isEmpty()) {
                return NULLVALUE;
            }
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < stringList.size(); ++i) {
                String newSt = (String)stringList.get(i);
                newSt = StringUtils.replace((String)newSt, (String)"#", (String)"##");
                if (i > 0) {
                    result.append("#");
                }
                result.append(newSt);
            }
            return result.toString();
        }
        catch (ClassCastException e) {
            throw new ConversionException("Object is not a List of String it is a" + source.getClass().getName());
        }
    }

    public Object sqlToJava(Object source) throws ConversionException {
        if (source == null) {
            return null;
        }
        if (source.toString().equals(NULLVALUE)) {
            return null;
        }
        if (source.toString().equals(EMPTYCOLLEC)) {
            return new ArrayList();
        }
        ArrayList<String> v = new ArrayList<String>();
        StringBuffer input = new StringBuffer();
        StringBuffer newString = new StringBuffer();
        input.append(source.toString());
        int length = input.length();
        for (int pos = 0; pos < length; ++pos) {
            if (input.charAt(pos) != '#') {
                newString.append(input.charAt(pos));
                continue;
            }
            if (input.charAt(pos + 1) != '#') {
                v.add(newString.toString());
                newString = new StringBuffer();
                continue;
            }
            newString.append('#');
            ++pos;
        }
        v.add(newString.toString());
        return v;
    }
}

