/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.util.BrokerHelper;

public class Identity
implements Serializable {
    static final long serialVersionUID = 3182285550574178710L;
    private Class m_objectsTopLevelClass;
    private Class m_objectsRealClass = null;
    private Object[] m_pkValues;
    private transient String m_stringRepresentation = null;
    private transient Integer m_hashCode;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$ValueContainer;

    public Identity(Class realClass, Class topLevel, Object[] pkValues) {
        this.m_objectsTopLevelClass = topLevel;
        this.m_objectsRealClass = realClass;
        this.m_pkValues = pkValues;
        this.checkForPrimaryKeys(null);
    }

    public Identity(Object objectToIdentitify, PersistenceBroker targetBroker) {
        this.init(objectToIdentitify, targetBroker, null);
    }

    public Identity(Object objectToIdentitify, PersistenceBroker targetBroker, ClassDescriptor cld) {
        this.init(objectToIdentitify, targetBroker, cld);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Object objectToIdentify, PersistenceBroker targetBroker, ClassDescriptor cld) {
        if (objectToIdentify == null) {
            throw new OJBRuntimeException("Can't create Identity for 'null'-object");
        }
        try {
            IndirectionHandler handler = ProxyHelper.getIndirectionHandler(objectToIdentify);
            Object object = objectToIdentify;
            synchronized (object) {
                if (handler != null) {
                    Identity sourceOID = handler.getIdentity();
                    this.m_objectsTopLevelClass = sourceOID.m_objectsTopLevelClass;
                    this.m_objectsRealClass = sourceOID.m_objectsRealClass;
                    this.m_pkValues = sourceOID.m_pkValues;
                } else {
                    if (cld == null) {
                        cld = targetBroker.getClassDescriptor(objectToIdentify.getClass());
                    }
                    this.m_objectsTopLevelClass = targetBroker.getTopLevelClass(objectToIdentify.getClass());
                    this.m_objectsRealClass = objectToIdentify.getClass();
                    BrokerHelper helper = targetBroker.serviceBrokerHelper();
                    ValueContainer[] pkValues = helper.getKeyValues(cld, objectToIdentify, false);
                    if (pkValues == null || pkValues.length == 0) {
                        throw this.createException("Can't extract PK value fields", objectToIdentify, null);
                    }
                    this.m_pkValues = helper.extractValueArray(pkValues);
                }
            }
            this.checkForPrimaryKeys(objectToIdentify);
        }
        catch (ClassNotPersistenceCapableException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.createException("Can not init Identity for given object.", objectToIdentify, e);
        }
    }

    public static Identity fromByteArray(byte[] anArray) throws PersistenceBrokerException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(anArray);
            GZIPInputStream gis = new GZIPInputStream(bais);
            ObjectInputStream ois = new ObjectInputStream(gis);
            Identity result = (Identity)ois.readObject();
            ois.close();
            gis.close();
            bais.close();
            return result;
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
    }

    public Class getObjectsTopLevelClass() {
        return this.m_objectsTopLevelClass;
    }

    public Class getObjectsRealClass() {
        return this.m_objectsRealClass;
    }

    public void setObjectsRealClass(Class objectsRealClass) {
        this.m_objectsRealClass = objectsRealClass;
    }

    public byte[] serialize() throws PersistenceBrokerException {
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(bao);
            ObjectOutputStream oos = new ObjectOutputStream(gos);
            oos.writeObject(this);
            oos.close();
            gos.close();
            bao.close();
            byte[] result = bao.toByteArray();
            return result;
        }
        catch (Exception ignored) {
            throw new PersistenceBrokerException(ignored);
        }
    }

    public String toString() {
        if (this.m_stringRepresentation == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.m_objectsTopLevelClass.getName());
            for (int i = 0; i < this.m_pkValues.length; ++i) {
                buf.append(i == 0 ? "{" : ",");
                buf.append(this.m_pkValues[i]);
            }
            buf.append("}");
            this.m_stringRepresentation = buf.toString();
        }
        return this.m_stringRepresentation;
    }

    protected void checkForPrimaryKeys(Object realObject) throws ClassNotPersistenceCapableException {
        if (this.m_pkValues == null || this.m_pkValues.length == 0) {
            throw this.createException("OJB needs at least one primary key attribute for class: ", realObject, null);
        }
        if (this.m_pkValues[0] instanceof ValueContainer) {
            throw new OJBRuntimeException("Can't handle pk values of type " + (class$org$apache$ojb$broker$core$ValueContainer == null ? (class$org$apache$ojb$broker$core$ValueContainer = Identity.class$("org.apache.ojb.broker.core.ValueContainer")) : class$org$apache$ojb$broker$core$ValueContainer).getName());
        }
    }

    public Object[] getPrimaryKeyValues() {
        return this.m_pkValues;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean result = false;
        if (obj instanceof Identity) {
            Identity id = (Identity)obj;
            Object[] otherPkValues = id.getPrimaryKeyValues();
            result = this.getObjectsTopLevelClass().equals(id.getObjectsTopLevelClass()) && this.m_pkValues.length == otherPkValues.length;
            for (int i = 0; result && i < this.m_pkValues.length; ++i) {
                boolean bl = this.m_pkValues[i] == null ? otherPkValues[i] == null : (result = this.m_pkValues[i].equals(otherPkValues[i]));
                if (result || !(this.m_pkValues[i] instanceof byte[]) || !(otherPkValues[i] instanceof byte[])) continue;
                result = Arrays.equals((byte[])this.m_pkValues[i], (byte[])otherPkValues[i]);
            }
        }
        return result;
    }

    public int hashCode() {
        if (this.m_hashCode == null) {
            HashCodeBuilder hb = new HashCodeBuilder();
            for (int i = 0; i < this.m_pkValues.length; ++i) {
                hb.append(this.m_pkValues[i]);
            }
            hb.append((Object)this.getObjectsTopLevelClass().getName());
            this.m_hashCode = new Integer(hb.toHashCode());
        }
        return this.m_hashCode;
    }

    private ClassNotPersistenceCapableException createException(String msg, Object objectToIdentify, Exception e) {
        String eol = SystemUtils.LINE_SEPARATOR;
        if (msg == null) {
            msg = "Unexpected error:";
        }
        if (e != null) {
            return new ClassNotPersistenceCapableException(msg + eol + "objectTopLevelClass=" + (this.m_objectsTopLevelClass != null ? this.m_objectsTopLevelClass.getName() : null) + eol + "objectRealClass=" + (this.m_objectsRealClass != null ? this.m_objectsRealClass.getName() : null) + eol + "pkValues=" + (this.m_pkValues != null ? ArrayUtils.toString((Object)this.m_pkValues) : null) + (objectToIdentify != null ? eol + "object to identify: " + objectToIdentify : ""), e);
        }
        return new ClassNotPersistenceCapableException(msg + eol + "objectTopLevelClass=" + (this.m_objectsTopLevelClass != null ? this.m_objectsTopLevelClass.getName() : null) + eol + "objectRealClass=" + (this.m_objectsRealClass != null ? this.m_objectsRealClass.getName() : null) + eol + "pkValues=" + (this.m_pkValues != null ? ArrayUtils.toString((Object)this.m_pkValues) : null) + eol + "object to identify: " + objectToIdentify);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

