/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.catonine.tail;

import java.io.IOException;
import java.util.ArrayList;
import nu.zoom.catonine.tail.AbstractExecutorTailer;
import nu.zoom.catonine.tail.Tailer;
import nu.zoom.catonine.tail.TailerListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class AbstractThreadedTailer
extends AbstractExecutorTailer
implements Runnable,
Tailer {
    private final Log log = LogFactory.getLog(this.getClass());
    private Thread tailThread;
    private boolean tail = false;
    private static final long SLEEP_TIME = 1234L;
    protected final ThreadGroup tailThreadGroup = new ThreadGroup("Tailer");

    AbstractThreadedTailer() {
    }

    @Override
    public synchronized void run() {
        this.log.trace((Object)"Tail thread started");
        while (this.tail) {
            try {
                this.fireWork(true);
                this.read();
                this.fireWork(false);
                try {
                    this.wait(1234L);
                }
                catch (InterruptedException e) {
                    this.tail = false;
                    this.log.debug((Object)"Tail thread interrupted", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            catch (IOException e) {
                ArrayList<TailerListener.LogEntry> errorMessages = new ArrayList<TailerListener.LogEntry>();
                errorMessages.add(new TailerListener.LogEntry(0L, "IOException while tailing"));
                errorMessages.add(new TailerListener.LogEntry(26L, e.toString()));
                errorMessages.add(new TailerListener.LogEntry(e.toString().length() + 26, "Aborting tail thread"));
                this.fireLinesRead(errorMessages);
                this.tail = false;
                this.log.error((Object)"Aborting tail thread", (Throwable)e);
            }
        }
        this.log.trace((Object)"Tail thread exiting");
        this.fireStopped();
        this.notifyAll();
        this.executor.shutdown();
    }

    @Override
    public synchronized boolean isTailing() {
        return this.tail && this.tailThread.isAlive();
    }

    @Override
    public synchronized void start() throws IllegalStateException {
        if (this.tailThread == null) {
            this.log.trace((Object)"Initializing tail thread");
            this.tail = true;
            this.tailThread = new Thread(this.tailThreadGroup, this, "Tail thread");
            this.tailThread.setDaemon(true);
            this.tailThread.start();
        }
    }

    @Override
    public synchronized void stop() {
        this.log.trace((Object)"Stopping tail thread");
        this.tail = false;
        if (this.tailThread != null) {
            this.log.trace((Object)"Interrupting tail thread");
            this.tailThread.interrupt();
            this.log.debug((Object)("Interrupted thread: " + this.tailThread));
            this.tailThread = null;
        }
    }

    protected void stopAndWait() {
        this.stop();
        while (this.isTailing()) {
            try {
                this.wait(123L);
            }
            catch (InterruptedException e) {
                this.log.debug((Object)"Interrupted while waiting for stop");
                Thread.currentThread().interrupt();
            }
        }
    }

    protected abstract void read() throws IOException;
}

