/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.catonine.stylerule;

import java.awt.EventQueue;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import nu.zoom.catonine.stylerule.StyleRules;
import nu.zoom.catonine.stylerule.StyleRulesListener;
import nu.zoom.catonine.stylerule.StyleRulesManager;
import nu.zoom.catonine.stylerule.StyleRulesManagerListener;

public class StyleRulesListModel
extends DefaultComboBoxModel
implements StyleRulesManagerListener,
StyleRulesListener {
    private static final long serialVersionUID = 1L;
    private List<StyleRules> styleRules;
    private final boolean includeEmptyItem;

    public StyleRulesListModel(StyleRulesManager manager, boolean includeEmptyItem) {
        this.styleRules = manager.getStyleRules();
        manager.addListener(this);
        this.addMeToListeningToRules();
        this.includeEmptyItem = includeEmptyItem;
    }

    @Override
    public synchronized int getSize() {
        return this.includeEmptyItem ? this.styleRules.size() + 1 : this.styleRules.size();
    }

    @Override
    public synchronized StyleRules getElementAt(int index) {
        if (this.includeEmptyItem) {
            if (index == 0) {
                return null;
            }
            return this.styleRules.get(index - 1);
        }
        return this.styleRules.get(index);
    }

    @Override
    public synchronized void styleRulesChanged(StyleRulesManager manager) {
        this.styleRules = manager.getStyleRules();
        this.fireIntervalRemoved(this, 0, this.styleRules.size());
        this.removeMeFromListeningToRules();
        this.addMeToListeningToRules();
        this.fireIntervalAdded(this, 0, this.styleRules.size());
    }

    private synchronized void removeMeFromListeningToRules() {
        for (StyleRules rules : this.styleRules) {
            rules.removeListener(this);
        }
    }

    private synchronized void addMeToListeningToRules() {
        for (StyleRules rules : this.styleRules) {
            rules.addListener(this);
        }
    }

    @Override
    public void listStructureChanged(StyleRules list) {
    }

    @Override
    public void listDataChanged(StyleRules list) {
    }

    @Override
    public synchronized void listChangedName(StyleRules list) {
        final int index = this.styleRules.indexOf(list);
        if (index != -1) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StyleRulesListModel.this.fireContentsChanged(this, index, index);
                }
            });
        }
    }
}

