/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.catonine.fontchooser.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.font.TextAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import nu.zoom.catonine.fontchooser.FontChooser;
import nu.zoom.catonine.fontchooser.impl.FontChooserImpl;
import nu.zoom.catonine.stylerule.ChangeTracker;
import nu.zoom.swing.action.AbstractTypedAction;
import nu.zoom.swing.field.IntegerField;
import nu.zoom.swing.field.ValidatingField;
import nu.zoom.swing.layout.VerticalPanel;
import nu.zoom.ui.Resources;

public class FontChooserPanel
extends JPanel
implements ChangeTracker {
    private static final long serialVersionUID = -235872476377798595L;
    private final Resources resources;
    private final FontChooserImpl owner;
    private final AtomicBoolean changed = new AtomicBoolean(false);
    private final AtomicBoolean bold = new AtomicBoolean(false);
    private final AtomicBoolean italic = new AtomicBoolean(false);
    private FontListItem currentFontItem;
    private int fontSize = 12;
    private Font font;
    private final Font defaultFont;

    public FontChooserPanel(Resources resources, FontChooserImpl owner, Font startFont, Font defaultFont) {
        this.resources = resources;
        this.owner = owner;
        this.defaultFont = defaultFont;
        if (startFont != null) {
            this.font = startFont;
            this.bold.set(startFont.isBold());
            this.italic.set(startFont.isItalic());
            this.currentFontItem = new FontListItem(startFont.getFamily(), false);
            this.fontSize = startFont.getSize();
        } else {
            this.currentFontItem = new FontListItem("<default>", true);
        }
    }

    void initGUI() throws Resources.ResourceNotFoundException {
        SamplePanel samplePanel = new SamplePanel();
        this.owner.addFontValuesListener(samplePanel);
        if (this.font != null) {
            samplePanel.setFont(this.font);
        }
        Object[] availableFontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(availableFontFamilyNames);
        Vector<FontListItem> items = new Vector<FontListItem>();
        items.add(new FontListItem("<default>", true));
        for (Object fontName : availableFontFamilyNames) {
            items.add(new FontListItem((String)fontName, false));
        }
        final JList fontNameList = new JList(items);
        if (this.currentFontItem != null) {
            ListModel listModel = fontNameList.getModel();
            for (int n = 0; n < listModel.getSize(); ++n) {
                FontListItem item = (FontListItem)listModel.getElementAt(n);
                if (!this.currentFontItem.equals(item)) continue;
                fontNameList.setSelectedIndex(n);
                break;
            }
        } else {
            fontNameList.setSelectedIndex(0);
        }
        fontNameList.setSelectionMode(0);
        fontNameList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FontChooserPanel.this.currentFontItem = (FontListItem)fontNameList.getSelectedValue();
                FontChooserPanel.this.changed.set(true);
                FontChooserPanel.this.updateFont();
            }
        });
        JScrollPane fontNameScroller = new JScrollPane(fontNameList);
        JLabel sizeLabel = new JLabel(this.resources.getMessage("nu.zoom.catonine.fontchooser.setting.size"));
        IntegerField sizeField = new IntegerField(sizeLabel, 4){
            private static final long serialVersionUID = -3646290648724161680L;

            protected ValidatingField.ValidationResult validateDocument() {
                int value;
                ValidatingField.ValidationResult validationResult = super.validateDocument();
                if (ValidatingField.ValidationResult.PASSED.equals(validationResult) && ((value = Integer.parseInt(this.getText())) < 8 || value > 24)) {
                    String failMessage;
                    try {
                        failMessage = FontChooserPanel.this.resources.getMessage("nu.zoom.catonine.fontchooser.setting.size.validation");
                    }
                    catch (Resources.ResourceNotFoundException e) {
                        failMessage = "Font size out of range";
                    }
                    validationResult = new ValidatingField.ValidationResult(failMessage);
                }
                return validationResult;
            }

            protected void validationPassed() {
                super.validationPassed();
                FontChooserPanel.this.fontSize = Integer.parseInt(this.getText());
                FontChooserPanel.this.changed.set(true);
                FontChooserPanel.this.updateFont();
            }
        };
        if (this.fontSize > 1) {
            sizeField.setText(Integer.toString(this.fontSize));
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(3));
        JToggleButton italicButton = new JToggleButton((Action)((Object)new ItalicAction(this.resources)));
        italicButton.setSelected(this.italic.get());
        buttonPanel.add(italicButton);
        JToggleButton boldButton = new JToggleButton((Action)((Object)new BoldAction(this.resources)));
        boldButton.setSelected(this.bold.get());
        buttonPanel.add(boldButton);
        VerticalPanel fontPropertiesPanel = new VerticalPanel();
        fontPropertiesPanel.addRow((JComponent)sizeLabel, (JComponent)sizeField);
        fontPropertiesPanel.addRow(this.resources.getMessage("nu.zoom.catonine.fontchooser.setting.fontprops"), (JComponent)buttonPanel);
        final JSplitPane fontSpecificationSplitter = new JSplitPane(1, fontNameScroller, (Component)fontPropertiesPanel);
        final JSplitPane mainSplitter = new JSplitPane(0, fontSpecificationSplitter, samplePanel);
        this.setLayout(new BorderLayout());
        this.add((Component)mainSplitter, "Center");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                fontSpecificationSplitter.setDividerLocation(0.5);
                mainSplitter.setDividerLocation(0.8);
            }
        });
    }

    public boolean isChanged() {
        return this.changed.get();
    }

    public void resetChangeStatus() {
        this.changed.set(false);
    }

    public Font getCurrentFontValues() {
        return this.font;
    }

    public void updateFont() {
        if (this.currentFontItem != null && !this.currentFontItem.synthetic) {
            HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>();
            attributes.put(TextAttribute.FAMILY, this.currentFontItem.fontName);
            attributes.put(TextAttribute.SIZE, this.fontSize);
            attributes.put(TextAttribute.WEIGHT, this.bold.get() ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
            attributes.put(TextAttribute.POSTURE, this.italic.get() ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
            this.font = Font.getFont(attributes);
        } else {
            this.font = this.defaultFont;
        }
        this.owner.fireFontChanged(this.font);
    }

    static class FontListItem {
        static final String SYNTHETIC_DEFAULT = "<default>";
        final String fontName;
        final boolean synthetic;

        public FontListItem(String fontName, boolean synthetic) {
            this.fontName = fontName;
            this.synthetic = synthetic;
        }

        public String toString() {
            return this.fontName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fontName == null ? 0 : this.fontName.hashCode());
            result = 31 * result + (this.synthetic ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FontListItem other = (FontListItem)obj;
            if (this.fontName == null ? other.fontName != null : !this.fontName.equals(other.fontName)) {
                return false;
            }
            return this.synthetic == other.synthetic;
        }
    }

    class BoldAction
    extends AbstractTypedAction {
        private static final long serialVersionUID = 2393393299735051962L;

        public BoldAction(Resources resources) throws Resources.ResourceNotFoundException {
            this.setName(resources.getMessage("nu.zoom.catonine.fontchooser.setting.bold"));
            this.setToolTip(resources.getMessage("nu.zoom.catonine.fontchooser.setting.bold.tt"));
            this.setIcon(resources.getIcon("nu.zoom.catonine.fontchooser.setting.bold.icon"));
        }

        public void actionPerformed(ActionEvent e) {
            FontChooserPanel.this.bold.set(!FontChooserPanel.this.bold.get());
            FontChooserPanel.this.changed.set(true);
            FontChooserPanel.this.updateFont();
        }
    }

    class ItalicAction
    extends AbstractTypedAction {
        private static final long serialVersionUID = 2393393299735051962L;

        public ItalicAction(Resources resources) throws Resources.ResourceNotFoundException {
            this.setName(resources.getMessage("nu.zoom.catonine.fontchooser.setting.italic"));
            this.setToolTip(resources.getMessage("nu.zoom.catonine.fontchooser.setting.italic.tt"));
            this.setIcon(resources.getIcon("nu.zoom.catonine.fontchooser.setting.italic.icon"));
        }

        public void actionPerformed(ActionEvent e) {
            FontChooserPanel.this.italic.set(!FontChooserPanel.this.italic.get());
            FontChooserPanel.this.changed.set(true);
            FontChooserPanel.this.updateFont();
        }
    }

    public static class SamplePanel
    extends JPanel
    implements FontChooser.FontValuesListener {
        private static final long serialVersionUID = 233180331110372656L;
        final JTextPane sampleText = new JTextPane();

        public SamplePanel() {
            super(new BorderLayout());
            this.sampleText.setText("1234-56-78,90: Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed tellus enim, pulvinar vehicula porta a, bibendum at metus. ");
            this.add((Component)this.sampleText, "Center");
        }

        @Override
        public void fontValuesChanged(FontChooser source, Font font) {
            this.sampleText.setFont(font);
        }
    }
}

