/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.catonine.fontchooser.impl;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import nu.zoom.catonine.fontchooser.FontChooser;
import nu.zoom.catonine.fontchooser.impl.FontChooserPanel;
import nu.zoom.ui.Resources;

public final class FontChooserImpl
implements FontChooser {
    private static final long serialVersionUID = 7797903502133711247L;
    private final Resources resources;
    private FontChooserPanel gui = null;
    private ArrayList<FontChooser.FontValuesListener> listeners = new ArrayList();

    public FontChooserImpl(Resources resources) {
        this.resources = resources;
    }

    public boolean isChanged() {
        if (this.gui == null) {
            return false;
        }
        return this.gui.isChanged();
    }

    public void resetChangeStatus() {
        if (this.gui != null) {
            this.gui.resetChangeStatus();
        }
    }

    @Override
    public synchronized void addFontValuesListener(FontChooser.FontValuesListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized void removeFontValuesListener(FontChooser.FontValuesListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Font getCurrentFontValues() {
        return this.gui == null ? null : this.gui.getCurrentFontValues();
    }

    @Override
    public JComponent getFontChooserGUI(Font startFont, Font defaultFont) throws Resources.ResourceNotFoundException {
        if (this.gui == null) {
            this.buildGUI(startFont, defaultFont);
        }
        return this.gui;
    }

    private void buildGUI(Font startFont, Font defaultFont) throws Resources.ResourceNotFoundException {
        this.gui = new FontChooserPanel(this.resources, this, startFont, defaultFont);
        this.gui.initGUI();
    }

    private synchronized List<FontChooser.FontValuesListener> copyListeners() {
        ArrayList<FontChooser.FontValuesListener> copy = new ArrayList<FontChooser.FontValuesListener>(this.listeners);
        return copy;
    }

    void fireFontChanged(Font font) {
        List<FontChooser.FontValuesListener> copyListeners = this.copyListeners();
        for (FontChooser.FontValuesListener fontValuesListener : copyListeners) {
            fontValuesListener.fontValuesChanged(this, font);
        }
    }
}

