/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

@Deprecated
public class UniqueIDGenerator {
    private SecureRandom randomGenerator = null;

    public String getID() {
        StringBuilder idBuffer = new StringBuilder();
        idBuffer.append(this.getRandomComponent());
        idBuffer.append(this.getJVMIdentityComponent());
        idBuffer.append(this.getNetworkComponent());
        idBuffer.append(this.getTimeComponent());
        return idBuffer.toString();
    }

    private String getTimeComponent() {
        long now = System.currentTimeMillis();
        return this.forceTo8Chars(Long.toHexString(now));
    }

    private String getNetworkComponent() {
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            byte[] rawArray = localAddress.getAddress();
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(rawArray));
            int rawAddress = in.readInt();
            return this.forceTo8Chars(Integer.toHexString(rawAddress));
        }
        catch (Exception ex) {
            return "00000000";
        }
    }

    private String getJVMIdentityComponent() {
        String identityString = Integer.toHexString(System.identityHashCode(this));
        return this.forceTo8Chars(identityString);
    }

    private String getRandomComponent() {
        if (this.randomGenerator == null) {
            try {
                this.randomGenerator = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException ex) {
                this.randomGenerator = null;
            }
        }
        int randomNumber = this.randomGenerator == null ? (int)Math.random() : this.randomGenerator.nextInt();
        return this.forceTo8Chars(Integer.toHexString(randomNumber));
    }

    private String forceTo8Chars(String value) {
        String newValue = value;
        if (newValue.length() > 8) {
            newValue = newValue.substring(newValue.length() - 8);
        }
        if (newValue.length() < 8) {
            newValue = this.pad(newValue, 8);
        }
        return newValue;
    }

    private String pad(String valueToPad, int lengthOfResult) {
        StringBuilder result = new StringBuilder();
        for (int n = lengthOfResult - valueToPad.length(); n > 0; --n) {
            result.append("0");
        }
        result.append(valueToPad);
        return result.toString();
    }

    public static void main(String[] args) {
        UniqueIDGenerator uniqueIDGenerator = new UniqueIDGenerator();
        long startTime = System.currentTimeMillis();
        for (int n = 0; n < 1000; ++n) {
            uniqueIDGenerator.getID();
        }
        long time = System.currentTimeMillis() - startTime;
        System.out.println("1000 GUIDS generated in " + time + " ms");
        System.out.println("Avarage " + time / 1000L + " ms / GUID");
    }
}

