/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.management.destination;

import javax.jms.JMSException;
import net.timewalker.ffmq4.management.InvalidDescriptorException;
import net.timewalker.ffmq4.utils.Checkable;

public final class DestinationReferenceDescriptor
implements Checkable {
    private String destinationType;
    private String destinationName;

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    @Override
    public void check() throws JMSException {
        if (this.destinationType == null) {
            throw new InvalidDescriptorException("Missing destination reference property : 'destinationType'");
        }
        if (!this.destinationType.equals("queue") && !this.destinationType.equals("topic")) {
            throw new InvalidDescriptorException("Destination reference property 'destinationType' should be one of : queue, topic");
        }
        if (this.destinationName == null) {
            throw new InvalidDescriptorException("Missing destination reference property : 'destinationName'");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("destinationType=");
        sb.append(this.destinationType);
        sb.append(" destinationName=");
        sb.append(this.destinationName);
        return sb.toString();
    }
}

