/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message.selector.expression.utils;

public final class ArithmeticUtils {
    public static Number sum(Number n1, Number n2) {
        Class<?> type = ArithmeticUtils.getComputationType(n1, n2);
        Number val1 = ArithmeticUtils.convertTo(n1, type);
        Number val2 = ArithmeticUtils.convertTo(n2, type);
        if (type == Long.class) {
            return val1.longValue() + val2.longValue();
        }
        return new Double(val1.doubleValue() + val2.doubleValue());
    }

    public static Number substract(Number n1, Number n2) {
        Class<?> type = ArithmeticUtils.getComputationType(n1, n2);
        Number val1 = ArithmeticUtils.convertTo(n1, type);
        Number val2 = ArithmeticUtils.convertTo(n2, type);
        if (type == Long.class) {
            return val1.longValue() - val2.longValue();
        }
        return new Double(val1.doubleValue() - val2.doubleValue());
    }

    public static Number multiply(Number n1, Number n2) {
        Class<?> type = ArithmeticUtils.getComputationType(n1, n2);
        Number val1 = ArithmeticUtils.convertTo(n1, type);
        Number val2 = ArithmeticUtils.convertTo(n2, type);
        if (type == Long.class) {
            return val1.longValue() * val2.longValue();
        }
        return new Double(val1.doubleValue() * val2.doubleValue());
    }

    public static Number divide(Number n1, Number n2) {
        Class<?> type = ArithmeticUtils.getComputationType(n1, n2);
        Number val1 = ArithmeticUtils.convertTo(n1, type);
        Number val2 = ArithmeticUtils.convertTo(n2, type);
        if (type == Long.class) {
            if (val2.longValue() == 0L) {
                return null;
            }
            return val1.longValue() / val2.longValue();
        }
        if (val2.doubleValue() == 0.0) {
            return null;
        }
        return new Double(val1.doubleValue() / val2.doubleValue());
    }

    public static Number minus(Number n) {
        Number value = ArithmeticUtils.normalize(n);
        Class<?> type = value.getClass();
        if (type == Long.class) {
            return -n.longValue();
        }
        return new Double(-n.doubleValue());
    }

    public static Boolean greaterThan(Number n1, Number n2) {
        Class<?> type = ArithmeticUtils.getComputationType(n1, n2);
        Number val1 = ArithmeticUtils.convertTo(n1, type);
        Number val2 = ArithmeticUtils.convertTo(n2, type);
        if (type == Long.class) {
            return val1.longValue() > val2.longValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        return val1.doubleValue() > val2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Boolean greaterThanOrEquals(Number n1, Number n2) {
        Class<?> type = ArithmeticUtils.getComputationType(n1, n2);
        Number val1 = ArithmeticUtils.convertTo(n1, type);
        Number val2 = ArithmeticUtils.convertTo(n2, type);
        if (type == Long.class) {
            return val1.longValue() >= val2.longValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        return val1.doubleValue() >= val2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Boolean lessThan(Number n1, Number n2) {
        Class<?> type = ArithmeticUtils.getComputationType(n1, n2);
        Number val1 = ArithmeticUtils.convertTo(n1, type);
        Number val2 = ArithmeticUtils.convertTo(n2, type);
        if (type == Long.class) {
            return val1.longValue() < val2.longValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        return val1.doubleValue() < val2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Boolean lessThanOrEquals(Number n1, Number n2) {
        Class<?> type = ArithmeticUtils.getComputationType(n1, n2);
        Number val1 = ArithmeticUtils.convertTo(n1, type);
        Number val2 = ArithmeticUtils.convertTo(n2, type);
        if (type == Long.class) {
            return val1.longValue() <= val2.longValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        return val1.doubleValue() <= val2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Boolean equals(Number n1, Number n2) {
        Class<?> type = ArithmeticUtils.getComputationType(n1, n2);
        Number val1 = ArithmeticUtils.convertTo(n1, type);
        Number val2 = ArithmeticUtils.convertTo(n2, type);
        if (type == Long.class) {
            return val1.longValue() == val2.longValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        return val1.doubleValue() == val2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
    }

    private static Number convertTo(Number n, Class<?> type) {
        Class<?> baseType = n.getClass();
        if (baseType == type) {
            return n;
        }
        if (type == Long.class) {
            return n.longValue();
        }
        return new Double(n.doubleValue());
    }

    public static Number normalize(Number value) {
        Class<?> type = value.getClass();
        if (type == Long.class || type == Double.class) {
            return value;
        }
        if (ArithmeticUtils.isIntegerType(type)) {
            return value.longValue();
        }
        return new Double(value.doubleValue());
    }

    private static boolean isIntegerType(Class<?> type) {
        return type == Byte.class || type == Short.class || type == Integer.class || type == Long.class;
    }

    private static Class<?> getComputationType(Number n1, Number n2) {
        Class<?> type1 = n1.getClass();
        Class<?> type2 = n2.getClass();
        if (ArithmeticUtils.isIntegerType(type1) && ArithmeticUtils.isIntegerType(type2)) {
            return Long.class;
        }
        return Double.class;
    }
}

