/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Predicate;
import net.thucydides.core.annotations.locators.SmartElementProxyCreator;
import net.thucydides.core.pages.PageObject;
import net.thucydides.core.webdriver.ElementProxyCreator;
import org.openqa.selenium.WebDriver;

public class DefaultPageObjectInitialiser
implements Predicate<PageObject> {
    private final WebDriver driver;
    private final int ajaxTimeoutInMilliseconds;
    private final ElementProxyCreator elementProxyCreator;

    public DefaultPageObjectInitialiser(WebDriver driver, int ajaxTimeoutInMilliseconds) {
        this.driver = driver;
        this.ajaxTimeoutInMilliseconds = ajaxTimeoutInMilliseconds;
        this.elementProxyCreator = new SmartElementProxyCreator();
    }

    protected int ajaxTimeoutInSecondsWithAtLeast1Second() {
        if (this.ajaxTimeoutInMilliseconds > 1000) {
            return this.ajaxTimeoutInMilliseconds / 1000;
        }
        return 1;
    }

    public boolean apply(PageObject page) {
        page.setWaitForTimeout(this.ajaxTimeoutInMilliseconds);
        this.elementProxyCreator.proxyElements(page, this.driver, this.ajaxTimeoutInSecondsWithAtLeast1Second());
        return true;
    }
}

