/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestType;
import net.thucydides.core.reports.TestOutcomes;

public class RequirementsProportionCounter {
    private final TestType testType;
    private final TestOutcomes testOutcomes;
    private final int estimatedTotalTests;

    public RequirementsProportionCounter(TestType testType, TestOutcomes testOutcomes, int estimatedTotalTests) {
        this.testType = testType;
        this.testOutcomes = testOutcomes;
        this.estimatedTotalTests = estimatedTotalTests;
    }

    public Double withResult(String expectedResult) {
        return this.withResult(TestResult.valueOf(expectedResult.toUpperCase()));
    }

    public Double withResult(TestResult expectedTestResult) {
        int testCount = this.testOutcomes.count(this.testType).withResult(expectedTestResult);
        return (double)testCount / (double)this.estimatedTotalTests;
    }

    public Double withIndeterminateResult() {
        int passingStepCount = this.testOutcomes.count(this.testType).withResult(TestResult.SUCCESS);
        int failingStepCount = this.testOutcomes.count(this.testType).withResult(TestResult.FAILURE);
        int errorStepCount = this.testOutcomes.count(this.testType).withResult(TestResult.ERROR);
        int total = this.estimatedTotalTests;
        return (double)(total - passingStepCount - failingStepCount - errorStepCount) / (double)total;
    }
}

