/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.matchers;

import ch.lambdaj.Lambda;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class TestOutcomeMatchers {
    public static Matcher<TestOutcome> havingTagType(final String tagType) {
        return new BaseMatcher<TestOutcome>(){

            public boolean matches(Object matchee) {
                TestOutcome testOutcome = (TestOutcome)matchee;
                return Lambda.exists(testOutcome.getTags(), (Matcher)Lambda.having((Object)((TestTag)Lambda.on(TestTag.class)).getType(), (Matcher)Matchers.is((Object)tagType)));
            }

            public void describeTo(Description description) {
                description.appendText("a test outcome with a tag of type ").appendValue((Object)tagType);
            }
        };
    }

    public static Matcher<TestOutcome> havingTagName(final String tagName) {
        return new BaseMatcher<TestOutcome>(){

            public boolean matches(Object matchee) {
                TestOutcome testOutcome = (TestOutcome)matchee;
                return Lambda.exists(testOutcome.getTags(), (Matcher)Lambda.having((Object)((TestTag)Lambda.on(TestTag.class)).getName(), (Matcher)Matchers.equalToIgnoringCase((String)tagName)));
            }

            public void describeTo(Description description) {
                description.appendText("a test outcome with a tag ").appendValue((Object)tagName);
            }
        };
    }

    public static Matcher<TestOutcome> havingTag(final TestTag expectedTag) {
        return new BaseMatcher<TestOutcome>(){

            public boolean matches(Object matchee) {
                TestOutcome testOutcome = (TestOutcome)matchee;
                return Lambda.exists(testOutcome.getTags(), (Matcher)Lambda.having((Object)Lambda.on(TestTag.class), (Matcher)Matchers.is((Object)expectedTag)));
            }

            public void describeTo(Description description) {
                description.appendText("a test outcome with a tag ").appendValue((Object)expectedTag);
            }
        };
    }

    public static Matcher<TestOutcome> withResult(TestResult expectedResult) {
        return Lambda.having((Object)((Object)((TestOutcome)Lambda.on(TestOutcome.class)).getResult()), (Matcher)Matchers.is((Object)((Object)expectedResult)));
    }
}

