/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;

public class DataTableRow {
    private final List cellValues;
    private TestResult result;

    public DataTableRow(List cellValues) {
        this.cellValues = ImmutableList.copyOf((Collection)cellValues);
        this.result = TestResult.UNDEFINED;
    }

    public List getValues() {
        return ImmutableList.copyOf((Collection)this.cellValues);
    }

    public List<String> getStringValues() {
        return Lists.transform((List)this.cellValues, (Function)new Function<Object, String>(){

            public String apply(Object o) {
                return o == null ? "" : o.toString();
            }
        });
    }

    public TestResult getResult() {
        return this.result;
    }

    public void setResult(TestResult result) {
        this.result = result;
    }

    public void updateResult(TestResult newResult) {
        if (newResult == TestResult.UNDEFINED) {
            this.setResult(newResult);
        } else {
            TestResultList testResults = TestResultList.of(this.result, newResult);
            this.setResult(testResults.getOverallResult());
        }
    }
}

