/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import net.sourceforge.retroweaver.runtime.java.lang.Appendable;
import net.sourceforge.retroweaver.runtime.java.util.FormatterClosedException;
import net.sourceforge.retroweaver.runtime.java.util.IllegalFormatException;

public class Formatter {
    private Appendable buffer;
    private Method appendMethod;
    private Locale locale;
    private boolean closed;
    private IOException ioe;
    private static final /* synthetic */ Class class$java$lang$String;

    public Formatter() {
        this((Appendable)((Object)new StringBuffer()), Locale.getDefault());
    }

    public Formatter(Appendable a) {
        this(a, Locale.getDefault());
    }

    public Formatter(Locale l) {
        this((Appendable)((Object)new StringBuffer()), l);
    }

    public Formatter(Appendable a, Locale l) {
        this.buffer = a == null ? new StringBuffer() : a;
        try {
            Class<?> clazz = this.buffer.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            classArray[0] = clazz2;
            this.appendMethod = clazz.getMethod("append", classArray);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.locale = l;
    }

    public Locale locale() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        return this.locale;
    }

    public Appendable out() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        return this.buffer;
    }

    public String toString() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        return this.buffer.toString();
    }

    public void flush() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        try {
            Method m = this.buffer.getClass().getMethod("flush", new Class[0]);
            m.invoke((Object)this.buffer, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                Method m = this.buffer.getClass().getMethod("close", new Class[0]);
                m.invoke((Object)this.buffer, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public IOException ioException() {
        return this.ioe;
    }

    public Formatter format(String format, Object ... args) throws IllegalFormatException, FormatterClosedException {
        return this.format(this.locale, format, args);
    }

    public Formatter format(Locale l, String format, Object ... args) throws IllegalFormatException, FormatterClosedException {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        int start = 0;
        int argIndex = 0;
        block7: while (true) {
            try {
                while (true) {
                    int end;
                    if ((end = format.indexOf(37, start)) == -1) {
                        this.append(format.substring(start, format.length()));
                        break block7;
                    }
                    this.append(format.substring(start, end));
                    if (end == format.length()) {
                        throw new IllegalFormatException();
                    }
                    char c = format.charAt(end + 1);
                    switch (c) {
                        case '%': {
                            this.append("%");
                            break;
                        }
                        case 's': {
                            Object o = args[argIndex++];
                            this.append(o == null ? null : o.toString());
                            break;
                        }
                        case 'd': {
                            Object o = args[argIndex++];
                            this.append(o.toString());
                            break;
                        }
                        default: {
                            throw new IllegalFormatException();
                        }
                    }
                    start = end + 2;
                }
            }
            catch (IOException ioe) {
                this.ioe = ioe;
                continue;
            }
            break;
        }
        return this;
    }

    private void append(String s) throws IOException {
        try {
            this.appendMethod.invoke((Object)this.buffer, s);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof IOException) {
                throw (IOException)ite.getCause();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

