/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.OptimisedListTranslator;
import org.coode.owlapi.rdfxml.parser.SWRLAtomListItemTranslator;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.vocab.SWRLVocabulary;

public class SWRLRuleTranslator {
    private OWLRDFConsumer consumer;
    private OptimisedListTranslator<SWRLAtom> listTranslator;

    public SWRLRuleTranslator(OWLRDFConsumer consumer) {
        this.consumer = consumer;
        this.listTranslator = new OptimisedListTranslator<SWRLAtom>(consumer, new SWRLAtomListItemTranslator(consumer));
    }

    public void translateRule(IRI mainNode) {
        HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
        Set<IRI> predicates = this.consumer.getPredicatesBySubject(mainNode);
        for (IRI i : predicates) {
            if (!this.consumer.isAnnotationProperty(i)) continue;
            OWLAnnotationProperty p = this.consumer.getDataFactory().getOWLAnnotationProperty(i);
            OWLLiteral literal = this.consumer.getLiteralObject(mainNode, i, true);
            while (literal != null) {
                annotations.add(this.consumer.getDataFactory().getOWLAnnotation(p, (OWLAnnotationValue)literal));
                literal = this.consumer.getLiteralObject(mainNode, i, true);
            }
        }
        Set<Object> consequent = Collections.emptySet();
        IRI ruleHeadIRI = this.consumer.getResourceObject(mainNode, SWRLVocabulary.HEAD.getIRI(), true);
        if (ruleHeadIRI != null) {
            consequent = this.listTranslator.translateToSet(ruleHeadIRI);
        }
        Set<Object> antecedent = Collections.emptySet();
        IRI ruleBodyIRI = this.consumer.getResourceObject(mainNode, SWRLVocabulary.BODY.getIRI(), true);
        if (ruleBodyIRI != null) {
            antecedent = this.listTranslator.translateToSet(ruleBodyIRI);
        }
        SWRLRule rule = null;
        rule = !this.consumer.isAnonymousNode(mainNode) ? this.consumer.getDataFactory().getSWRLRule(antecedent, consequent, annotations) : this.consumer.getDataFactory().getSWRLRule(antecedent, consequent, annotations);
        this.consumer.addAxiom((OWLAxiom)rule);
    }
}

