/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSetPattern
extends Pattern {
    protected Expression expression;
    protected ItemType itemType;

    public NodeSetPattern(Expression exp) {
        this.expression = exp;
    }

    @Override
    public Iterable<Operand> operands() {
        return new Operand(this, this.expression, OperandRole.NAVIGATE);
    }

    public Expression getSelectionExpression() {
        return this.expression;
    }

    @Override
    public Pattern typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.expression = this.expression.typeCheck(visitor, contextItemType);
        RoleDiagnostic role = new RoleDiagnostic(3, this.expression.toString(), 0);
        this.expression = TypeChecker.staticTypeCheck(this.expression, SequenceType.NODE_SEQUENCE, false, role, visitor);
        this.itemType = this.expression.getItemType();
        return this;
    }

    public void setItemType(ItemType type) {
        this.itemType = type;
    }

    @Override
    public int getDependencies() {
        return this.expression.getDependencies();
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator<Expression>(this.expression);
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        this.expression = this.expression.promote(offer);
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        return ExpressionTool.allocateSlots(this.expression, nextFree, slotManager);
    }

    @Override
    public SequenceIterator selectNodes(TreeInfo doc, XPathContext context) throws XPathException {
        XPathContextMinor c2 = context.newMinorContext();
        ManualIterator mi = new ManualIterator(doc.getRootNode());
        c2.setCurrentIterator(mi);
        return this.expression.iterate(c2);
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        if (item instanceof NodeInfo) {
            NodeInfo node;
            NodeInfo e = (NodeInfo)item;
            SequenceIterator iter = this.expression.iterate(context);
            do {
                if ((node = (NodeInfo)iter.next()) != null) continue;
                return false;
            } while (!node.isSameNodeInfo(e));
            return true;
        }
        return false;
    }

    @Override
    public UType getUType() {
        return this.itemType.getUType();
    }

    @Override
    public ItemType getItemType() {
        if (this.itemType instanceof NodeTest) {
            return (NodeTest)this.itemType;
        }
        return AnyNodeTest.getInstance();
    }

    public boolean equals(Object other) {
        return other instanceof NodeSetPattern && ((NodeSetPattern)other).expression.equals(this.expression);
    }

    public int hashCode() {
        return 0x73108728 ^ this.expression.hashCode();
    }

    @Override
    public Pattern copy() {
        NodeSetPattern n = new NodeSetPattern(this.expression.copy());
        ExpressionTool.copyLocationInfo(this, n);
        return n;
    }

    @Override
    public void export(ExpressionPresenter presenter) {
        presenter.startElement("p.nodeSet");
        if (this.itemType != null) {
            presenter.emitAttribute("type", this.itemType.toString());
        }
        this.expression.export(presenter);
        presenter.endElement();
    }
}

