/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PseudoExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.DescendingComparer;
import net.sf.saxon.expr.sort.EmptyGreatestComparer;
import net.sf.saxon.expr.sort.NumericComparer;
import net.sf.saxon.expr.sort.NumericComparer11;
import net.sf.saxon.expr.sort.TextComparer;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortKeyDefinition
extends PseudoExpression {
    protected Expression sortKey;
    protected Expression order = new StringLiteral("ascending");
    protected Expression dataTypeExpression = null;
    protected Expression caseOrder = new StringLiteral("#default");
    protected Expression language = new StringLiteral(StringValue.EMPTY_STRING);
    protected Expression collationName = null;
    protected Expression stable = null;
    protected StringCollator collation;
    protected String baseURI;
    protected boolean emptyLeast = true;
    protected boolean backwardsCompatible = false;
    protected boolean setContextForSortKey = false;
    private transient AtomicComparer finalComparator = null;

    public void setSortKey(Expression exp, boolean setContext) {
        this.sortKey = exp;
        this.setContextForSortKey = setContext;
        this.adoptChildExpression(this.sortKey);
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public boolean isSetContextForSortKey() {
        return this.setContextForSortKey;
    }

    public void setOrder(Expression exp) {
        this.order = exp;
        this.adoptChildExpression(exp);
    }

    public Expression getOrder() {
        return this.order;
    }

    public void setDataTypeExpression(Expression exp) {
        this.dataTypeExpression = exp;
        this.adoptChildExpression(exp);
    }

    public Expression getDataTypeExpression() {
        return this.dataTypeExpression;
    }

    public void setCaseOrder(Expression exp) {
        this.caseOrder = exp;
        this.adoptChildExpression(exp);
    }

    public Expression getCaseOrder() {
        return this.caseOrder;
    }

    public void setLanguage(Expression exp) {
        this.language = exp;
        this.adoptChildExpression(exp);
    }

    public Expression getLanguage() {
        return this.language;
    }

    public void setCollationNameExpression(Expression collationName) {
        this.collationName = collationName;
        this.adoptChildExpression(collationName);
    }

    public Expression getCollationNameExpression() {
        return this.collationName;
    }

    public void setCollation(StringCollator collation) {
        this.collation = collation;
    }

    public StringCollator getCollation() {
        return this.collation;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setStable(Expression stable) {
        this.stable = stable;
    }

    public Expression getStable() {
        return this.stable;
    }

    public void setBackwardsCompatible(boolean compatible) {
        this.backwardsCompatible = compatible;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }

    public void setEmptyLeast(boolean emptyLeast) {
        this.emptyLeast = emptyLeast;
    }

    public boolean getEmptyLeast() {
        return this.emptyLeast;
    }

    public boolean isFixed() {
        return !(!(this.order instanceof Literal) || this.dataTypeExpression != null && !(this.dataTypeExpression instanceof Literal) || !(this.caseOrder instanceof Literal) || !(this.language instanceof Literal) || this.stable != null && !(this.stable instanceof Literal) || this.collationName != null && !(this.collationName instanceof Literal));
    }

    @Override
    public SortKeyDefinition simplify() throws XPathException {
        this.sortKey = this.sortKey.simplify();
        this.order = this.order.simplify();
        if (this.dataTypeExpression != null) {
            this.dataTypeExpression = this.dataTypeExpression.simplify();
        }
        this.caseOrder = this.caseOrder.simplify();
        this.language = this.language.simplify();
        if (this.stable != null) {
            this.stable = this.stable.simplify();
        }
        if (this.collationName != null) {
            this.collationName = this.collationName.simplify();
        }
        return this;
    }

    @Override
    public SortKeyDefinition copy() {
        SortKeyDefinition sk2 = new SortKeyDefinition();
        sk2.setSortKey(this.copy(this.sortKey), true);
        sk2.setOrder(this.copy(this.order));
        sk2.setDataTypeExpression(this.copy(this.dataTypeExpression));
        sk2.setCaseOrder(this.copy(this.caseOrder));
        sk2.setLanguage(this.copy(this.language));
        sk2.setStable(this.copy(this.stable));
        sk2.setCollationNameExpression(this.copy(this.collationName));
        sk2.collation = this.collation;
        sk2.emptyLeast = this.emptyLeast;
        sk2.baseURI = this.baseURI;
        sk2.backwardsCompatible = this.backwardsCompatible;
        sk2.finalComparator = this.finalComparator;
        sk2.setContextForSortKey = this.setContextForSortKey;
        return sk2;
    }

    private Expression copy(Expression in) {
        return in == null ? null : in.copy();
    }

    @Override
    public SortKeyDefinition typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        ValidationFailure vf;
        this.order = this.order.typeCheck(visitor, contextItemType);
        if (this.dataTypeExpression != null) {
            this.setDataTypeExpression(this.dataTypeExpression.typeCheck(visitor, contextItemType));
        }
        if (this.caseOrder != null) {
            this.setCaseOrder(this.caseOrder.typeCheck(visitor, contextItemType));
        }
        if (this.language != null) {
            this.setLanguage(this.language.typeCheck(visitor, contextItemType));
        }
        if (this.stable != null) {
            this.setStable(this.stable.typeCheck(visitor, contextItemType));
        }
        if (this.collationName != null) {
            this.setCollationNameExpression(this.collationName.typeCheck(visitor, contextItemType));
        }
        if (!this.setContextForSortKey) {
            this.setSortKey(this.sortKey.typeCheck(visitor, contextItemType), false);
        }
        if (this.language instanceof StringLiteral && ((StringLiteral)this.language).getStringValue().length() != 0 && (vf = StringConverter.STRING_TO_LANGUAGE.validate(((StringLiteral)this.language).getStringValue())) != null) {
            throw new XPathException("The lang attribute of xsl:sort must be a valid language code", "XTDE0030");
        }
        return this;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>(8);
        list.add(new Operand(this, this.sortKey, OperandRole.FOCUS_CONTROLLED_ACTION));
        list.add(new Operand(this, this.order, OperandRole.SINGLE_ATOMIC));
        if (this.dataTypeExpression != null) {
            list.add(new Operand(this, this.dataTypeExpression, OperandRole.SINGLE_ATOMIC));
        }
        if (this.caseOrder != null) {
            list.add(new Operand(this, this.caseOrder, OperandRole.SINGLE_ATOMIC));
        }
        if (this.language != null) {
            list.add(new Operand(this, this.language, OperandRole.SINGLE_ATOMIC));
        }
        if (this.stable != null) {
            list.add(new Operand(this, this.stable, OperandRole.SINGLE_ATOMIC));
        }
        if (this.collationName != null) {
            list.add(new Operand(this, this.collationName, OperandRole.SINGLE_ATOMIC));
        }
        return list;
    }

    @Override
    public int getImplementationMethod() {
        return 0;
    }

    public AtomicComparer makeComparator(XPathContext context) throws XPathException {
        StringValue stableVal;
        String s;
        AtomicComparer atomicComparer;
        StringCollator stringCollator;
        String orderX = this.order.evaluateAsString(context).toString();
        Configuration config = context.getConfiguration();
        if (this.collation != null) {
            stringCollator = this.collation;
        } else if (this.collationName != null) {
            URI collationURI;
            String cname = this.collationName.evaluateAsString(context).toString();
            try {
                collationURI = new URI(cname);
                if (!collationURI.isAbsolute()) {
                    if (this.baseURI == null) {
                        throw new XPathException("Collation URI is relative, and base URI is unknown");
                    }
                    URI base = new URI(this.baseURI);
                    collationURI = base.resolve(collationURI);
                }
            }
            catch (URISyntaxException err) {
                throw new XPathException("Collation name " + cname + " is not a valid URI: " + err);
            }
            stringCollator = context.getConfiguration().getCollation(collationURI.toString());
            if (stringCollator == null) {
                throw new XPathException("Unknown collation " + collationURI, "XTDE1035");
            }
        } else {
            String caseOrderX = this.caseOrder.evaluateAsString(context).toString();
            String languageX = this.language.evaluateAsString(context).toString();
            String uri = "http://saxon.sf.net/collation";
            boolean firstParam = true;
            Properties props = new Properties();
            if (languageX.length() != 0) {
                ValidationFailure vf = StringConverter.STRING_TO_LANGUAGE.validate(languageX);
                if (vf != null) {
                    throw new XPathException("The lang attribute of xsl:sort must be a valid language code", "XTDE0030");
                }
                props.setProperty("lang", languageX);
                uri = uri + (firstParam ? "?" : ";") + "lang=" + languageX;
                firstParam = false;
            }
            if (!caseOrderX.equals("#default")) {
                props.setProperty("case-order", caseOrderX);
                uri = uri + (firstParam ? "?" : ";") + "case-order=" + caseOrderX;
                firstParam = false;
            }
            stringCollator = Version.platform.makeCollation(config, props, uri);
        }
        if (this.dataTypeExpression == null) {
            atomicComparer = AtomicSortComparer.makeSortComparer(stringCollator, this.sortKey.getItemType().getAtomizedItemType().getPrimitiveType(), context);
            if (!this.emptyLeast) {
                atomicComparer = new EmptyGreatestComparer(atomicComparer);
            }
        } else {
            String dataType = this.dataTypeExpression.evaluateAsString(context).toString();
            if (dataType.equals("text")) {
                atomicComparer = AtomicSortComparer.makeSortComparer(stringCollator, 513, context);
                atomicComparer = new TextComparer(atomicComparer);
            } else if (dataType.equals("number")) {
                atomicComparer = context.getConfiguration().getXsdVersion() == 10 ? NumericComparer.getInstance() : NumericComparer11.getInstance();
            } else {
                XPathException err = new XPathException("data-type on xsl:sort must be 'text' or 'number'");
                err.setErrorCode("XTDE0030");
                throw err;
            }
        }
        if (!(this.stable == null || (s = Whitespace.trim((stableVal = (StringValue)this.stable.evaluateItem(context)).getStringValue())).equals("yes") || s.equals("no") || s.equals("true") || s.equals("false") || s.equals("1") || s.equals("0"))) {
            XPathException err = new XPathException("Value of 'stable' on xsl:sort must be yes|no|true|false|1|0");
            err.setErrorCode("XTDE0030");
            throw err;
        }
        if (orderX.equals("ascending")) {
            return atomicComparer;
        }
        if (orderX.equals("descending")) {
            return new DescendingComparer(atomicComparer);
        }
        XPathException err1 = new XPathException("order must be 'ascending' or 'descending'");
        err1.setErrorCode("XTDE0030");
        throw err1;
    }

    public void setFinalComparator(AtomicComparer comp) {
        this.finalComparator = comp;
    }

    public AtomicComparer getFinalComparator() {
        return this.finalComparator;
    }

    public SortKeyDefinition fix(XPathContext context) throws XPathException {
        SortKeyDefinition newSKD = this.copy();
        newSKD.setLanguage(new StringLiteral(this.getLanguage().evaluateAsString(context)));
        newSKD.setOrder(new StringLiteral(this.getOrder().evaluateAsString(context)));
        if (this.collationName != null) {
            newSKD.setCollationNameExpression(new StringLiteral(this.getCollationNameExpression().evaluateAsString(context)));
        }
        newSKD.setCaseOrder(new StringLiteral(this.getCaseOrder().evaluateAsString(context)));
        if (this.dataTypeExpression != null) {
            newSKD.setDataTypeExpression(new StringLiteral(this.getDataTypeExpression().evaluateAsString(context)));
        }
        newSKD.setSortKey(new ContextItemExpression(), true);
        return newSKD;
    }

    public boolean equals(Object other) {
        if (other instanceof SortKeyDefinition) {
            SortKeyDefinition skd2 = (SortKeyDefinition)other;
            return this.sortKey.hashCode() == skd2.getSortKey().hashCode() && this.hashCode() == skd2.hashCode();
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        h ^= this.order.hashCode();
        h ^= this.caseOrder.hashCode();
        h ^= this.language.hashCode();
        if (this.dataTypeExpression != null) {
            h ^= this.dataTypeExpression.hashCode();
        }
        if (this.stable != null) {
            h ^= this.stable.hashCode();
        }
        if (this.collationName != null) {
            h ^= this.collationName.hashCode();
        }
        return h;
    }

    @Override
    public void export(ExpressionPresenter out) {
        out.startElement("sortKey", this);
        if (this.finalComparator != null) {
            out.emitAttribute("comp", this.finalComparator.save());
        }
        out.setChildRole("select");
        this.sortKey.export(out);
        out.setChildRole("order");
        this.order.export(out);
        if (this.dataTypeExpression != null) {
            out.setChildRole("dataType");
            this.dataTypeExpression.export(out);
        }
        out.setChildRole("lang");
        this.language.export(out);
        out.setChildRole("caseOrder");
        this.caseOrder.export(out);
        if (this.stable != null) {
            out.setChildRole("stable");
            this.stable.export(out);
        }
        if (this.collationName != null) {
            out.setChildRole("collation");
            this.collationName.export(out);
        }
        out.endElement();
    }
}

