/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.tree.wrapper.VirtualUntypedCopy;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOf
extends Instruction
implements ValidatingInstruction {
    private Operand selectOp;
    private boolean copyNamespaces;
    private boolean copyAccumulators;
    private int validation;
    private SchemaType schemaType;
    private boolean requireDocumentOrElement = false;
    private boolean rejectDuplicateAttributes;
    private boolean readOnce = false;
    private boolean validating;
    private boolean copyLineNumbers = true;
    private boolean copyForUpdate = false;
    private boolean isSchemaAware = true;

    public CopyOf(Expression select, boolean copyNamespaces, int validation, SchemaType schemaType, boolean rejectDuplicateAttributes) {
        this.selectOp = new Operand(this, select, OperandRole.SINGLE_ATOMIC);
        this.copyNamespaces = copyNamespaces;
        this.validation = validation;
        this.schemaType = schemaType;
        this.validating = schemaType != null || validation != 3;
        this.rejectDuplicateAttributes = rejectDuplicateAttributes;
    }

    public Expression getSelect() {
        return this.selectOp.getChildExpression();
    }

    public void setSelect(Expression select) {
        this.selectOp.setChildExpression(select);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.selectOp;
    }

    @Override
    public int getValidationAction() {
        return this.validation;
    }

    public boolean isValidating() {
        return this.validating;
    }

    @Override
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaAware(boolean schemaAware) {
        this.isSchemaAware = schemaAware;
    }

    public void setReadOnce(boolean b) {
        this.readOnce = b;
    }

    public void setCopyLineNumbers(boolean copy) {
        this.copyLineNumbers = copy;
    }

    @Override
    public final boolean createsNewNodes() {
        return !this.getSelect().getItemType().isPlainType();
    }

    @Override
    public int getInstructionNameCode() {
        return 146;
    }

    public void setRequireDocumentOrElement(boolean requireDocumentOrElement) {
        this.requireDocumentOrElement = requireDocumentOrElement;
    }

    public boolean isDocumentOrElementRequired() {
        return this.requireDocumentOrElement;
    }

    public void setCopyForUpdate(boolean forUpdate) {
        this.copyForUpdate = forUpdate;
    }

    public boolean isCopyForUpdate() {
        return this.copyForUpdate;
    }

    @Override
    public int getImplementationMethod() {
        return 14;
    }

    public boolean isCopyNamespaces() {
        return this.copyNamespaces;
    }

    public void setCopyAccumulators(boolean copy) {
        this.copyAccumulators = copy;
    }

    public boolean isCopyAccumulators() {
        return this.copyAccumulators;
    }

    @Override
    public Expression copy() {
        CopyOf c = new CopyOf(this.getSelect().copy(), this.copyNamespaces, this.validation, this.schemaType, this.rejectDuplicateAttributes);
        c.setCopyForUpdate(this.copyForUpdate);
        c.setCopyLineNumbers(this.copyLineNumbers);
        c.setReadOnce(this.readOnce);
        c.isSchemaAware = this.isSchemaAware;
        c.setCopyAccumulators(this.copyAccumulators);
        return c;
    }

    @Override
    public ItemType getItemType() {
        ItemType in = this.getSelect().getItemType();
        if (!this.isSchemaAware) {
            return in;
        }
        Configuration config = this.getConfiguration();
        if (this.schemaType != null) {
            TypeHierarchy th = config.getTypeHierarchy();
            int e = th.relationship(in, NodeKindTest.ELEMENT);
            if (e == 0 || e == 2) {
                return new ContentTypeTest(1, this.schemaType, config, false);
            }
            int a = th.relationship(in, NodeKindTest.ATTRIBUTE);
            if (a == 0 || a == 2) {
                return new ContentTypeTest(2, this.schemaType, config, false);
            }
        } else {
            switch (this.validation) {
                case 3: {
                    return in;
                }
                case 4: {
                    TypeHierarchy th = config.getTypeHierarchy();
                    int e = th.relationship(in, NodeKindTest.ELEMENT);
                    if (e == 0 || e == 2) {
                        return new ContentTypeTest(1, Untyped.getInstance(), config, false);
                    }
                    int a = th.relationship(in, NodeKindTest.ATTRIBUTE);
                    if (a == 0 || a == 2) {
                        return new ContentTypeTest(2, BuiltInAtomicType.UNTYPED_ATOMIC, config, false);
                    }
                    if (e != 4 || a != 4) {
                        return AnyNodeTest.getInstance();
                    }
                    return in;
                }
                case 1: 
                case 2: {
                    if (in instanceof NodeTest) {
                        TypeHierarchy th = config.getTypeHierarchy();
                        int fp = ((NodeTest)in).getFingerprint();
                        if (fp != -1) {
                            int e = th.relationship(in, NodeKindTest.ELEMENT);
                            if (e == 0 || e == 2) {
                                SchemaDeclaration elem = config.getElementDeclaration(fp);
                                if (elem != null) {
                                    try {
                                        return new ContentTypeTest(1, elem.getType(), config, false);
                                    }
                                    catch (MissingComponentException e1) {
                                        return new ContentTypeTest(1, AnyType.getInstance(), config, false);
                                    }
                                }
                                return new ContentTypeTest(1, AnyType.getInstance(), config, false);
                            }
                            int a = th.relationship(in, NodeKindTest.ATTRIBUTE);
                            if (a == 0 || a == 2) {
                                SchemaDeclaration attr = config.getElementDeclaration(fp);
                                if (attr != null) {
                                    try {
                                        return new ContentTypeTest(2, attr.getType(), config, false);
                                    }
                                    catch (MissingComponentException e1) {
                                        return new ContentTypeTest(2, AnySimpleType.getInstance(), config, false);
                                    }
                                }
                                return new ContentTypeTest(2, AnySimpleType.getInstance(), config, false);
                            }
                        } else {
                            int e = th.relationship(in, NodeKindTest.ELEMENT);
                            if (e == 0 || e == 2) {
                                return NodeKindTest.ELEMENT;
                            }
                            int a = th.relationship(in, NodeKindTest.ATTRIBUTE);
                            if (a == 0 || a == 2) {
                                return NodeKindTest.ATTRIBUTE;
                            }
                        }
                        return AnyNodeTest.getInstance();
                    }
                    if (in instanceof AtomicType) {
                        return in;
                    }
                    return AnyItemType.getInstance();
                }
            }
        }
        return this.getSelect().getItemType();
    }

    @Override
    public int getCardinality() {
        return this.getSelect().getCardinality();
    }

    @Override
    public int getDependencies() {
        return this.getSelect().getDependencies();
    }

    @Override
    protected void promoteChildren(PromotionOffer offer) throws XPathException {
        this.setSelect(this.doPromotion(this.getSelect(), offer));
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        if (this.isDocumentOrElementRequired()) {
            RoleDiagnostic role = new RoleDiagnostic(2, "validate", 0);
            role.setErrorCode("XQTY0030");
            this.setSelect(TypeChecker.staticTypeCheck(this.getSelect(), SequenceType.SINGLE_NODE, false, role, visitor));
            TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
            ItemType t = this.getSelect().getItemType();
            if (th.isSubType(t, NodeKindTest.ATTRIBUTE)) {
                throw new XPathException("validate{} expression cannot be applied to an attribute", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.TEXT)) {
                throw new XPathException("validate{} expression cannot be applied to a text node", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.COMMENT)) {
                throw new XPathException("validate{} expression cannot be applied to a comment node", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.PROCESSING_INSTRUCTION)) {
                throw new XPathException("validate{} expression cannot be applied to a processing instruction node", "XQTY0030");
            }
            if (th.isSubType(t, NodeKindTest.NAMESPACE)) {
                throw new XPathException("validate{} expression cannot be applied to a namespace node", "XQTY0030");
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if (this.readOnce) {
            Expression optcopy;
            if (!(this.getSelect() instanceof DocumentSorter) && (optcopy = this.getConfiguration().obtainOptimizer().optimizeCopy(visitor, contextItemType, this.getSelect())) != null) {
                optcopy = optcopy.typeCheck(visitor, contextItemType);
                ExpressionTool.copyLocationInfo(this, optcopy);
                return optcopy;
            }
            this.selectOp.optimize(visitor, contextItemType);
            optcopy = this.getConfiguration().obtainOptimizer().optimizeCopy(visitor, contextItemType, this.getSelect());
            if (optcopy != null) {
                ExpressionTool.copyLocationInfo(this, optcopy);
                return optcopy;
            }
        } else {
            this.selectOp.optimize(visitor, contextItemType);
        }
        if (Literal.isEmptySequence(this.getSelect())) {
            return this.getSelect();
        }
        this.adoptChildExpression(this.getSelect());
        if (this.getSelect().getItemType().isPlainType()) {
            return this.getSelect();
        }
        return this;
    }

    @Override
    public void export(ExpressionPresenter out) {
        out.startElement("copyOf", this);
        if (this.validation != 4) {
            out.emitAttribute("validation", Validation.toString(this.validation));
        }
        if (this.schemaType != null) {
            out.emitAttribute("type", this.schemaType.getStructuredQName());
        }
        FastStringBuffer fsb = new FastStringBuffer(16);
        if (this.requireDocumentOrElement) {
            fsb.append('p');
        }
        if (this.rejectDuplicateAttributes) {
            fsb.append('a');
        }
        if (this.readOnce) {
            fsb.append('o');
        }
        if (this.validating) {
            fsb.append('v');
        }
        if (this.copyLineNumbers) {
            fsb.append('l');
        }
        if (this.copyForUpdate) {
            fsb.append('u');
        }
        if (this.isSchemaAware) {
            fsb.append('s');
        }
        if (this.copyNamespaces) {
            fsb.append('c');
        }
        if (this.copyAccumulators) {
            fsb.append('m');
        }
        if (fsb.length() > 0) {
            out.emitAttribute("flags", fsb.toString());
        }
        this.getSelect().export(out);
        out.endElement();
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet result = super.addToPathMap(pathMap, pathMapNodeSet);
        result.setReturnable(false);
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        ItemType type = this.getItemType();
        if (th.relationship(type, NodeKindTest.ELEMENT) != 4 || th.relationship(type, NodeKindTest.DOCUMENT) != 4) {
            result.addDescendants();
        }
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Item item;
        Controller controller = context.getController();
        SequenceReceiver out = context.getReceiver();
        boolean copyBaseURI = out.getSystemId() == null;
        int copyOptions = 4;
        if (this.copyNamespaces) {
            copyOptions |= 2;
        }
        if (this.copyAccumulators) {
            copyOptions |= 0x10;
        }
        if (this.copyForUpdate) {
            copyOptions |= 8;
        }
        SequenceIterator iter = this.getSelect().iterate(context);
        block13: while ((item = iter.next()) != null) {
            if (item instanceof NodeInfo) {
                NodeInfo source = (NodeInfo)item;
                int kind = source.getNodeKind();
                if (this.requireDocumentOrElement && kind != 1 && kind != 9) {
                    XPathException e = new XPathException("Operand of validate expression must be a document or element node");
                    e.setXPathContext(context);
                    e.setErrorCode("XQTY0030");
                    throw e;
                }
                Configuration config = controller.getConfiguration();
                switch (kind) {
                    case 1: {
                        LocationCopier copier;
                        SequenceReceiver eval = out;
                        if (this.validating) {
                            ParseOptions options = new ParseOptions();
                            options.setSchemaValidationMode(this.validation);
                            options.setTopLevelType(this.schemaType);
                            options.setTopLevelElement(NameOfNode.makeName(source).getStructuredQName());
                            config.prepareValidationReporting(context, options);
                            eval = config.getElementValidator(out, options, this.getLocation());
                        }
                        if (copyBaseURI) {
                            eval.setSystemId(CopyOf.computeNewBaseUri(source, this.getStaticBaseURIString()));
                        }
                        SequenceReceiver savedReceiver = null;
                        PipelineConfiguration savedPipe = null;
                        if (this.copyLineNumbers) {
                            savedReceiver = eval;
                            PipelineConfiguration pipe = eval.getPipelineConfiguration();
                            savedPipe = new PipelineConfiguration(pipe);
                            copier = new LocationCopier(false);
                            pipe.setComponent(CopyInformee.class.getName(), copier);
                        }
                        source.copy(eval, copyOptions, this.getLocation());
                        if (!this.copyLineNumbers) continue block13;
                        eval = savedReceiver;
                        eval.setPipelineConfiguration(savedPipe);
                        continue block13;
                    }
                    case 2: {
                        XPathException e;
                        if (this.schemaType != null && this.schemaType.isComplexType()) {
                            XPathException e2 = new XPathException("When copying an attribute with schema validation, the requested type must not be a complex type");
                            e2.setLocation(this.getLocation());
                            e2.setXPathContext(context);
                            e2.setErrorCode("XTTE1535");
                            throw CopyOf.dynamicError(this.getLocation(), e2, context);
                        }
                        try {
                            CopyOf.copyAttribute(source, (SimpleType)this.schemaType, this.validation, this, context, this.rejectDuplicateAttributes);
                            continue block13;
                        }
                        catch (NoOpenStartTagException err) {
                            e = new XPathException(err.getMessage());
                            e.setLocation(this.getLocation());
                            e.setXPathContext(context);
                            e.setErrorCodeQName(err.getErrorCodeQName());
                            throw CopyOf.dynamicError(this.getLocation(), e, context);
                        }
                    }
                    case 3: {
                        out.characters(source.getStringValueCS(), this.getLocation(), 0);
                        continue block13;
                    }
                    case 7: {
                        if (copyBaseURI) {
                            out.setSystemId(source.getBaseURI());
                        }
                        out.processingInstruction(source.getDisplayName(), source.getStringValueCS(), this.getLocation(), 0);
                        continue block13;
                    }
                    case 8: {
                        out.comment(source.getStringValueCS(), this.getLocation(), 0);
                        continue block13;
                    }
                    case 13: {
                        XPathException e;
                        try {
                            source.copy(out, 0, this.getLocation());
                            continue block13;
                        }
                        catch (NoOpenStartTagException err) {
                            e = new XPathException(err.getMessage());
                            e.setXPathContext(context);
                            e.setErrorCodeQName(err.getErrorCodeQName());
                            throw CopyOf.dynamicError(this.getLocation(), e, context);
                        }
                    }
                    case 9: {
                        LocationCopier copier;
                        ParseOptions options = new ParseOptions();
                        options.setSchemaValidationMode(this.validation);
                        options.setStripSpace(0);
                        options.setTopLevelType(this.schemaType);
                        config.prepareValidationReporting(context, options);
                        Receiver val = config.getDocumentValidator(out, source.getBaseURI(), options);
                        if (copyBaseURI) {
                            val.setSystemId(source.getBaseURI());
                        }
                        Receiver savedReceiver = null;
                        PipelineConfiguration savedPipe = null;
                        if (this.copyLineNumbers) {
                            savedReceiver = val;
                            savedPipe = new PipelineConfiguration(val.getPipelineConfiguration());
                            copier = new LocationCopier(true);
                            val.getPipelineConfiguration().setComponent(CopyInformee.class.getName(), copier);
                        }
                        source.copy(val, copyOptions, this.getLocation());
                        if (!this.copyLineNumbers) continue block13;
                        val = savedReceiver;
                        val.setPipelineConfiguration(savedPipe);
                        continue block13;
                    }
                }
                throw new IllegalArgumentException("Unknown node kind " + source.getNodeKind());
            }
            out.append(item, this.getLocation(), 2);
        }
        return null;
    }

    public static String computeNewBaseUri(NodeInfo source, String staticBaseURI) {
        String newBaseUri;
        block6: {
            String xmlBase = source.getAttributeValue("http://www.w3.org/XML/1998/namespace", "base");
            if (xmlBase != null) {
                try {
                    URI xmlBaseUri = new URI(xmlBase);
                    if (xmlBaseUri.isAbsolute()) {
                        newBaseUri = xmlBase;
                        break block6;
                    }
                    if (staticBaseURI != null) {
                        URI sbu = new URI(staticBaseURI);
                        URI abs = sbu.resolve(xmlBaseUri);
                        newBaseUri = abs.toString();
                        break block6;
                    }
                    newBaseUri = source.getBaseURI();
                }
                catch (URISyntaxException err) {
                    newBaseUri = source.getBaseURI();
                }
            } else {
                newBaseUri = source.getBaseURI();
            }
        }
        return newBaseUri;
    }

    static void copyAttribute(NodeInfo source, SimpleType schemaType, int validation, Instruction instruction, XPathContext context, boolean rejectDuplicates) throws XPathException {
        int opt = 0;
        if (rejectDuplicates) {
            opt |= 0x20;
        }
        CharSequence value = source.getStringValueCS();
        SimpleType annotation = CopyOf.validateAttribute(source, schemaType, validation, context);
        try {
            context.getReceiver().attribute(NameOfNode.makeName(source), annotation, value, instruction.getLocation(), opt);
        }
        catch (XPathException e) {
            e.maybeSetContext(context);
            e.maybeSetLocation(instruction.getLocation());
            if (instruction.getHostLanguage() == 51 && e.getErrorCodeLocalPart().equals("XTTE0950")) {
                e.setErrorCode("XQTY0086");
            }
            throw e;
        }
    }

    public static SimpleType validateAttribute(NodeInfo source, SimpleType schemaType, int validation, XPathContext context) throws XPathException {
        CharSequence value = source.getStringValueCS();
        SimpleType annotation = BuiltInAtomicType.UNTYPED_ATOMIC;
        if (schemaType != null) {
            if (schemaType.isNamespaceSensitive()) {
                XPathException err = new XPathException("Cannot create a parentless attribute whose type is namespace-sensitive (such as xs:QName)");
                err.setErrorCode("XTTE1545");
                throw err;
            }
            ValidationFailure err = schemaType.validateContent(value, DummyNamespaceResolver.getInstance(), context.getConfiguration().getConversionRules());
            if (err != null) {
                ValidationException ve = new ValidationException("Attribute being copied does not match the required type. " + err.getMessage());
                ve.setErrorCodeQName(err.getErrorCodeQName());
                throw ve;
            }
            annotation = schemaType;
        } else if (validation == 1 || validation == 2) {
            try {
                annotation = context.getConfiguration().validateAttribute(NameOfNode.makeName(source).getStructuredQName(), value, validation);
            }
            catch (ValidationException e) {
                XPathException err = XPathException.makeXPathException(e);
                err.setErrorCodeQName(e.getErrorCodeQName());
                err.setIsTypeError(true);
                throw err;
            }
        } else if (validation == 3 && !(annotation = (SimpleType)source.getSchemaType()).equals(BuiltInAtomicType.UNTYPED_ATOMIC) && annotation.isNamespaceSensitive()) {
            XPathException err = new XPathException("Cannot preserve type annotation when copying an attribute with namespace-sensitive content");
            err.setErrorCode(context.getController().getExecutable().getHostLanguage() == 50 ? "XTTE0950" : "XQTY0086");
            err.setIsTypeError(true);
            throw err;
        }
        return annotation;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        if (this.schemaType == null && this.copyNamespaces && !this.copyForUpdate) {
            if (this.validation == 3) {
                ItemMappingFunction<Item, Item> copier = new ItemMappingFunction<Item, Item>(){

                    @Override
                    public Item mapItem(Item item) {
                        if (item instanceof NodeInfo) {
                            VirtualCopy vc = VirtualCopy.makeVirtualCopy((NodeInfo)item);
                            vc.getTreeInfo().setCopyAccumulators(CopyOf.this.copyAccumulators);
                            if (((NodeInfo)item).getNodeKind() == 1) {
                                vc.setSystemId(CopyOf.computeNewBaseUri((NodeInfo)item, CopyOf.this.getStaticBaseURIString()));
                            }
                            return vc;
                        }
                        return item;
                    }
                };
                return new ItemMappingIterator<Item, Item>(this.getSelect().iterate(context), copier, true);
            }
            if (this.validation == 4) {
                ItemMappingFunction<Item, Item> copier = new ItemMappingFunction<Item, Item>(){

                    @Override
                    public Item mapItem(Item item) {
                        if (!(item instanceof NodeInfo)) {
                            return item;
                        }
                        VirtualCopy vc = VirtualUntypedCopy.makeVirtualUntypedTree((NodeInfo)item, (NodeInfo)item);
                        vc.getTreeInfo().setCopyAccumulators(CopyOf.this.copyAccumulators);
                        if (((NodeInfo)item).getNodeKind() == 1) {
                            vc.setSystemId(CopyOf.computeNewBaseUri((NodeInfo)item, CopyOf.this.getStaticBaseURIString()));
                        }
                        return vc;
                    }
                };
                return new ItemMappingIterator<Item, Item>(this.getSelect().iterate(context), copier, true);
            }
        }
        SequenceReceiver saved = context.getReceiver();
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setLocationIsCodeLocation(true);
        SequenceOutputter out = new SequenceOutputter(pipe);
        pipe.setHostLanguage(this.getHostLanguage());
        context.setReceiver(out);
        try {
            this.process(context);
        }
        catch (XPathException err) {
            if (err instanceof ValidationException) {
                ((ValidationException)err).setLocation(this.getLocation());
                ((ValidationException)err).setSystemId(this.getSystemId());
            }
            err.maybeSetLocation(this.getLocation());
            throw err;
        }
        context.setReceiver(saved);
        return out.getSequence().iterate();
    }
}

