/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.evpull.EndDocumentEvent;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorToReceiver;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.StartDocumentEvent;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.pull.UnparsedEntity;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.Untyped;

public class StaxToEventBridge
implements EventIterator,
SourceLocator {
    private Configuration config;
    private XMLStreamReader reader;
    private PipelineConfiguration pipe;
    private List unparsedEntities = null;
    PullEvent currentEvent = null;
    int depth = 0;
    boolean ignoreIgnorable = false;

    public void setInputStream(String systemId, InputStream inputStream) throws XPathException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setXMLReporter(new StaxErrorReporter());
            this.reader = factory.createXMLStreamReader(systemId, inputStream);
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public void setXMLStreamReader(XMLStreamReader reader) {
        this.reader = reader;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = new PipelineConfiguration(pipe);
        this.config = pipe.getConfiguration();
        this.ignoreIgnorable = this.config.getStripsWhiteSpace() != 0;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.reader;
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    public PullEvent next() throws XPathException {
        if (this.currentEvent == null) {
            this.currentEvent = StartDocumentEvent.getInstance();
            return this.currentEvent;
        }
        if (this.currentEvent instanceof EndDocumentEvent) {
            try {
                this.reader.close();
            }
            catch (XMLStreamException e) {
                // empty catch block
            }
            return null;
        }
        try {
            if (this.reader.hasNext()) {
                int event = this.reader.next();
                this.currentEvent = this.translate(event);
            } else {
                this.currentEvent = null;
            }
        }
        catch (XMLStreamException e) {
            int c;
            String message = e.getMessage();
            if (message.startsWith("ParseError at") && (c = message.indexOf("\nMessage: ")) > 0) {
                message = message.substring(c + 10);
            }
            XPathException err = new XPathException("Error reported by XML parser: " + message);
            err.setErrorCode("SXXP0003");
            err.setLocator(this.translateLocation(e.getLocation()));
            throw err;
        }
        return this.currentEvent;
    }

    private PullEvent translate(int event) throws XPathException {
        switch (event) {
            case 10: {
                return this.next();
            }
            case 4: 
            case 12: {
                if (this.depth == 0 && this.reader.isWhiteSpace()) {
                    return this.next();
                }
                Orphan o = new Orphan(this.config);
                o.setNodeKind((short)3);
                CharSlice value = new CharSlice(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                o.setStringValue(value);
                return o;
            }
            case 5: {
                Orphan o = new Orphan(this.config);
                o.setNodeKind((short)8);
                CharSlice value = new CharSlice(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                o.setStringValue(value);
                return o;
            }
            case 11: {
                this.unparsedEntities = (List)this.reader.getProperty("javax.xml.stream.entities");
                return this.next();
            }
            case 8: {
                return EndDocumentEvent.getInstance();
            }
            case 2: {
                --this.depth;
                return EndElementEvent.getInstance();
            }
            case 15: {
                return this.next();
            }
            case 9: {
                return this.next();
            }
            case 13: {
                return this.next();
            }
            case 14: {
                return this.next();
            }
            case 3: {
                Orphan o = new Orphan(this.config);
                o.setNodeKind((short)7);
                String local = this.reader.getPITarget();
                o.setNodeName(new NoNamespaceName(local));
                o.setStringValue(this.reader.getText());
                return o;
            }
            case 6: {
                if (this.depth == 0) {
                    return this.next();
                }
                if (this.ignoreIgnorable) {
                    return this.next();
                }
                Orphan o = new Orphan(this.config);
                o.setNodeKind((short)3);
                o.setStringValue(this.reader.getText());
                return o;
            }
            case 7: {
                return this.next();
            }
            case 1: {
                ++this.depth;
                StartElementEvent see = new StartElementEvent(this.pipe);
                String elocal = this.reader.getLocalName();
                String euri = this.reader.getNamespaceURI();
                String eprefix = this.reader.getPrefix();
                if (eprefix == null) {
                    eprefix = "";
                }
                if (euri == null) {
                    euri = "";
                }
                see.setElementName(new FingerprintedQName(eprefix, euri, elocal));
                see.setTypeCode(Untyped.getInstance());
                int attCount = this.reader.getAttributeCount();
                for (int index = 0; index < attCount; ++index) {
                    String local = this.reader.getAttributeLocalName(index);
                    String uri = this.reader.getAttributeNamespace(index);
                    String prefix = this.reader.getAttributePrefix(index);
                    if (prefix == null) {
                        prefix = "";
                    }
                    if (uri == null) {
                        uri = "";
                    }
                    Orphan o = new Orphan(this.config);
                    o.setNodeKind((short)2);
                    o.setNodeName(new FingerprintedQName(prefix, uri, local));
                    o.setStringValue(this.reader.getAttributeValue(index));
                    see.addAttribute(o);
                }
                see.namespaceFixup();
                return see;
            }
        }
        throw new IllegalStateException("Unknown StAX event " + event);
    }

    public String getPublicId() {
        return this.reader.getLocation().getPublicId();
    }

    public String getSystemId() {
        return this.reader.getLocation().getSystemId();
    }

    public int getLineNumber() {
        return this.reader.getLocation().getLineNumber();
    }

    public int getColumnNumber() {
        return this.reader.getLocation().getColumnNumber();
    }

    public String getSystemId(int locationId) {
        return this.getSystemId();
    }

    public int getLineNumber(int locationId) {
        return this.getLineNumber();
    }

    public int getColumnNumber(int locationId) {
        return this.getColumnNumber();
    }

    public List getUnparsedEntities() {
        if (this.unparsedEntities == null) {
            return null;
        }
        ArrayList<UnparsedEntity> list = new ArrayList<UnparsedEntity>(this.unparsedEntities.size());
        for (int i = 0; i < this.unparsedEntities.size(); ++i) {
            Object ent = this.unparsedEntities.get(i);
            String name = null;
            String systemId = null;
            String publicId = null;
            String baseURI = null;
            if (ent instanceof EntityDeclaration) {
                EntityDeclaration ed = (EntityDeclaration)ent;
                name = ed.getName();
                systemId = ed.getSystemId();
                publicId = ed.getPublicId();
                baseURI = ed.getBaseURI();
            } else if (ent.getClass().getName().equals("com.ctc.wstx.ent.UnparsedExtEntity")) {
                try {
                    Class<?> woodstoxClass = ent.getClass();
                    Class[] noArgs = new Class[]{};
                    Method method = woodstoxClass.getMethod("getName", noArgs);
                    name = (String)method.invoke(ent, (Object[])noArgs);
                    method = woodstoxClass.getMethod("getSystemId", noArgs);
                    systemId = (String)method.invoke(ent, (Object[])noArgs);
                    method = woodstoxClass.getMethod("getPublicId", noArgs);
                    publicId = (String)method.invoke(ent, (Object[])noArgs);
                    method = woodstoxClass.getMethod("getBaseURI", noArgs);
                    baseURI = (String)method.invoke(ent, (Object[])noArgs);
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
            if (name == null) continue;
            try {
                systemId = new URI(baseURI).resolve(systemId).toString();
            }
            catch (URISyntaxException err) {
                // empty catch block
            }
            UnparsedEntity ue = new UnparsedEntity();
            ue.setName(name);
            ue.setSystemId(systemId);
            ue.setPublicId(publicId);
            ue.setBaseURI(baseURI);
            list.add(ue);
        }
        return list;
    }

    private ExplicitLocation translateLocation(Location location) {
        if (location == null) {
            return ExplicitLocation.UNKNOWN_LOCATION;
        }
        return new ExplicitLocation(location.getSystemId(), location.getLineNumber(), location.getColumnNumber());
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 1; ++i) {
            long startTime = System.currentTimeMillis();
            PipelineConfiguration pipe = new Configuration().makePipelineConfiguration();
            StaxToEventBridge puller = new StaxToEventBridge();
            File f = new File(args[0]);
            puller.setInputStream(f.toURI().toString(), new FileInputStream(f));
            puller.setPipelineConfiguration(pipe);
            XMLEmitter emitter = new XMLEmitter();
            emitter.setPipelineConfiguration(pipe);
            emitter.setOutputProperties(new Properties());
            if (args.length > 1) {
                emitter.setOutputStream(new FileOutputStream(args[1]));
            } else {
                emitter.setOutputStream(System.out);
            }
            NamespaceReducer r = new NamespaceReducer(emitter);
            EventIteratorToReceiver.copy(puller, r);
            System.err.println("Elapsed time: " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    public boolean isFlatSequence() {
        return false;
    }

    private class StaxErrorReporter
    implements XMLReporter {
        private StaxErrorReporter() {
        }

        public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
            ExplicitLocation loc = StaxToEventBridge.this.translateLocation(location);
            XPathException err = new XPathException("Error reported by XML parser: " + message + " (" + errorType + ')');
            err.setLocator(loc);
            StaxToEventBridge.this.pipe.getErrorListener().error(err);
        }
    }
}

