/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.json.JsonHandler;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntPredicate;

public class JsonParser {
    private IntPredicate charChecker;
    public static final int ESCAPE = 1;
    public static final int ALLOW_ANY_TOP_LEVEL = 2;
    public static final int LIBERAL = 4;
    public static final int VALIDATE = 8;
    public static final int DEBUG = 16;
    public static final int DUPLICATES_RETAINED = 32;
    public static final int DUPLICATES_LAST = 64;
    public static final int DUPLICATES_FIRST = 128;
    public static final int DUPLICATES_REJECTED = 256;
    public static final int DUPLICATES_SPECIFIED = 480;
    private static final String ERR_GRAMMAR = "FOJS0001";
    private static final String ERR_DUPLICATE = "FOJS0003";
    private static final String ERR_SCHEMA = "FOJS0004";
    private static final String ERR_OPTIONS = "FOJS0005";
    private static final Map<String, SequenceType> requiredTypes = new HashMap<String, SequenceType>(20);
    private static String[] optionNames;

    public JsonParser(IntPredicate charChecker) {
        this.charChecker = charChecker;
    }

    public void parse(String input, int flags, JsonHandler handler, XPathContext context) throws XPathException {
        if (input.isEmpty()) {
            this.invalidJSON("An empty string is not valid JSON", ERR_GRAMMAR);
        }
        JsonTokenizer t = new JsonTokenizer(input);
        t.next();
        this.parseConstruct(handler, t, flags, true, context);
        if (t.next() != 999) {
            this.invalidJSON("Unexpected token beyond end of JSON input", ERR_GRAMMAR);
        }
    }

    public static int getFlags(MapItem options, XPathContext context, Boolean allowValidate) throws XPathException {
        String duplicates;
        boolean escape;
        int flags = 0;
        if (JsonParser.getBooleanOption(options, "debug", false)) {
            flags |= 0x10;
        }
        if (escape = JsonParser.getBooleanOption(options, "escape", false)) {
            flags |= 1;
            if (options.get(new StringValue("fallback")) != null) {
                throw new XPathException("Cannot specify a fallback function when escape=true", ERR_OPTIONS);
            }
        }
        if (JsonParser.getBooleanOption(options, "liberal", false)) {
            flags |= 4;
            flags |= 2;
        }
        boolean validate = false;
        if (allowValidate.booleanValue() && (validate = JsonParser.getBooleanOption(options, "validate", false))) {
            if (!context.getController().getExecutable().isSchemaAware()) {
                JsonParser.error("Requiring validation on non-schema-aware processor", ERR_SCHEMA);
            }
            flags |= 8;
        }
        if ((duplicates = JsonParser.getStringOption(options, "duplicates", null, context.getConfiguration().getTypeHierarchy())) != null) {
            if ("reject".equals(duplicates)) {
                flags |= 0x100;
            } else if ("use-last".equals(duplicates)) {
                flags |= 0x40;
            } else if ("use-first".equals(duplicates)) {
                flags |= 0x80;
            } else if ("retain".equals(duplicates)) {
                flags |= 0x20;
            } else {
                JsonParser.error("Invalid value for 'duplicates' option", ERR_OPTIONS);
            }
        }
        if (validate && "retain".equals(duplicates)) {
            JsonParser.error("The options validate:true and duplicates:retain cannot be used together", ERR_OPTIONS);
        }
        return flags;
    }

    private static String getStringOption(MapItem options, String option, String defaultValue, TypeHierarchy th) throws XPathException {
        StringValue ov = new StringValue(option);
        Sequence val = options.get(ov);
        if (val != null) {
            RoleDiagnostic role = new RoleDiagnostic(15, option, 0);
            role.setErrorCode(ERR_OPTIONS);
            Sequence converted = th.applyFunctionConversionRules(val, SequenceType.SINGLE_STRING, role, ExplicitLocation.UNKNOWN_LOCATION);
            converted = SequenceTool.toGroundedValue(converted);
            return converted.head().getStringValue();
        }
        return defaultValue;
    }

    private static boolean getBooleanOption(MapItem options, String option, boolean defaultValue) throws XPathException {
        StringValue ov = new StringValue(option);
        Sequence val = options.get(ov);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof BooleanValue) {
            return ((BooleanValue)val).getBooleanValue();
        }
        JsonParser.error("Value of option '" + option + "' is not xs:boolean", ERR_OPTIONS);
        return defaultValue;
    }

    private void parseConstruct(JsonHandler handler, JsonTokenizer tokenizer, int flags, boolean toplevel, XPathContext context) throws XPathException {
        boolean debug = (flags & 0x10) != 0;
        boolean checkAllowedAtTopLevel = false;
        if (debug) {
            System.err.println("token:" + tokenizer.currentToken + " :" + tokenizer.currentTokenValue);
        }
        switch (tokenizer.currentToken) {
            case 3: {
                this.parseObject(handler, tokenizer, flags, context);
                break;
            }
            case 1: {
                this.parseArray(handler, tokenizer, flags, context);
                break;
            }
            case 6: {
                if (checkAllowedAtTopLevel) {
                    this.disallowedAtTopLevel();
                }
                double d = this.parseNumericLiteral(tokenizer.currentTokenValue.toString(), flags);
                handler.writeNumeric(tokenizer.currentTokenValue.toString(), d);
                break;
            }
            case 7: {
                if (checkAllowedAtTopLevel) {
                    this.disallowedAtTopLevel();
                }
                handler.writeBoolean(true);
                break;
            }
            case 8: {
                if (checkAllowedAtTopLevel) {
                    this.disallowedAtTopLevel();
                }
                handler.writeBoolean(false);
                break;
            }
            case 9: {
                if (checkAllowedAtTopLevel) {
                    this.disallowedAtTopLevel();
                }
                handler.writeNull();
                break;
            }
            case 5: {
                if (checkAllowedAtTopLevel) {
                    this.disallowedAtTopLevel();
                }
                String literal = tokenizer.currentTokenValue.toString();
                handler.writeString(JsonParser.unescape(literal, flags, ERR_GRAMMAR));
                break;
            }
            default: {
                this.invalidJSON("Unexpected symbol: " + tokenizer.currentTokenValue, ERR_GRAMMAR);
            }
        }
    }

    private void disallowedAtTopLevel() throws XPathException {
        this.invalidJSON("Top-level JSON value must be an object or array", ERR_GRAMMAR);
    }

    private void parseObject(JsonHandler handler, JsonTokenizer tokenizer, int flags, XPathContext context) throws XPathException {
        boolean liberal = (flags & 4) != 0;
        handler.startMap();
        int tok = tokenizer.next();
        while (tok != 4) {
            if (tok != 5) {
                this.invalidJSON("Property name must be a string literal", ERR_GRAMMAR);
            }
            String key = tokenizer.currentTokenValue.toString();
            key = JsonParser.unescape(key, flags, ERR_GRAMMAR);
            String reEscaped = handler.reEscape(key, true);
            tok = tokenizer.next();
            if (tok != 10) {
                this.invalidJSON("Missing colon after \"" + Err.wrap(key) + "\"", ERR_GRAMMAR);
            }
            tokenizer.next();
            boolean duplicate = handler.setKey(key, reEscaped);
            if (duplicate && (flags & 0x100) != 0) {
                this.invalidJSON("Duplicate key value \"" + Err.wrap(key) + "\"", ERR_DUPLICATE);
            }
            if (!duplicate || (flags & 0x60) != 0) {
                this.parseConstruct(handler, tokenizer, flags, false, context);
            } else {
                this.parseConstruct(new JsonHandler(), tokenizer, flags, false, context);
            }
            tok = tokenizer.next();
            if (tok == 11) {
                tok = tokenizer.next();
                if (tok != 4) continue;
                if (liberal) break;
                this.invalidJSON("Trailing comma after entry in object", ERR_GRAMMAR);
                continue;
            }
            if (tok == 4) break;
            this.invalidJSON("Unexpected token after value of \"" + Err.wrap(key) + "\" property", ERR_GRAMMAR);
        }
        handler.endMap();
    }

    private void parseArray(JsonHandler handler, JsonTokenizer tokenizer, int flags, XPathContext context) throws XPathException {
        boolean liberal = (flags & 4) != 0;
        handler.startArray();
        int tok = tokenizer.next();
        if (tok == 2) {
            handler.endArray();
            return;
        }
        while (true) {
            this.parseConstruct(handler, tokenizer, flags, false, context);
            tok = tokenizer.next();
            if (tok == 11) {
                tok = tokenizer.next();
                if (tok != 2) continue;
                if (liberal) break;
                this.invalidJSON("Trailing comma after entry in array", ERR_GRAMMAR);
                continue;
            }
            if (tok == 2) break;
            this.invalidJSON("Unexpected token after entry in array", ERR_GRAMMAR);
        }
        handler.endArray();
    }

    private double parseNumericLiteral(String token, int flags) throws XPathException {
        try {
            if ((flags & 4) == 0) {
                if (token.startsWith("+")) {
                    this.invalidJSON("Leading + sign not allowed: " + token, ERR_GRAMMAR);
                } else {
                    String t = token;
                    if (t.startsWith("-")) {
                        t = t.substring(1);
                    }
                    if (!(!t.startsWith("0") || t.equals("0") || t.startsWith("0.") || t.startsWith("0e") || t.startsWith("0E"))) {
                        this.invalidJSON("Redundant leading zeroes not allowed: " + token, ERR_GRAMMAR);
                    }
                    if (t.endsWith(".") || t.contains(".e") || t.contains(".E")) {
                        this.invalidJSON("Empty fractional part not allowed", ERR_GRAMMAR);
                    }
                    if (t.startsWith(".")) {
                        this.invalidJSON("Empty integer part not allowed", ERR_GRAMMAR);
                    }
                }
            }
            return StringToDouble.getInstance().stringToNumber(token);
        }
        catch (NumberFormatException e) {
            this.invalidJSON("Invalid numeric literal: " + e.getMessage(), ERR_GRAMMAR);
            return Double.NaN;
        }
    }

    public static String unescape(String literal, int flags, String errorCode) throws XPathException {
        if (literal.indexOf(92) < 0) {
            return literal;
        }
        boolean liberal = (flags & 4) != 0;
        FastStringBuffer buffer = new FastStringBuffer(literal.length());
        block13: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (c == '\\') {
                if (i++ == literal.length() - 1) {
                    throw new XPathException("Invalid JSON escape: String " + Err.wrap(literal) + " ends in backslash", errorCode);
                }
                switch (literal.charAt(i)) {
                    case '\"': {
                        buffer.append('\"');
                        continue block13;
                    }
                    case '\\': {
                        buffer.append('\\');
                        continue block13;
                    }
                    case '/': {
                        buffer.append('/');
                        continue block13;
                    }
                    case 'b': {
                        buffer.append('\b');
                        continue block13;
                    }
                    case 'f': {
                        buffer.append('\f');
                        continue block13;
                    }
                    case 'n': {
                        buffer.append('\n');
                        continue block13;
                    }
                    case 'r': {
                        buffer.append('\r');
                        continue block13;
                    }
                    case 't': {
                        buffer.append('\t');
                        continue block13;
                    }
                    case 'u': {
                        try {
                            String hex = literal.substring(i + 1, i + 5);
                            int code = Integer.parseInt(hex, 16);
                            buffer.append((char)code);
                            i += 4;
                            continue block13;
                        }
                        catch (Exception e) {
                            if (liberal) {
                                buffer.append("\\u");
                                continue block13;
                            }
                            throw new XPathException("Invalid JSON escape: \\u must be followed by four hex characters", errorCode);
                        }
                    }
                    default: {
                        if (liberal) {
                            buffer.append(c);
                            continue block13;
                        }
                        throw new XPathException("Unknown escape sequence \\" + literal.charAt(i), errorCode);
                    }
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static void error(String message, String code) throws XPathException {
        throw new XPathException(message, code);
    }

    private void invalidJSON(String message, String code) throws XPathException {
        JsonParser.error("Invalid JSON input: " + message, code);
    }

    private static boolean isOptionName(String string) {
        for (String s : optionNames) {
            if (!s.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static MapItem checkOptions(MapItem map, XPathContext context) throws XPathException {
        AtomicValue key;
        HashTrieMap result = new HashTrieMap(context);
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        AtomicIterator keysIterator = map.keys();
        while ((key = keysIterator.next()) != null && key instanceof StringValue) {
            String keyName = key.getStringValue();
            if (!JsonParser.isOptionName(keyName)) continue;
            RoleDiagnostic role = new RoleDiagnostic(15, keyName, 0);
            role.setErrorCode("XPTY0004");
            Sequence converted = th.applyFunctionConversionRules(map.get(key), requiredTypes.get(keyName), role, ExplicitLocation.UNKNOWN_LOCATION);
            converted = SequenceTool.toGroundedValue(converted);
            result = result.addEntry(key, converted);
        }
        return result;
    }

    static {
        requiredTypes.put("liberal", SequenceType.SINGLE_BOOLEAN);
        requiredTypes.put("duplicates", SequenceType.SINGLE_STRING);
        requiredTypes.put("validate", SequenceType.SINGLE_BOOLEAN);
        requiredTypes.put("escape", SequenceType.SINGLE_BOOLEAN);
        requiredTypes.put("fallback", SequenceType.makeSequenceType(new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_STRING}, SequenceType.SINGLE_STRING), 16384));
        optionNames = new String[]{"liberal", "duplicates", "validate", "escape", "fallback"};
    }

    private class JsonTokenizer {
        private String input;
        private int position;
        public int currentToken;
        public FastStringBuffer currentTokenValue = new FastStringBuffer(64);
        private static final int LSQB = 1;
        private static final int RSQB = 2;
        public static final int LCURLY = 3;
        public static final int RCURLY = 4;
        public static final int STRING_LITERAL = 5;
        public static final int NUMERIC_LITERAL = 6;
        public static final int TRUE = 7;
        public static final int FALSE = 8;
        public static final int NULL = 9;
        public static final int COLON = 10;
        public static final int COMMA = 11;
        public static final int EOF = 999;

        public JsonTokenizer(String input) {
            this.input = input;
            this.position = 0;
            if (input.length() > 0 && input.charAt(0) == '\ufeff') {
                ++this.position;
            }
        }

        public int next() throws XPathException {
            this.currentToken = this.readToken();
            return this.currentToken;
        }

        private int readToken() throws XPathException {
            if (this.position >= this.input.length()) {
                return 999;
            }
            while (Whitespace.isWhitespace(this.input.charAt(this.position))) {
                if (++this.position < this.input.length()) continue;
                return 999;
            }
            char ch = this.input.charAt(this.position++);
            switch (ch) {
                case '[': {
                    return 1;
                }
                case '{': {
                    return 3;
                }
                case ']': {
                    return 2;
                }
                case '}': {
                    return 4;
                }
                case '\"': {
                    this.currentTokenValue.setLength(0);
                    boolean afterBackslash = false;
                    while (true) {
                        char c = this.input.charAt(this.position++);
                        if (afterBackslash && c == 'u') {
                            try {
                                String hex = this.input.substring(this.position, this.position + 4);
                                int code = Integer.parseInt(hex, 16);
                            }
                            catch (Exception e) {
                                JsonParser.this.invalidJSON("\\u must be followed by four hex characters", JsonParser.ERR_GRAMMAR);
                            }
                        }
                        if (c == '\"' && !afterBackslash) break;
                        this.currentTokenValue.append(c);
                        boolean bl = afterBackslash = c == '\\' && !afterBackslash;
                        if (this.position < this.input.length()) continue;
                        JsonParser.this.invalidJSON("Unclosed quotes in string literal", JsonParser.ERR_GRAMMAR);
                    }
                    return 5;
                }
                case ':': {
                    return 10;
                }
                case ',': {
                    return 11;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.currentTokenValue.setLength(0);
                    this.currentTokenValue.append(ch);
                    if (this.position < this.input.length()) {
                        char c;
                        while ((c = this.input.charAt(this.position)) >= '0' && c <= '9' || c == '-' || c == '+' || c == '.' || c == 'e' || c == 'E') {
                            this.currentTokenValue.append(c);
                            if (++this.position < this.input.length()) continue;
                            break;
                        }
                    }
                    return 6;
                }
                case 'f': 
                case 'n': 
                case 't': {
                    String val;
                    char c;
                    this.currentTokenValue.setLength(0);
                    this.currentTokenValue.append(ch);
                    while ((c = this.input.charAt(this.position)) >= 'a' && c <= 'z') {
                        this.currentTokenValue.append(c);
                        if (++this.position < this.input.length()) continue;
                        break;
                    }
                    if ((val = this.currentTokenValue.toString()).equals("true")) {
                        return 7;
                    }
                    if (val.equals("false")) {
                        return 8;
                    }
                    if (val.equals("null")) {
                        return 9;
                    }
                    JsonParser.error("Unknown constant " + this.currentTokenValue, JsonParser.ERR_GRAMMAR);
                }
            }
            char c = this.input.charAt(--this.position);
            JsonParser.this.invalidJSON("Unexpected character '" + c + "' (\\u" + Integer.toHexString(c) + ") at position " + this.position, JsonParser.ERR_GRAMMAR);
            return -1;
        }
    }
}

